#ifndef QL_API_QL_BASE_H
#define QL_API_QL_BASE_H

namespace QL
{
    QL_API bool		 valid_number(number_t);
    QL_API bool		 valid_logical(logical_t);
    QL_API bool		 valid_date(date_t);
    QL_API bool		 valid_month(month_t);
    QL_API bool		 valid_timestamp(timestamp_t);
    QL_API bool		 valid_enum(enum_t);

    QL_API number_t	 null_number();
    QL_API logical_t	 null_logical();
    QL_API date_t	 null_date();
    QL_API month_t	 null_month();
    QL_API timestamp_t	 null_timestamp();
    QL_API enum_t	 null_enum();

    /**/

    QL_API handle	 create_string(const char*);
    QL_API handle	 create_string(const char*, int_t len);
    QL_API handle	 create_string(const wchar_t*);
    QL_API const char	*get_string(const object&);
    QL_API const char	*get_string_0(const object*);
    QL_API int_t	 get_strlen(const object&);

    /**/

    QL_API int_t	 max_aggregate_size();

    QL_API int_t	 get_v_size(const object&);
    QL_API bool		 get_v_val(const object&, int_t,
				   num_val_t&, handle&);

    QL_API void		 set_v_val(object&, int_t, num_val_t, object*);

    QL_API void		 get_m_size(const object&, int_t &n_r, int_t &n_c);
    QL_API bool		 get_m_val(const object&, int_t, int_t,
				   num_val_t&, handle&);

    QL_API void		 set_m_val(object&, int_t, int_t, num_val_t, object*);

    QL_API double	 get_s_x0(const object&);
    QL_API double	 get_s_dx(const object&);
    QL_API double	 get_s_x(const object&, int_t);
    QL_API int_t	 get_s_size(const object&);
    QL_API bool		 get_s_val(const object&, int_t,
				   num_val_t&, handle&);

    QL_API void		 set_s_val(object&, int_t, num_val_t, object*);

    QL_API ref_t	 get_raw_data(object&);

    /**/

    QL_API handle	 create_v_i(int_t);
    QL_API handle	 create_v_n(int_t);
    QL_API handle	 create_v_l(int_t);
    QL_API handle	 create_v_d(int_t);
    QL_API handle	 create_v_m(int_t);
    QL_API handle	 create_v_t(int_t);
    QL_API handle	 create_v_e(int_t);
    QL_API handle	 create_v_s(int_t);
    QL_API handle	 create_v_o(int_t);
    QL_API handle	 create_v_f(int_t);

    QL_API int_t	 get_v_i(const object&, int_t);
    QL_API number_t	 get_v_n(const object&, int_t);
    QL_API logical_t	 get_v_l(const object&, int_t);
    QL_API date_t	 get_v_d(const object&, int_t);
    QL_API month_t	 get_v_m(const object&, int_t);
    QL_API timestamp_t	 get_v_t(const object&, int_t);
    QL_API enum_t	 get_v_e(const object&, int_t);
    QL_API handle	 get_v_s(const object&, int_t);
    QL_API handle	 get_v_o(const object&, int_t);
    QL_API handle	 get_v_f(const object&, int_t);

    QL_API void		 set_v_i(object&, int_t, int_t);
    QL_API void		 set_v_n(object&, int_t, number_t);
    QL_API void		 set_v_l(object&, int_t, logical_t);
    QL_API void		 set_v_d(object&, int_t, date_t);
    QL_API void		 set_v_m(object&, int_t, month_t);
    QL_API void		 set_v_t(object&, int_t, timestamp_t);
    QL_API void		 set_v_e(object&, int_t, enum_t);
    QL_API void		 set_v_s(object&, int_t, object*);
    QL_API void		 set_v_o(object&, int_t, object*);
    QL_API void		 set_v_f(object&, int_t, object*);

    /**/

    QL_API handle	 create_m_i(int_t, int_t);
    QL_API handle	 create_m_n(int_t, int_t);
    QL_API handle	 create_m_l(int_t, int_t);
    QL_API handle	 create_m_d(int_t, int_t);
    QL_API handle	 create_m_m(int_t, int_t);
    QL_API handle	 create_m_t(int_t, int_t);
    QL_API handle	 create_m_e(int_t, int_t);
    QL_API handle	 create_m_s(int_t, int_t);
    QL_API handle	 create_m_o(int_t, int_t);
    QL_API handle	 create_m_f(int_t, int_t);

    QL_API int_t	 get_m_i(const object&, int_t, int_t);
    QL_API number_t	 get_m_n(const object&, int_t, int_t);
    QL_API logical_t	 get_m_l(const object&, int_t, int_t);
    QL_API date_t	 get_m_d(const object&, int_t, int_t);
    QL_API month_t	 get_m_m(const object&, int_t, int_t);
    QL_API timestamp_t	 get_m_t(const object&, int_t, int_t);
    QL_API enum_t	 get_m_e(const object&, int_t, int_t);
    QL_API handle	 get_m_s(const object&, int_t, int_t);
    QL_API handle	 get_m_o(const object&, int_t, int_t);
    QL_API handle	 get_m_f(const object&, int_t, int_t);

    QL_API void		 set_m_i(object&, int_t, int_t, int_t);
    QL_API void		 set_m_n(object&, int_t, int_t, number_t);
    QL_API void		 set_m_l(object&, int_t, int_t, logical_t);
    QL_API void		 set_m_d(object&, int_t, int_t, date_t);
    QL_API void		 set_m_m(object&, int_t, int_t, month_t);
    QL_API void		 set_m_t(object&, int_t, int_t, timestamp_t);
    QL_API void		 set_m_e(object&, int_t, int_t, enum_t);
    QL_API void		 set_m_s(object&, int_t, int_t, object*);
    QL_API void		 set_m_o(object&, int_t, int_t, object*);
    QL_API void		 set_m_f(object&, int_t, int_t, object*);

    /**/

    QL_API double	 min_series_step();
    QL_API int_t	 calc_s_size(int_t ix_type,
				     double x0, double x1, double dx);

    QL_API handle	 create_s_i(double x0, double dx, int_t);
    QL_API handle	 create_s_n(double x0, double dx, int_t);
    QL_API handle	 create_s_l(double x0, double dx, int_t);
    QL_API handle	 create_s_d(double x0, double dx, int_t);
    QL_API handle	 create_s_m(double x0, double dx, int_t);
    QL_API handle	 create_s_t(double x0, double dx, int_t);
    QL_API handle	 create_s_e(double x0, double dx, int_t);
    QL_API handle	 create_s_s(double x0, double dx, int_t);
    QL_API handle	 create_s_o(double x0, double dx, int_t);
    QL_API handle	 create_s_f(double x0, double dx, int_t);

    QL_API int_t	 get_s_i(const object&, int_t);
    QL_API number_t	 get_s_n(const object&, int_t);
    QL_API logical_t	 get_s_l(const object&, int_t);
    QL_API date_t	 get_s_d(const object&, int_t);
    QL_API month_t	 get_s_m(const object&, int_t);
    QL_API timestamp_t	 get_s_t(const object&, int_t);
    QL_API enum_t	 get_s_e(const object&, int_t);
    QL_API handle	 get_s_s(const object&, int_t);
    QL_API handle	 get_s_o(const object&, int_t);
    QL_API handle	 get_s_f(const object&, int_t);

    QL_API void		 set_s_i(object&, int_t, int_t);
    QL_API void		 set_s_n(object&, int_t, number_t);
    QL_API void		 set_s_l(object&, int_t, logical_t);
    QL_API void		 set_s_d(object&, int_t, date_t);
    QL_API void		 set_s_m(object&, int_t, month_t);
    QL_API void		 set_s_t(object&, int_t, timestamp_t);
    QL_API void		 set_s_e(object&, int_t, enum_t);
    QL_API void		 set_s_s(object&, int_t, object*);
    QL_API void		 set_s_o(object&, int_t, object*);
    QL_API void		 set_s_f(object&, int_t, object*);

    /**/

#if QL_NATIVE_API
    class eval_ctxt;

    QL_API void		 call_function(const object	&func,
				       num_val_t	&result_n,
				       handle		&result_o,
				       num_val_t	*args_n,
				       handle		*args_o,
				       eval_ctxt	&ctxt);
#endif

    /**/

    QL_API const char	*error_type_to_str(error_t);

    QL_API handle	 error(error_t, const char *message);
    QL_API handle	 error(error_t, object &message);
    QL_API handle	 error(error_t, object &message, int_t row, int_t gen);
    QL_API handle	 error_unknown(const char *kind, const char *value);
    QL_API handle	 error_invalid(const char *kind, const char *value);
    QL_API handle	 sys_error(long hresult, error_t, const char *message);

    QL_API error_t	 get_error_type(const object&);
    QL_API const char	*get_error_msg(const object&);
    QL_API int_t	 qlang_error_row(const object&); // sic
    QL_API int_t	 qlang_error_gen(const object&); // sic

    QL_API bool		 gen_is_builtin(int_t);
    QL_API bool		 gen_is_library(int_t);
    QL_API bool		 gen_is_user_code(int_t);

    /**/

#if !QL_INTERN
    template <typename E>
    inline E round_enum(enum_t e, E max)
    {
	if (e < 0 || e >= max)
	    throw error(E_ENUM, "Illegal enum value");

	return static_cast<E>(e);
    }
#endif

    /**/

    QL_API handle	 create_blob(int size, const char *data);

    QL_API int		 blob_size(const object&);
    QL_API const char	*blob_data(const object&);

    /**/

    QL_API date_t	 date(int_t y, int_t m, int_t d);
    QL_API date_t	 date_today();
    QL_API void		 split_date(date_t, int_t &y, int_t &m, int_t &d);

    QL_API date_t	 add_years(date_t, int_t n_years);
    QL_API date_t	 add_months(date_t, int_t n_months);

    QL_API month_t	 month(int_t y, int_t m);
    QL_API void		 split_month(month_t, int_t &y, int_t &m);

    QL_API timestamp_t	 timestamp(int_t y, int_t mon, int_t d,
				   int_t h, int_t min, int_t s, int_t ms);
    QL_API timestamp_t	 timestamp(date_t,
				   int_t hr, int_t min, int_t s, int_t ms);
    QL_API timestamp_t	 timestamp_now();
    QL_API timestamp_t	 timestamp_now_ut();
    QL_API void		 split_timestamp(timestamp_t,
					 int_t &y, int_t &mon, int_t &d,
					 int_t &h, int_t &min, int_t &s,
					 int_t &ms);
    QL_API void		 split_timestamp(timestamp_t, date_t&,
					int_t &h, int_t &min, int_t &s,
					int_t &ms);

    QL_API enum_t	 parse_dc_method(const char*);

    QL_API double	 period(date_t, date_t, enum_t dc);

    QL_API handle	 create_calendar(const object		&holiday_v,
					 const object		&non_hol_v,
					 int_t			 weekend_mask);
    QL_API handle	 empty_calendar();
    QL_API handle	 merge_calendars(const object &c1, const object &c2);

    QL_API logical_t	 is_holiday(const object		&calendar,
				    date_t			 date);
    QL_API handle	 calendar_holidays(const object		&calendar);
    QL_API handle	 calendar_non_holidays(const object	&calendar);
    QL_API int_t	 calendar_weekend_mask(const object	&calendar);

    QL_API date_t	 move_bus_days(const object		&calendar,
				       date_t			 date,
				       int_t			 n_days);

    QL_API handle	 date_code_create(const char*);
    QL_API date_t	 date_code_fwd(const object&,
				       date_t, const object *calendar);
    QL_API date_t	 date_code_back(const object&,
					date_t, const object *calendar);

#if !QL_NATIVE_API
    QL_API date_t	 date_code_fwd(const object&,
				       date_t, const object*, const object*);
    QL_API date_t	 date_code_back(const object&,
					date_t, const object*, const object*);
#endif
}

#endif /* QL_API_QL_BASE_H */
