/* -*- mode: c++; indent-tabs-mode: nil -*- */

void __dbg_print(odbc.connection conn, __dbg_label l)
{
    l.set_text(conn.dsn());
}

void __dbg_browse(odbc.connection conn, __dbg_split s)
{
    logical     trans   = conn.has_transaction();

    s.resize(2);

    s.set_text(0, "dsn");
    s.set_value(0, conn.dsn());

    s.set_text(1, "transaction");
    s.set_value(1, trans);
    if (trans)
        s.set_hl(1, __dbg_hl.ACCENT);
}

void __dbg_print(odbc.statement stmt, __dbg_label l)
{
    l.set_text(stmt.sql());
}

module odbc
{
    class __col_info
    {
    public:
        void __dbg_print(__dbg_label l);

    public:
        data_type       type;
        string          name;
    };

    void __col_info.__dbg_print(__dbg_label l)
    {
        string          text    = string(type);

        if (!null(name))
            text = strcat([ text, ": ", name ]);

        l.set_text(text);
        l.disable_browse();
    }
}

void __dbg_browse(odbc.statement stmt, __dbg_split s)
{
    s.resize(3);

    s.set_text(0, "sql");
    s.set_value(0, stmt.sql());

    s.set_text(1, "[columns]");
    {
        integer                 n = stmt.n_cols();
        vector(odbc.__col_info) cols[n];

        for (integer i = 0 ; i < n ; i++) {
            cols[i] = new odbc.__col_info;
            cols[i].type = stmt.col_type(i);
            cols[i].name = stmt.col_name(i);
        }

        s.set_value(1, cols);
    }

    s.set_text(2, "[params]");
    {
        integer                 n = stmt.n_params();
        vector(odbc.data_type)  params[n];

        for (integer i = 0 ; i < n ; i++)
            params[i] = stmt.param_type(i);

        s.set_value(2, params);
    }
}
