#include <vector> 
using namespace std; 
#include "ql.h"

#include <engine.h>	// MatLabs Engine

static const char category[] = "Matlab integration";

//
// matlab m = matlab() ; // matlab m = matlab([string server],...)
//
// v_x = [1,3,5,7,9] ;
//
// m.put("x", v_x) ;
//
// m.eval("y = x.^2;") ;
//
// v_y = m.get_v_number("y") ;
//

static void m_eval(QL::handle &result , const char *eval) 
{ 
	m_pEngine = engOpen(NULL);
	if (m_pEngine == NULL)
	{
//			cout << "Error: Not Found 
//	            << endl;
	            exit(1);
	}

	engEvalString(m_pEngine, eval); );
}

static void m_put(QL::handle &result , const char *name, QL::handle &var) 
{ 
	double x[0];	
	mxArray *m_X;
	m_X=mxCreateDoubleMatrix(1, 1, mxREAL);
	memcpy((void *)mxGetPr(m_X), (void *)x, sizeof(double)*1);
	engPutVariable(m_pEngine, name, m_X);

	double *cresult;
	mxArray *mresult;
	mresult = engGetVariable(m_pEngine,"z");
	cresult = mxGetPr(mresult);
//		cout << cresult[0];

	double a[SIZE];
	mxArray *A;
	// assume a gets initialized, all values
	A=mxCreateDoubleMatrix(1, SIZE, mxREAL);
	memcpy((void *)mxGetPr(A), (void *)a, sizeof(double)*SIZE);
	engPutVariable(m_pEngine, "a", A);

	double c[SIZE][SIZE];
	// assume c gets initialized, all of it 
	mxArray *mxc;
	mxc = mxCreateDoubleMatrix(SIZE, SIZE, mxREAL);
	memcpy((void *) mxGetPr(mxc), (void *)c, sizeof(double)*SIZE*SIZE);
	engPutVariable(m_pEngine, "c", mxc);
	engEvalString(m_pEngine, "c = c';");
}

__declspec(dllexport) void ql_init(QL::symtab &s)
{
    QL::arg_spec	r;
    QL::arg_spec	a[12];

    r    = QL::arg_spec("number");
    a[0] = QL::arg_spec("number",	"arg1");
    a[1] = QL::arg_spec("number",	"arg2");
    QL::add_func(s, reinterpret_cast<QL::function_t*>(my_func),
		 "my_func", category, r, 2, a);

    r    = QL::arg_spec("series<number>(vector(number))"); 
    a[0] = QL::arg_spec("number","number_of_paths"); 
    a[1] = QL::arg_spec("number","delta_t"); 
    a[2] = QL::arg_spec("number","maturity"); 
    QL::add_func(s, reinterpret_cast<QL::function_t*>(my_func2), 
                 "my_func2", category, r, 3, a); 

	// Create an enum
	QL::add_simple_enum(s, "smart_interpolator",
			    IP_N, "IP", _ip_str, _ip_desc, category);

	// Use the enum as an argument
    r    = QL::arg_spec("number");
    a[0] = QL::arg_spec("smart_interpolator",	"ip");
    QL::add_func(s, reinterpret_cast<QL::function_t*>(my_enum_func),
		 "my_enum_func", category, r, 1, a);

	// Create a class
    QL::add_object_type(s, "smart_curve");

	// ...with a constructor
    r    = QL::arg_spec("smart_curve");
    a[0] = QL::arg_spec("smart_interpolator",	"ip");
    a[1] = QL::arg_spec("number",	"val", "0");
    QL::add_func(s, reinterpret_cast<QL::function_t*>(create_smart_curve),
		 "smart_curve", category, r, 2, a);

	// ...and two member functions
    r    = QL::arg_spec("number");
    QL::add_mem_func(s, reinterpret_cast<QL::function_t*>(smart_curve_val),
		     "smart_curve", "value", r, 0, a);

    r    = QL::arg_spec("string");
    QL::add_mem_func(s, reinterpret_cast<QL::function_t*>(smart_curve_ip_desc),
		     "smart_curve", "ip_desc", r, 0, a);
}
