#include "ql.h"

#include <stdio.h>

static const char category[] = "Complex numbers";

namespace
{
    class complex;

    typedef QL::handle_t<const complex>	complex_p;

    class complex : public QL::object
    {
    public:
	static complex_p create(double re, double im)
	{
	    return complex_p(new complex(re, im));
	}

    private:
	complex(double re, double im) : re(re), im(im) {}

    public:
	double	re;
	double	im;
    };
}

static void create_complex(complex_p &result, double re, double im)
{
    result = complex::create(re, im);
}

static void create_i(complex_p &result)
{
    create_complex(result, 0, 1);
}

static void complex_str(QL::handle &result, const complex_p &c)
{
    char	buf[256];

    if (_snprintf(buf, sizeof buf, "%f%+fi", c->re, c->im) < 0)
		throw QL::error(QL::E_INVALID_ARG, "buffer too small");

    result = QL::create_string(buf);
}

static double complex_re(const complex_p &c)
{
    return c->re;
}

static double complex_im(const complex_p &c)
{
    return c->im;
}

static void unary_plus(complex_p &result, const complex_p &c)
{
    result = c;
}

static void unary_neg(complex_p &result, const complex_p &c)
{
    result = complex::create(-c->re, -c->im);
}

static void add_cc(complex_p &result, const complex_p &a, const complex_p &b)
{
    result = complex::create(a->re + b->re, a->im + b->im);
}

static void add_cd(complex_p &result, const complex_p &a, double b)
{
    result = complex::create(a->re + b, a->im);
}

static void add_dc(complex_p &result, double a, const complex_p &b)
{
    result = complex::create(a + b->re, b->im);
}

static void sub_cc(complex_p &result, const complex_p &a, const complex_p &b)
{
    result = complex::create(a->re - b->re, a->im - b->im);
}

static void sub_cd(complex_p &result, const complex_p &a, double b)
{
    result = complex::create(a->re - b, a->im);
}

static void sub_dc(complex_p &result, double a, const complex_p &b)
{
    result = complex::create(a - b->re, -b->im);
}

static void mul_cc(complex_p &result, const complex_p &a, const complex_p &b)
{
    result = complex::create(a->re * b->re - a->im * b->im,
			     a->re * b->im + a->im * b->re);
}

static void mul_cd(complex_p &result, const complex_p &a, double b)
{
    result = complex::create(a->re * b, a->im * b);
}

static void mul_dc(complex_p &result, double a, const complex_p &b)
{
    result = complex::create(a * b->re, a * b->im);
}

static void div_cc(complex_p &result, const complex_p &a, const complex_p &b)
{
	throw QL::error(QL::E_INVALID_ARG, "Division not yet implemented");
}

static void div_cd(complex_p &result, const complex_p &a, double b)
{
	throw QL::error(QL::E_INVALID_ARG, "Division not yet implemented");
}

static void div_dc(complex_p &result, double a, const complex_p &b)
{
	throw QL::error(QL::E_INVALID_ARG, "Division not yet implemented");
}

__declspec(dllexport) void ql_init(QL::symtab &ctxt)
{
    QL::arg_spec	r;
    QL::arg_spec	a[12];

    QL::add_object_type(ctxt, "complex");

    r    = QL::arg_spec("complex");
    a[0] = QL::arg_spec("number",	"re");
    a[1] = QL::arg_spec("number",	"im", "0");
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(create_complex),
		 "complex", category, r, 2, a);

    /* These are pretty iffy: namespace pollution... */
    r    = QL::arg_spec("complex");
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(create_i),
		 "I", category, r, 0, a);
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(create_i),
		 "i", category, r, 0, a);

    r    = QL::arg_spec("string");
    a[0] = QL::arg_spec("complex",	"a");
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(complex_str),
		 "str", category, r, 1, a);


    QL::add_mem_func(ctxt, reinterpret_cast<QL::function_t*>(complex_im),
		     "complex", "im", r, 0, a);

    r    = QL::arg_spec("complex");
    a[0] = QL::arg_spec("complex",	"a");
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(unary_plus),
		 "0+", category, r, 1, a);
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(unary_neg),
		 "0-", category, r, 1, a);

    r    = QL::arg_spec("complex");
    a[0] = QL::arg_spec("complex",	"a");
    a[1] = QL::arg_spec("complex",	"b");
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(add_cc),
		 "+", category, r, 2, a);
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(sub_cc),
		 "-", category, r, 2, a);
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(mul_cc),
		 "*", category, r, 2, a);
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(div_cc),
		 "/", category, r, 2, a);

    r    = QL::arg_spec("complex");
    a[0] = QL::arg_spec("complex",	"a");
    a[1] = QL::arg_spec("number",	"b");
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(add_cd),
		 "+", category, r, 2, a);
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(sub_cd),
		 "-", category, r, 2, a);
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(mul_cd),
		 "*", category, r, 2, a);
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(div_cd),
		 "/", category, r, 2, a);

    r    = QL::arg_spec("complex");
    a[0] = QL::arg_spec("number",	"a");
    a[1] = QL::arg_spec("complex",	"b");
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(add_dc),
		 "+", category, r, 2, a);
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(sub_dc),
		 "-", category, r, 2, a);
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(mul_dc),
		 "*", category, r, 2, a);
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(div_dc),
		 "/", category, r, 2, a);
}
