#include "ql.h"

static const char category[] = "Series example";

static double average(const QL::handle &s)
{
    int		size	= QL::get_s_size(s);
    int		count	= 0;
    double	sum	= 0;

    for (int i = 0 ; i < size ; i++) {
	double	s_i = QL::get_s_x(s, i);

	if (QL::valid(s_i)) {
	    sum += s_i;
	    ++count;
	}
    }

    return sum / count;
}

__declspec(dllexport) void ql_init(QL::symtab &ctxt)
{
    QL::arg_spec	r;
    QL::arg_spec	a[12];

    r    = QL::arg_spec("number");
    a[0] = QL::arg_spec("series<number>(number)",	"s");
    QL::add_func(ctxt, reinterpret_cast<QL::function_t*>(average),
		 "my_average", category, r, 1, a);
}
