
#include "ql.h"

static const char category[] = "Simple example";

static double my_func(double arg1, double arg2)
{
	if(arg1 == 0 || arg2 == 0)
		throw QL::error(QL::E_INVALID_ARG, "0 not allowed as argument");
	else if(arg1 == arg2)
		throw QL::error(QL::E_INVALID_ARG, "Arg1 == Arg2 not allowed as argument");

	// Do very complicated stuff
	double result = arg1 + arg2;

    return result ;
}

__declspec(dllexport) void ql_init(QL::symtab &s)
{
    QL::arg_spec	r;
    QL::arg_spec	a[2];

    r    = QL::arg_spec("number");
    a[0] = QL::arg_spec("number",	"arg1");
    a[1] = QL::arg_spec("number",	"arg2");
    QL::add_func(s, reinterpret_cast<QL::function_t*>(my_func),
		 "my_func", category, r, 2, a);
}
