import ql

time2mat = [1,2,3]
strikes = [80,90,100,110,120]
fwds = [100,101,102]
#vols are allowed to be incomplete
vols = [[0.3,0.25,0.22,0.25,0.28],
        [None,0.22,0.2,0.24,0.25],
        [None,0.20,0.18,None,0.24]]

#Heston initial guess: ["v0", "theta", "rho", "kappa", "sigma"]
initial_guess = [0.025, 0.04,-0.25, 2, 1]


#Init
h = ql.heston_calibration();
h.add_data_for_maturity(time2mat,fwds, strikes, vols);

#Calibration
start = ql.now();
result = h.calibrate(ql.calibration_target.OPTION_PRICE, ql.calibration_weights.VEGA_WEIGHTS, initial_guess);
stop = ql.now();

#Results
print(ql.pretty_duration(start,stop))
print([result.v0(), result.theta(), result.rho(), result.kappa(), result.sigma()])