/* -*- mode: c++; indent-tabs-mode: nil -*- */
option(null: hard);

blob __ql_update_license(string                                 server,
                         string                                 user,
                         vector(string) option(nullable)        addrs,
                         string         option(nullable)        current_lease,
                         string         option(nullable)        trial_email)
{
    auto        req     = new http.request(http.POST, "/license", false);

    {
        auto    b       = new json.builder;

        b.begin_object();
        b.begin_member("user");
        b.append(user);
        b.begin_member("addrs");
        b.append(addrs);
        b.begin_member("current");
        b.append(current_lease);
        if (!null(trial_email)) {
            b.begin_member("trial_email");
            b.append(trial_email);
        }
        b.end_object();

        req.set_body(b.get());
    }

    log_message(LOG_INFO, "Connecting to " + server + "...");
    sleep(300);

    auto        conn    = http.connect_ssl(server);

    log_message(LOG_INFO, "Sending request...");
    sleep(300);

    conn.write(req);

    log_message(LOG_INFO, "Reading response...");
    sleep(300);

    auto        resp    = conn.read();

    if (null(resp))
        throw(E_IO, "Invalid response from license server: <EOF>");
    if (resp.status_code() != 200)
        throw(E_IO, "Error from license server:\r\n\r\n" + resp.status_msg());

    return resp.body();
}
