enum bs_interpolation
    option(category: "Yield Curve/Bootstrap/Compat") // This is needed for tlb-gen
{
    BS_STEP
	option(str: "step")
	option(desc: "Piecewise constant"),
    BS_LINEAR
	option(str: "linear")
	option(desc: "Linear interpolation"),
    BS_SPLINE
	option(str: "spline")
	option(desc: "Cubic spline"),
    BS_HERMITE
	option(str: "hermite")
	option(desc: "Hermite (Catmull-Rom)")
};

interpolator __compat_ip(bs_interpolation ip)
{
    switch (ip) {
    case BS_STEP:
	return ip_step();
    case BS_LINEAR:
	return ip_linear(0, 0);
    case BS_SPLINE:
	return ip_spline(null<number>, null<number>, IP_NO_XPOL_R);
    case BS_HERMITE:
	return ip_hermite_catmull_rom(0, 0);
    }
}

fit_result bootstrap(cashflows		cf,
		     bs_interpolation	ip = BS_LINEAR,
		     rate_type		rt = RT_CONT)
{
    return __fake_fit_result(..bootstrap(cf, __compat_ip(ip), rt));
}

fit_result bootstrap(vector(number)	periods,
		     vector(number)	disc_func,
		     bs_interpolation	ip = BS_LINEAR,
		     rate_type		rt = RT_CONT)
    option(com_name: "interstrap")
{
    return __fake_fit_result(..disc_func_interp(periods, disc_func,
						__compat_ip(ip), rt));
}
