/*
 *  Compatibility for old realtime_* functions.
 *
 *  Needed starting with qlab 3.1.1338.
 */

string realtime_str(string	ric,
		    string	fid,
		    string	source_and_feed	= '',
		    logical	ignore_error	= false)
    option(warning: "realtime_str is deprecated, use rt.get instead")
{
    string	 source;
    string	 feed;

    rt.__feed2src(source_and_feed, source, feed);

    return rt.get(ric, fid, source, feed, 2000, ignore_error);
}

number realtime_num(string	ric,
		    string	fid,
		    string	source_and_feed	= '',
		    logical	ignore_error	= false)
    option(warning: "realtime_num is deprecated, use rt.get_num instead")
{
    string	 source;
    string	 feed;

    rt.__feed2src(source_and_feed, source, feed);

    return rt.get_num(ric, fid, source, feed, 2000, ignore_error);
}

date realtime_date(string	ric,
		   string	fid,
		   string	source_and_feed	= '',
		   logical	ignore_error	= false)
    option(warning: "realtime_date is deprecated, use rt.get_date instead")
{
    string	 source;
    string	 feed;

    rt.__feed2src(source_and_feed, source, feed);

    return rt.get_date(ric, fid, source, feed, 2000, ignore_error);
}

string ric_status(string	ric,
		  string	source_and_feed	= '')
    option(warning: "ric_status is deprecated, use rt.ric_status instead")
{
    string	 source;
    string	 feed;

    rt.__feed2src(source_and_feed, source, feed);

    return rt.ric_status(ric, source, feed);
}

void realtime_prefetch(string	ric,
		       string	source_and_feed	= '')
    option(warning: "realtime_prefetch is deprecated, use rt.prefetch instead")
{
    string	 source;
    string	 feed;

    rt.__feed2src(source_and_feed, source, feed);

    rt.prefetch(ric, source, feed);
}

void realtime_remove_dep(string	ric,
			 string	source_and_feed)
    option(warning: "realtime_remove_dep is deprecated, use rt.remove_dep instead")
{
    string	 source;
    string	 feed;

    rt.__feed2src(source_and_feed, source, feed);

    rt.remove_dep(ric, source, feed);
}

void realtime_start_source(string source)
    option(warning: "realtime_start_source is deprecated, use rt.start_source instead")
{
    rt.start_source(source);
}
