/*
 *  Compatibility for old iqc_* functions.
 *
 *  Uses rt.__feed2src, hence requires qlab >= 1338.
 */

void iqc_publish(string			source_or_feed,
		 string			ric,
		 vector(string)		fids,
		 vector(string)		vals,
		 integer		timeout	= -1,
		 logical		sync	= false)
    option(warning: "iqc_publish is deprecated, use iqc.publish instead")
{
    string	source;
    string	feed;

    rt.__feed2src(source_or_feed, source, feed);

    iqc.publish(source, ric, fids, vals, timeout, sync);
}

void iqc_publishx(string		source_or_feed,
		  string		ric,
		  vector(string)	fids,
		  vector(string)	vals,
		  integer		timeout	= -1,
		  logical		sync	= false)
    option(warning: "iqc_publishx is deprecated, use iqc.publishx instead")
{
    string	source;
    string	feed;

    rt.__feed2src(source_or_feed, source, feed);

    iqc.publishx(source, ric, fids, vals, timeout, sync);
}

void iqc_remove(string			source_or_feed,
		string			ric,
		integer			timeout	= -1,
		logical			sync	= false)
    option(warning: "iqc_remove is deprecated, use iqc.remove instead")
{
    string	source;
    string	feed;

    rt.__feed2src(source_or_feed, source, feed);

    iqc.remove(source, ric, timeout, sync);
}

void iqc_persist(string			source_or_feed,
		string			ric,
		integer			timeout	= -1,
		logical			sync	= false)
    option(warning: "iqc_persist is deprecated, use iqc.persist instead")
{
    string	source;
    string	feed;

    rt.__feed2src(source_or_feed, source, feed);

    iqc.persist(source, ric, timeout, sync);
}

void iqc_unpersist(string		source_or_feed,
		   string		ric,
		   integer		timeout	= -1,
		   logical		sync	= false)
    option(warning: "iqc_unpersist is deprecated, use iqc.unpersist instead")
{
    string	source;
    string	feed;

    rt.__feed2src(source_or_feed, source, feed);

    iqc.unpersist(source, ric, timeout, sync);
}
