/*
 *  Compatibility for old iqc_* functions.
 *
 *  Uses rt.__feed2src, hence requires qlab >= 1338.
 */

void add_ticker_normal(string	source_or_feed,
		       string	ric,
		       string	fid,
		       number	value,
		       integer	wait_min,
		       integer	wait_max,
		       number	variance,
		       number	rev_factor = 0)
    option(warning: "add_ticker_normal is deprecated, use sim.add_ticker_normal instead")
{
    string	source;
    string	feed;

    rt.__feed2src(source_or_feed, source, feed);

    sim.add_ticker_normal(source, ric, fid, value,
			  wait_min, wait_max, variance, rev_factor);
}

void add_ticker_up_down(string	source_or_feed,
			string	ric,
			string	fid,
			number	value,
			integer	wait_min,
			integer	wait_max,
			number	step)
    option(warning: "add_ticker_up_down is deprecated, use sim.add_ticker_up_down instead")
{
    string	source;
    string	feed;

    rt.__feed2src(source_or_feed, source, feed);

    sim.add_ticker_up_down(source, ric, fid, value, wait_min, wait_max, step);
}

void remove_ticker(string	source_or_feed,
		   string	ric)
    option(warning: "remove_ticker is deprecated, use sim.remove_ticker instead")
{
    string	source;
    string	feed;

    rt.__feed2src(source_or_feed, source, feed);

    sim.remove_ticker(source, ric);
}
