/*	
	bill example with a template
	Algorithmica Research, Magnus Nyström
			
*/

option(null: hard); // Throw an error if a null value is used in a non-nullable context

module BP_INST
{
	//create bill from a template
	void bill_init(	INSTR_TMPL.bill_def_tmpl		tmpl,
					string 							name,
					date 							issue_date,
					date 							maturity,				
					out instr_def					def,
					out bill						b,
					error_info option(nullable) 	e)
	{
		
		def 				= instr_def_bill(tmpl,e)	;	
		QL_FAIL_COND(e.is_error(),e.message());	
		QL_FAIL_COND(null(def),"invalid instr_def");

		date trade_date		= null<date>;
		date settle_date	= null<date>;
		number coupon		= null<number>;//some bills have a coupon
		number quote		= null<number>;
		number nominal		= null<number>;
		quote_style qs		= null<quote_style>;
		
		b					= bill(def,  name ,issue_date,	maturity,	coupon,trade_date,settle_date ,quote ,qs,nominal,e);
														
		QL_FAIL_COND(e.is_error(),e.message());
		QL_FAIL_COND(null(b),"invalid bill");
		return ;
	}
}