/*	
	bond example with a template
	Algorithmica Research, Magnus Nyström
			
*/

option(null: hard); // Throw an error if a null value is used in a non-nullable context

module BP_INST
{
	//create bond from a template
	void bond_init(	INSTR_TMPL.bond_def_tmpl		tmpl,
					string 							name,
					date 							issue_date,
					date 							maturity,
					number							coupon,
					out instr_def					def,
					out bond						b,
					error_info option(nullable) 	e)
	{
		
		def 				= instr_def_bond(tmpl,e)	;	
		QL_FAIL_COND(e.is_error(),e.message());	
		QL_FAIL_COND(null(def),"invalid instr_def");

		coupon				/= 100;
		date trade_date		= null<date>;
		date settle_date	= null<date>;
		number quote		= null<number>;
		number nominal		= null<number>;
		date cpn_start_date	= null<date>;
		date first_cpn_date	= null<date>;
		date last_reg_cpn_date	= null<date>;
		quote_style qs		= null<quote_style>;
		
		b					= bond(def,  name ,issue_date,cpn_start_date,first_cpn_date,last_reg_cpn_date,
									maturity,	coupon,trade_date,settle_date ,
									quote ,qs,nominal,e);
														
		QL_FAIL_COND(e.is_error(),e.message());
		QL_FAIL_COND(null(b),"invalid bond");
		return ;
	}
}