option(null: hard);

/*

	best practice funcs for curve
	Developer: Algorithmica Research, Magnus Nyström

 */

module BP_CURVE
{
	//-------------------------------------------------------
	// disc_crv_init_1
	// input of 1 curve
	//-------------------------------------------------------
	void disc_crv_init_1(	date td,
					curve_name  crv,
					quote_side 	qs,
					out WSP_UTIL.curve_data_disc crv1_1,
					out vector(string) 	name,
					out vector(date) 	mat,
					out vector(number) 	q,
					out vector(number) 	usr_q,
					out vector(number)	usr_sp,
					out vector(string) 	incl,
					out vector(string) 	out_name,
					out vector(date) 	out_mat,
					out vector(number) 	out_q)
	{

		crv1_1 = new WSP_UTIL.curve_data_disc(null_curve_name(crv), null<curve_name>, null<curve_name>);
		
		WSP_UTIL.input_curve_data_ext sd =  new WSP_UTIL.input_curve_data_ext(	td,crv1_1.short_name_, qs,
																				false, usr_q, usr_sp, incl, null);
			
		integer s_short_orig;
		
		if(sd.is_init()){

			crv1_1.update_short_curve(sd.crv_incl_,sd.crv_orig_);
					
			vector(number) 	q_orig;
			sd.output_helper(name,mat,q_orig,q,usr_q,usr_sp,incl,s_short_orig);
			
			/*string _n;
			if(!CORE_INT.check_eq_currency(g_crv3_1.short_crv_.instruments(), g_curr, _n)) {
				string e = strcat(["instrument currency not ",g_curr," (",_n,")"]);
				throw(E_INVALID_ARG, e);
			}*/
		}
		else {
			s_short_orig = 0;
			crv1_1.update_short_curve(null<curve>,null<curve>);
			//CORE_INT.warning_admin(sd.err_msg(), k_note, msg);
			QL_FAIL(sd.err_msg());//if only one curve we can do a fail here
		}
		crv1_1.update_blend_curve(crv1_1.short_crv_);
		QL_REQUIRE(!null(crv1_1.crv_),"invalid curve");
		
		vector(instrument) vi 	= crv1_1.crv_.instruments();
		out_name 				= vi.name();
		out_mat 				= vi.maturity();
		out_q 					= vi.quote();

		return ;
	}
	/*----------------------------------------------------
	 disc_df_calc
	----------------------------------------------------*/
	void disc_df_calc(	out WSP_UTIL.curve_data_disc crv,
						string  option(nullable) z_model,
						string  option(nullable) ip_model,
						string  option(nullable) ip_rt)

	{
		string err_msg;
		logical ok = WSP_UTIL.disc_crv_calc(crv,z_model,ip_model,ip_rt,err_msg);
		QL_REQUIRE(ok, err_msg);
	}

	//-------------------------------------------------------
	// disc_crv_ba_init_1
	// input of 1 curve
	//-------------------------------------------------------
	void disc_crv_ba_init_1(date td,
							curve_name  crv,
							quote_side 	qs_bid,
							quote_side 	qs_ask,
							out WSP_UTIL.curve_data_disc crv1_1_bid,
							out WSP_UTIL.curve_data_disc crv1_1_ask,
							out vector(string) 	name,
							out vector(date) 	mat,
							out vector(text_rgb) q_orig,
							out vector(text_rgb) q_bid,
							out vector(text_rgb) q_ask,
							out vector(number) 	usr_q_bid,
							out vector(number) 	usr_q_ask,
							out vector(number)	usr_sp_bid,
							out vector(number)	usr_sp_ask,
							out vector(string) 	incl,
							out vector(string) 	out_name,
							out vector(date) 	out_mat,
							out vector(number) 	out_q_bid,
							out vector(number) 	out_q_ask)
	{

		crv1_1_bid = new WSP_UTIL.curve_data_disc(null_curve_name(crv), null<curve_name>, null<curve_name>);
		crv1_1_ask= new WSP_UTIL.curve_data_disc(null_curve_name(crv), null<curve_name>, null<curve_name>);
		
		WSP_UTIL.input_curve_data_ext sd =  new WSP_UTIL.input_curve_data_ext(	td,crv1_1_bid.short_name_, qs_bid,qs_ask,
																				false, usr_q_bid, usr_q_ask,usr_sp_bid, usr_sp_ask, incl, null);
			
		integer s_short_orig_bid,s_short_orig_ask;
		
		if(sd.is_init()){

			crv1_1_bid.update_short_curve(sd.crv_incl_,sd.crv_orig_);
			crv1_1_ask.update_short_curve(sd.crv_incl_2_,sd.crv_orig_2_);
						
			sd.output_helper(name,mat,q_orig,q_bid,q_ask,usr_q_bid, usr_q_ask,usr_sp_bid, usr_sp_ask,incl,s_short_orig_bid,s_short_orig_ask);
			
			
			/*string _n;
			if(!CORE_INT.check_eq_currency(g_crv3_1.short_crv_.instruments(), g_curr, _n)) {
				string e = strcat(["instrument currency not ",g_curr," (",_n,")"]);
				throw(E_INVALID_ARG, e);
			}*/
		}
		else {
			s_short_orig_bid = 0;
			s_short_orig_ask = 0;
			crv1_1_bid.update_short_curve(null<curve>,null<curve>);
			crv1_1_ask.update_short_curve(null<curve>,null<curve>);
			//CORE_INT.warning_admin(short_sd.err_msg(), k_note, msg);
			QL_FAIL(sd.err_msg());//if only one curve we can do a fail here
		}
		crv1_1_bid.update_blend_curve(crv1_1_bid.short_crv_);
		crv1_1_ask.update_blend_curve(crv1_1_ask.short_crv_);
		QL_REQUIRE(!null(crv1_1_bid.crv_),"invalid curve");
		
		vector(instrument) vi 	= crv1_1_bid.crv_.instruments();
		out_name 				= vi.name();
		out_mat 				= vi.maturity();
		out_q_bid 				= vi.quote();
		vector(instrument) vi_ask 	= crv1_1_ask.crv_.instruments();
		out_q_ask 				= vi_ask.quote();
		return ;
	}
	/*----------------------------------------------------
	 disc_df_calc_ba
	 disc_crv_calc with bid and ask calculates:
	 1. a disc_func from mid rates with user selected model
	 2. a bid disc_func using bootstrap_spr always with linear bootstrap on cont. rates
	 3. a ask disc_func using bootstrap_spr always with linear bootstrap on cont. rates
	----------------------------------------------------*/
	void disc_df_calc_ba(out WSP_UTIL.curve_data_disc crv_bid,
						out WSP_UTIL.curve_data_disc crv_ask,
						string  option(nullable) z_model,
						string  option(nullable) ip_model,
						string  option(nullable) ip_rt)

	{
		string err_msg;
		logical ok = WSP_UTIL.disc_crv_calc(crv_bid,crv_ask,z_model,ip_model,ip_rt,err_msg);
		QL_REQUIRE(ok, err_msg);
	}
}