/*	
	Basic help functions for testing/evaluating the "dual" bootstrap framework - legacy
	Developed by Algorithmica Research, Magnus Nyström

*/

option(null: hard);	


module dual_boot_test_legacy
{
	
	//-------------------------------------------------------
	// create_disc_func (generic)
	// LEGACY version
	//-------------------------------------------------------
	disc_func create_disc_func(	date 	d,
								string option(nullable) z_model,
								string option(nullable) ip_model,
								string option(nullable) ip_rt,	
								curve option(nullable)	disc_sh_crv,//eg. depo,ois 
								curve option(nullable)  disc_mi_crv,//eg. fra/sps/fut
								curve option(nullable)	disc_crv, //eg. ois,swaps
								curve 	option(nullable) extrap_crv,
								string 	option(nullable) synt_class_name,//used to retrieve data for synthetics, if fra class --> (important to use the right tenor)	
								out date  ois_end,
								vector(date) option(nullable) cb_dates = null<vector(date)>)
	{	
		/*------------------------------
		Step 1 create the discount model		 
		--------------------------------*/
		
		disc_model_parm disc_p = disc_model_parm(); 
	
		if(!null(z_model)) 	disc_p.set_model(z_model) ;		
		if(!null(ip_rt)) 	disc_p.set_rt(ip_rt) ;				
		if(!null(ip_model)) disc_p.set_ip(ip_model) ;			
		if(!null(cb_dates)) disc_p.set_cb_dates( cb_dates, cb_step_type.EXACT_FIT) ;

		disc_z_model disc_model = init_disc_model(disc_p);	
		
		disc_model_parm extrap_p;
		disc_z_model extrap_model;
		if(!null(extrap_crv)){
			extrap_p = disc_model_parm();		
		
			if(!null(z_model)) 	extrap_p.set_model(z_model) ;	
			if(!null(ip_rt)) 	extrap_p.set_rt(ip_rt) ;			
			if(!null(ip_model)) extrap_p.set_ip(ip_model) ;	
			
			extrap_model = init_disc_model(extrap_p);
		}
					
		/*--------------------------------------
		Step 2 	create the discount curve with or 
				without extrapolation via a secondary curve
		-----------------------------------------*/																				
		integer blend_buf_days 		= DFLT_BLEND_BUF_DAYS;			
		logical disc_no_overlap_fwd	= false;		
		logical disc_merge_middle	= false;		
		logical disc_merge_crv		= false;		
		curve_prio  prio1 			= curve_prio.LONG;			
		curve_prio  prio2 			= curve_prio.MIDDLE;		
	
		swap_curve_disc_ext disc_base 	= LEGACY.disc_curve_create(d,disc_sh_crv,disc_mi_crv, disc_crv, prio1,prio2,disc_no_overlap_fwd,
															disc_merge_middle,disc_merge_crv,blend_buf_days);			
		disc_func df_ois;
					
		if(!null(extrap_crv)){									
			swap_curve_disc_ext disc 	= LEGACY.disc_curve_create(d, disc_base, extrap_crv, synt_class_name, extrap_model);
			df_ois 						= disc.disc_df(disc_model);	
			ois_end						= disc.curve_end();	
		}
		else {
			df_ois 	= disc_base.disc_df(disc_model);
			ois_end = disc_base.curve_end();		
		}		
		QL_REQUIRE(!null(df_ois),'invalid df_ois');		
		return df_ois;
	}

	//-------------------------------------------------------
	// create_tenor_main_func (generic) 
	// LEGACY version
	// main tenor --> create fwd_func directly from a depo/fra/sps/swap curve
	// all instruments in the 3 curves refer to the same tenor
	//-------------------------------------------------------
	fwd_func create_tenor_main_func(date 					d,
									string option(nullable) z_model,
									disc_func				df_ois,
									disc_func option(nullable)	df_synt_base,
									date option(nullable)	synt_end,									
									curve option(nullable)	sh_crv,	//depo with same tenor as fra / fltleg of swap
									curve option(nullable)	fra_crv,//eg. fra or sps 
									curve option(nullable)	swap_crv,
									logical 				fra_prio,
									LEGACY.synt_short_style option(nullable) synt,								
									string option(nullable)	depo_class_name,
									string option(nullable)	fra_class_name,
									out swap_curve_fwd_ext 	fwd_crv,
									vector(number) option(nullable) edfut_cvx_adj = null<vector(number)> ) //used for external convexity adjustment for futures
	{
		/*------------------------------
		Step 1 create the forwarding model
		--------------------------------*/	
		fwd_model_parm fwd_p 		= fwd_model_parm();		 																	
		fwd_p.set_model(z_model);							
		fwd_z_model fwd_model 		= init_fwd_model(fwd_p);		
						
		/*------------------------------
		Step 2 create the forwarding curve
		--------------------------------*/
		number  swap_first_fix 		= null<number>;	 								
		logical merge_fra 			= false;		
		logical merge_crv			= false;							
		integer blend_buf_days 		= DFLT_BLEND_BUF_DAYS;

		if(null(synt)) synt 		= LEGACY.SY_DEPO;		/* 	creation of synthetic short instruments
														SY_FRA: the synthetic short curve will be created from synthetic fras 
																and one depo equal to the tenor (if not present)
														SY_DEPO: one depo equal to the tenor will be added (if not present)
														SY_NONE: no synthetic instruments */
					
		curve_prio prio1 			= fra_prio? curve_prio.MIDDLE : curve_prio.LONG;
		curve_prio prio2 			= fra_prio? curve_prio.LONG : curve_prio.MIDDLE;
									
		fwd_crv						= LEGACY.fwd_curve_create(	d,df_ois,df_synt_base, synt_end, sh_crv,fra_crv,swap_crv,prio1,prio2,depo_class_name,
														fra_class_name,synt,merge_fra,merge_crv,blend_buf_days,edfut_cvx_adj,swap_first_fix);		

		fwd_func f_fwd 				= fwd_crv.fwd(fwd_model);
		QL_REQUIRE(!null(f_fwd),'invalid f_fwd');

		return f_fwd;
	}
	//-------------------------------------------------------
	// create_tenor_b2_func (generic)
	// LEGACY version
	// create a fwd_func via tenor basis swap quoted as a spread 
	// between two fixed legs
	//-------------------------------------------------------
	fwd_func create_tenor_b2_func(date 					d,
								string option(nullable) z_model,
								disc_func				df_ois,									
								date option(nullable)	ois_end,
								curve option(nullable)	sh_out_crv, 	
								curve option(nullable)	fra_out_crv, 
								curve 					swap_in_crv,//this swap will be converted with the basis curve to out curve
								curve 					basis_t1t2_crv,
								logical 				fra_prio,
								LEGACY.synt_short_style option(nullable) synt,		
								string option(nullable)	depo_class_name,
								string option(nullable)	fra_out_class_name,
								out swap_curve_b2_ext 	fwd_crv)
	{
		//---------------------
		//create fwd model 
		//---------------------
		fwd_model_parm fwd_p 		= fwd_model_parm();
		fwd_p.set_model(z_model);
		fwd_z_model fwd_model 		= init_fwd_model(fwd_p);		

		//---------------------
		// create fwd curve
		//---------------------
		number  swap_first_fix 		= null<number>;									
		logical merge_fra 			= false;
		logical merge_crv			= false;	
		vector(number) edfut_cvx_adj;						
		integer blend_buf_days 		= DFLT_BLEND_BUF_DAYS;
		if(null(synt)) synt 		= LEGACY.SY_DEPO;	
		curve_prio prio1 			= fra_prio? curve_prio.MIDDLE : curve_prio.LONG;
		curve_prio prio2 			= fra_prio? curve_prio.LONG : curve_prio.MIDDLE;
		logical x_pol_basis 		= true;	
												
		fwd_crv						= LEGACY.fwd_b2_curve_create(	d,df_ois,df_ois, ois_end, sh_out_crv,fra_out_crv,swap_in_crv,basis_t1t2_crv, 
															prio1,prio2,depo_class_name,fra_out_class_name,synt,merge_fra,merge_crv,
															blend_buf_days,edfut_cvx_adj,x_pol_basis, swap_first_fix);
		fwd_func f_fwd 				= fwd_crv.fwd(fwd_model);
		QL_REQUIRE(!null(f_fwd),'invalid f_fwd');

		return f_fwd;
	}
	
	//-------------------------------------------------------
	// create_tenor_b1_func (generic)
	// LEGACY version
	// create a fwd_func via tenor basis swap
	// in this function the fwd_func for the tenor we're not solving for
	// is also created
	//-------------------------------------------------------
	fwd_func create_tenor_b1_func(date 						d,
								string option(nullable) 	z_model,
								disc_func					df_ois,									
								date option(nullable)		ois_end,
								curve option(nullable)		sh_in_crv, 									
								curve option(nullable)		fra_in_crv, 	
								curve option(nullable)		swap_in_crv,
								number						in_freq,
								curve option(nullable)		sh_out_crv, 							 	
								curve option(nullable)		fra_out_crv,  								
								curve 						basis_t1t2_crv,
								logical 					fra_prio,
								LEGACY.synt_short_style option(nullable) synt,		
								string option(nullable)		depo_class_name,
								string option(nullable)		fra_in_class_name,	
								string option(nullable)		fra_out_class_name,								
								out swap_curve_b1_ext 	fwd_crv)							
	{
		//---------------------
		//create fwd model 
		//---------------------
		fwd_model_parm fwd_p 		= fwd_model_parm();
		fwd_p.set_model(z_model);
		fwd_z_model fwd_model 		= init_fwd_model(fwd_p);		
		//---------------------
		// create fwd curve
		//---------------------
		number  first_fix_base		= null<number>;
		number first_fix_flat 		= null<number>;									
		logical merge_fra 			= false;
		logical merge_crv			= false;	
		vector(number) edfut_cvx_adj_in,edfut_cvx_adj_out;						
		integer blend_buf_days 		= DFLT_BLEND_BUF_DAYS;
		if(null(synt)) synt 		= LEGACY.SY_DEPO;		
		curve_prio prio1 			= fra_prio? curve_prio.MIDDLE : curve_prio.LONG;
		curve_prio prio2 			= fra_prio? curve_prio.LONG : curve_prio.MIDDLE;
														
		fwd_func f_fwd 				= LEGACY.fwd_b1_curve_create(	d,df_ois,df_ois, ois_end, sh_in_crv, fra_in_crv,swap_in_crv,in_freq,sh_out_crv,
															fra_out_crv,basis_t1t2_crv,prio1,prio2,depo_class_name,fra_in_class_name,fra_out_class_name,
															synt,fwd_model,merge_fra,merge_crv,blend_buf_days,edfut_cvx_adj_in, edfut_cvx_adj_out,fwd_crv,
															first_fix_base,first_fix_flat);
		
		QL_REQUIRE(!null(f_fwd),'invalid f_fwd');

		return f_fwd;
	}


	//-------------------------------------------------------
	// create_tenor_b1_func 
	// LEGACY version
	// create a fwd_func via tenor basis swap
	// in this function the fwd_func for the tenor we're not solving for
	// is exogenous
	//-------------------------------------------------------
	fwd_func create_tenor_b1_func(date 						d,
									string option(nullable) z_model,
									disc_func				df_ois,									
									date option(nullable) 	ois_end,
									fwd_func				fwd_in,
									integer					fwd_in_freq,
									curve option(nullable)	sh_out_crv, 											
									curve option(nullable)	fra_out_crv, 								
									curve 					basis_t1t2_crv,
									logical					fra_prio,								
									string option(nullable)	depo_class_name,
									string option(nullable) fra_out_class_name,								
									LEGACY.synt_short_style option(nullable) synt,																														
									out swap_curve_b1_ext 	fwd_crv)
	{
		//---------------------
		//create fwd model 
		//---------------------
		fwd_model_parm fwd_p 		= fwd_model_parm();
		fwd_p.set_model(z_model);
		fwd_z_model fwd_model 		= init_fwd_model(fwd_p);	
		//---------------------
		// create fwd curve
		//---------------------
		number first_fix_base 		= null<number>;
		number  first_fix_flat 		= null<number>;
		logical merge_fra 			= false;
		logical merge_crv			= false;	
		vector(number) edfut_cvx_adj;						
		integer blend_buf_days 		= DFLT_BLEND_BUF_DAYS;
		if(null(synt)) synt 		= LEGACY.SY_DEPO;		
		curve_prio prio1 			= fra_prio? curve_prio.MIDDLE : curve_prio.LONG;
		curve_prio prio2 			= fra_prio? curve_prio.LONG : curve_prio.MIDDLE;

		fwd_crv 					= LEGACY.fwd_b1_curve_create(	d,df_ois,df_ois,ois_end,fwd_in,fwd_in_freq,sh_out_crv,fra_out_crv,basis_t1t2_crv,
															prio1,prio2,depo_class_name,fra_out_class_name,synt,fwd_model,merge_fra,merge_crv,
															blend_buf_days,edfut_cvx_adj,first_fix_base,first_fix_flat);

		fwd_func f_fwd = fwd_crv.fwd(fwd_model);
		QL_REQUIRE(!null(f_fwd),'invalid f_fwd');

		return f_fwd;							
	}
}