/*	
	fix-float swap example with a template
	Algorithmica Research, Magnus Nyström
			
*/

option(null: hard); // Throw an error if a null value is used in a non-nullable context

module BP_INST
{

	//update fixing rate vector with fake fixing rates
	void get_fixing_rates(	out vector(date) fixing_dates,
							out vector(number) fixing_rates,
							number 				r,
							error_info option(nullable) e)
	{
		for(integer i=0;i<v_size(fixing_rates);i++)
			fixing_rates[i] = r;
	}

	//init of some curves with fake market data 
	disc_func get_df(	number r_cont_ann )
	{
		disc_func df = disc_func_interp([1.0],[exp(-r_cont_ann)],ip_linear(), RT_CONT);
		return df;
	}

	void get_fwd(	ir_index		flt_ir_index,
					date 			trade_date,
					disc_func 		df,
					out fwd_func 	fwd,
					out tenor_surface flt_tenor_surface)
	{		
		if(flt_ir_index.is_1day_tenor()) {
			fwd = fwd_func(	df,
							365,
							trade_date,
							flt_ir_index.day_count_method(),
							flt_ir_index.fixing_calendar(),
							bd_convention.BD_FOLLOWING,
							false);//create a fwd_func from a disc_func			
		}
		else {
			integer tenor_m				= integer(flt_ir_index.tenor_months());	
			fwd							= fwd_func(	df,
													integer(12/tenor_m),
													trade_date,
													flt_ir_index.day_count_method(),
													flt_ir_index.fixing_calendar(),
													flt_ir_index.bd_convention(),
													flt_ir_index.eom());//create a fwd_func from a disc_func
			
		}
		logical allow_extrap 		= false;
		flt_tenor_surface 			= tenor_surface(trade_date,
													df,
													[fwd],
													[flt_ir_index],
													allow_extrap);
	}
	
	//init of some curves with fake market data 
	void get_df_fwd(	ir_index 		idx,
						date 			trade_date,
						number 			rdf_cont_ann,
						number 			sprd_fwd,
						out disc_func 	df,
						out fwd_func 	fwd,
						out tenor_surface flt_tenor_surface)
	{
		//ir_index flt_ir_index 	= tmpl.flt_ir_index();
		df = get_df(rdf_cont_ann );
		if(sprd_fwd != 0) {
			disc_func df_tmp = get_df(rdf_cont_ann + sprd_fwd);
			get_fwd(idx, trade_date, df_tmp, fwd, flt_tenor_surface);
		}
		else {
			get_fwd(idx, trade_date, df, fwd, flt_tenor_surface);
		}
	}	

	/*-----------------------------------------------------------------------
	  swap_fix_flt_single_ccy_tmpl
	  ----------------------------------------------------------------------*/	
	swap_fixflt swap_fix_flt_single_ccy_tmpl( INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
											  string 							name,
											  date 	option(nullable) 			trade_date,
											  date option(nullable) 			settle_date,
											  date option(nullable) 			start_date,
											  date option(nullable) 			maturity,
											  number 							notional,
											  logical							pay_fixed,
											  disc_func option(nullable) 		disc_func,
											  number option(nullable) 			fix_coupon_rate,//decimal
											  number option(nullable) 			flt_spread,//decimal
											  number option(nullable) 			flt_curr_fix ,//decimal
											  fwd_func  option(nullable) 		flt_fwd_func,											  
											  error_info option(nullable) 		e)
	{
		string fwd_start_code 		= tmpl.fwd_start_code();
		string maturity_code 		= tmpl.maturity_code();
		
		integer fix_r_rnd_dec		= -1;//-1 --> no rounding				
		number pv01_not_unit  		= 100000;//rounding unit for notional when implied from pv01					
		number fix_pv01 			= null;

		if(null(fix_coupon_rate) && (null(disc_func) || null(flt_fwd_func) || null(trade_date)))
		   QL_FAIL("fix_coupon_rate cannot be implied due to incomplete input");

		if(null(maturity) && null(maturity_code))
		   QL_FAIL("invalid maturity/maturity_code");

		if(null(trade_date) && null(settle_date) && null(start_date) && null(fwd_start_code))
		   QL_FAIL("swap start not valid");//if either tradedate or settledate is input the startdate is implied via spot_code
		
		//create empty parm
		CORE_SWAPLIB.fixflt_parm fifl = new CORE_SWAPLIB.fixflt_parm();

		//update parm with static data using the template
		fifl.init_static(tmpl);

		//some checks eg. that we have an appropriate template
		QL_REQUIRE(!fifl.is_cross_currency(),"invalid template (must be single currency)");

		
		//update parm with current input
		//if(fifl.is_cross_currency()){
			
			//QL_FAIL_COND(null(fix_disc_func) && !null(null(flt_disc_func)), "invalid fix leg disc_func", E_INIT);	
		
		//}
		number flt_start_stub_rate 	= null;
		number flt_end_stub_rate 	= null;
	
		fifl.set_plain_single_ccy(	name,trade_date,settle_date,start_date,fwd_start_code,maturity ,
									maturity_code, pay_fixed, notional,fix_pv01, pv01_not_unit,
									fix_coupon_rate, fix_r_rnd_dec, flt_spread,flt_curr_fix, flt_start_stub_rate,
									flt_end_stub_rate);

		/*
		all arg version of set_plain_single_ccy
		-->
		fifl.set_plain_single_ccy(name,trade_date,settle_date
											string option(nullable) 	spot_settle_code,
									start_date,fwd_start_code,maturity , maturity_code, pay_fixed,
											bd_convention option(nullable) 	pmt_bus_day,
											calendar option(nullable)	pmt_cal,
											logical	option(nullable) 	end_of_month,
											string	option(nullable) 	ccy,
											integer 					imp_fix_rate_dec,
									pv01_not_unit, notional, fix_pv01,
											
											number option(nullable)		fix_cpn_freq_n,
											day_count_method option(nullable) fix_day_count,
											interest_rule	option(nullable) fix_ir_rule,
									fix_cpn_rate,
																							
											number option(nullable)		flt_cpn_freq_n,
											day_count_method  option(nullable) flt_day_count,
											interest_rule	option(nullable) flt_ir_rule,
											ir_index option(nullable)	flt_ir_index,
											flt_stub_fwd_style option(nullable)  flt_stub_rate_style,
									flt_spread, flt_curr_fix, flt_start_stub_rate, flt_end_stub_rate);
		*/

		/*
		 common arg version of set_plain
		-->
		 fifl.set_plain(	name,trade_date,settle_date,start_date,fwd_start_code,maturity , maturity_code, pay_fixed,						
									integer 						imp_fix_rate_dec,
							pv01_not_unit,																		
									number 		option(nullable) 	fx_quote,
									string 		option(nullable) 	fx_quote_baseccy,
									string 		option(nullable) 	fx_quote_priceccy,
									logical 	option(nullable) 	pv_in_base_ccy,
								
							fix_cpn_rate,
									stub_type option(nullable)		fix_stub_type,
									date option(nullable)  			fix_eff_date,
									date option(nullable)  			fix_first_cpn_date,
									date option(nullable)  			fix_last_reg_date,
									number	option(nullable) 		fix_notional,
							fix_pv01,
							flt_spread,
									stub_type option(nullable)		flt_stub_type,
									date option(nullable)  			flt_eff_date,
									date option(nullable)  			flt_first_cpn_date,
									date option(nullable)  			flt_last_reg_date,
									number	option(nullable) 		flt_notional,
							flt_curr_fix,
									vector(date) option(nullable) 	flt_fixing_dates ,	
									vector(number) option(nullable) flt_fixing_rates,
									number option(nullable) 		flt_fix_proxy ,
									logical option(nullable) 		flt_allow_fwd_fix,
							flt_start_stub_rate,
							flt_end_stub_rate)
		 */
		/*
		 all arg version of set_plain
		 
		 fifl.set_plain(name,trade_date,settle_date,
								string option(nullable) 		spot_settle_code,
						start_date,fwd_start_code,maturity , maturity_code, pay_fixed,
								bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,
								notional_exchg_style option(nullable) notional_exchg,
								integer 						imp_fix_rate_dec,
						pv01_not_unit,
																			
								number 		option(nullable) 	fx_quote,
								string 		option(nullable) 	fx_quote_baseccy,
								string 		option(nullable) 	fx_quote_priceccy,
								logical 	option(nullable) 	pv_in_base_ccy,
								
								string	 option(nullable) 		fix_ccy,
								number	option(nullable)		fix_cpn_freq_n,
								day_count_method option(nullable) fix_day_count,
								interest_rule option(nullable) 	fix_ir_rule ,
						fix_cpn_rate,
								stub_type option(nullable)		fix_stub_type,
								date option(nullable)  			fix_eff_date,
								date option(nullable)  			fix_first_cpn_date,
								date option(nullable)  			fix_last_reg_date,
								number	option(nullable) 		fix_notional,
						fix_pv01,								
								//flt
								string	 option(nullable) 		flt_ccy,
								number option(nullable)	 		flt_cpn_freq_n,
								day_count_method  option(nullable) flt_day_count,
								interest_rule option(nullable) 	flt_ir_rule ,
								ir_index option(nullable)		flt_ir_index,
								flt_stub_fwd_style option(nullable)  flt_stub_rate_style,
						flt_spread,
								stub_type option(nullable)		flt_stub_type,
								date option(nullable)  			flt_eff_date,
								date option(nullable)  			flt_first_cpn_date,
								date option(nullable)  			flt_last_reg_date,
								number	option(nullable) 		flt_notional,
						flt_curr_fix,
								vector(date) option(nullable) 	flt_fixing_dates ,	
								vector(number) option(nullable) flt_fixing_rates,
								number option(nullable) 		flt_fix_proxy ,
								logical option(nullable) 		flt_allow_fwd_fix,
						flt_start_stub_rate,
						flt_end_stub_rate)
		 */
		swap_fixflt swap 			= fifl.create_swap(disc_func, disc_func, flt_fwd_func);
			
		QL_FAIL_COND(e.is_error(),e.message());
		QL_FAIL_COND(null(swap),"invalid swap");
		return swap;
	}

	/*-----------------------------------------------------------------------
	  swap_fix_flt_single_ccy_tmpl
	  this version creates a instr_def from template to start with	  
	  ----------------------------------------------------------------------*/	
	void swap_fix_flt_single_ccy_tmpl_2(  INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
										  string 							name,
										  date 	option(nullable) 			trade_date,
										  date option(nullable) 			settle_date,
										  date option(nullable) 			start_date,
										  date option(nullable) 			maturity,
										  number 							notional,
										  logical							pay_fixed,
										  disc_func option(nullable) 		disc_func,
										  number option(nullable) 			fix_coupon_rate,//decimal
										  number option(nullable) 			flt_spread,//decimal
										  number option(nullable) 			flt_curr_fix ,
										  fwd_func  option(nullable) 		flt_fwd_func,									  
										  out instr_def						def,
										  out swap_fixflt					swap,
										  error_info option(nullable) 		e)
	{
		
		def 						= instr_def_swap_fixflt(tmpl,e)	;	
		QL_FAIL_COND(e.is_error(),e.message());	
		QL_FAIL_COND(null(def),"invalid instr_def");

		string fwd_start_code 		= tmpl.fwd_start_code();
		string maturity_code 		= tmpl.maturity_code();		
		string spot_settle_code		= tmpl.spot_settle_code();
		
		integer fix_r_rnd_dec		= -1;
		number fx_quote				= 1;
		string fx_quote_baseccy		= null;
		string fx_quote_priceccy	= null;
		logical pv_in_base_ccy		= null;
			
		//fix leg
		date  	fix_eff_date		= null<date>;
		date  	fix_first_cpn_date	= null<date>;
		date  	fix_last_reg_date	= null<date>;																								
		number 	fix_notional		= notional;
		stub_type fix_stub_type		= stub_type.SHORT_FIRST;
		//float leg
		date  	flt_eff_date		= null<date>;
		date  	flt_first_cpn_date	= null<date>;
		date  	flt_last_reg_date	= null<date>;							
		number 	flt_notional		= notional;				
		stub_type flt_stub_type		= stub_type.SHORT_FIRST;
				
		vector(date) flt_fixing_dates 	= null<vector(date)>;	
		vector(number) flt_fixing_rates	= null<vector(number)>;	
		number  	flt_fix_proxy 		= null<number>; 
		logical   	flt_allow_fwd_fix 	= false;
		
		//create empty parm
		CORE_SWAPLIB.fixflt_parm fifl = new CORE_SWAPLIB.fixflt_parm();

		//update parm with init_basic_static
		fifl.init_static(def,spot_settle_code);

		//basic checks after instr_def update
		QL_REQUIRE(!fifl.is_cross_currency(),"invalid template (must be single currency)");
		
		number pv01_not_unit  		= 100000;//rounding unit for notional when implied from pv01					
		number	fix_pv01 			= null;
		number	fix_start_stub 		= null;
		number	fix_end_stub 		= null;
		//update parm with current input
		fifl.set_plain(	name,trade_date, settle_date,  start_date,fwd_start_code,maturity, maturity_code,pay_fixed,						
						fix_r_rnd_dec,pv01_not_unit, fx_quote,fx_quote_baseccy, fx_quote_priceccy,pv_in_base_ccy,						
						fix_coupon_rate,fix_stub_type,fix_eff_date, fix_first_cpn_date,fix_last_reg_date, fix_notional, fix_pv01,						
						flt_spread, flt_stub_type, flt_eff_date, flt_first_cpn_date, flt_last_reg_date, flt_notional, 
						flt_curr_fix, flt_fixing_dates , flt_fixing_rates, flt_fix_proxy , flt_allow_fwd_fix,fix_start_stub,fix_end_stub);
		
		swap = fifl.create_swap(disc_func, disc_func, flt_fwd_func);
			
		QL_FAIL_COND(e.is_error(),e.message());
		QL_FAIL_COND(null(swap),"invalid swap");
		return ;
	}
}