/*	
	fix-ois swap example with a template
	Algorithmica Research, Magnus Nyström
			
*/

option(null: hard); // Throw an error if a null value is used in a non-nullable context

module BP_INST
{	
	/*-----------------------------------------------------------------------
	  swap_fix_ois_single_ccy_tmpl
	  ----------------------------------------------------------------------*/	
	swap_fixois swap_fix_ois_single_ccy_tmpl( INSTR_TMPL.swap_fixois_def_tmpl	tmpl,
											  string 							name,
											  date 	option(nullable) 			trade_date,
											  date option(nullable) 			settle_date,
											  date option(nullable) 			start_date,
											  date option(nullable) 			maturity,
											  number 							notional,
											  logical							pay_fixed,
											  disc_func option(nullable) 		disc_func,
											  number option(nullable) 			fix_coupon_rate,//decimal
											  number option(nullable) 			ois_spread,//decimal
											  fwd_func  option(nullable) 		fwd_func,											  
											  error_info option(nullable) 		e)
	{
		string fwd_start_code 		= tmpl.fwd_start_code();
		string maturity_code 		= tmpl.maturity_code();
		
		integer fix_r_rnd_dec		= -1;//-1 --> no rounding				
		number pv01_not_unit  		= 100000;//rounding unit for notional when implied from pv01					
		number fix_pv01 			= null;

		if(null(fix_coupon_rate) && (null(disc_func) || null(fwd_func) || null(trade_date)))
		   QL_FAIL("fix_coupon_rate cannot be implied due to incomplete input");

		if(null(maturity) && null(maturity_code))
		   QL_FAIL("invalid maturity/maturity_code");

		if(null(trade_date) && null(settle_date) && null(start_date) && null(fwd_start_code))
		   QL_FAIL("swap start not valid");//if either tradedate or settledate is input the startdate is implied via spot_code
		
		//create empty parm
		CORE_SWAPLIB.fixois_parm fio = new CORE_SWAPLIB.fixois_parm();

		//update parm with static data using the template
		fio.init_static(tmpl);

		//some checks eg. that we have an appropriate template
		QL_REQUIRE(!fio.is_cross_currency(),"invalid template (must be single currency)");
		
		fio.set_plain_single_ccy(	name,trade_date,settle_date,start_date,fwd_start_code,maturity ,
									maturity_code, pay_fixed, fix_r_rnd_dec,pv01_not_unit, notional,fix_pv01,
									fix_coupon_rate, ois_spread );

		logical sync_endog_ok 		= true;//if this is true we are in charge of making sure that fwd_func and disc_func are in sync in case we have self discounting
		swap_fixois swap 			= fio.create_swap(disc_func, disc_func, fwd_func,null,sync_endog_ok);
			
		QL_FAIL_COND(e.is_error(),e.message());
		QL_FAIL_COND(null(swap),"invalid swap");
		return swap;
	}
}