/*	
	float-float swap example with a template
	Algorithmica Research, Magnus Nyström
			
*/

option(null: hard); // Throw an error if a null value is used in a non-nullable context

module BP_INST
{
	/*-----------------------------------------------------------------------
	  swap_flt_flt_single_ccy_tmpl
	  ----------------------------------------------------------------------*/	
	swap_fltflt swap_flt_flt_single_ccy_tmpl( INSTR_TMPL.swap_fltflt_def_tmpl	tmpl,
											  string 							name,
											  date 	option(nullable) 			trade_date,
											  date option(nullable) 			settle_date,
											  date option(nullable) 			start_date,
											  date option(nullable) 			maturity,
											  number 							notional,
											  logical							pay_float1,
											  disc_func option(nullable) 		disc_func,
											  number option(nullable) 			flt1_spread,//decimal
											  number option(nullable) 			flt1_curr_fix ,//decimal
											  fwd_func  option(nullable) 		flt1_fwd_func,	
											  number option(nullable) 			flt2_spread,//decimal
											  number option(nullable) 			flt2_curr_fix ,//decimal
											  fwd_func  option(nullable) 		flt2_fwd_func,											  
											  error_info option(nullable) 		e)
	{
		string fwd_start_code 		= tmpl.fwd_start_code();
		string maturity_code 		= tmpl.maturity_code();
		
		integer imp_sprd_dec		= -1;//-1 --> no rounding				
		number pv01_not_unit  		= 100000;//rounding unit for notional when implied from pv01					
		number flt1_pv01 			= null;//the leg in question depends on which leg is the quote leg (use fltflt_parm.primary_quote_is_flt())
		
		if(null(maturity) && null(maturity_code))
		   QL_FAIL("invalid maturity/maturity_code");

		if(null(trade_date) && null(settle_date) && null(start_date) && null(fwd_start_code))
		   QL_FAIL("swap start not valid");//if either tradedate or settledate is input the startdate is implied via spot_code
		
		//create empty parm
		CORE_SWAPLIB.fltflt_parm flfl = new CORE_SWAPLIB.fltflt_parm();

		//update parm with static data using the template
		flfl.init_static(tmpl);
			
		if(null(flt1_spread) && (null(disc_func) || null(flt1_fwd_func) || null(trade_date)))
			QL_FAIL("flt_spread_rate cannot be implied due to incomplete input");
				
		//some checks eg. that we have an appropriate template
		QL_REQUIRE(!flfl.is_cross_currency(),"invalid template (must be single currency)");
		
		flfl.set_plain_single_ccy(	name,trade_date,settle_date,start_date,fwd_start_code,maturity ,
									maturity_code, pay_float1, imp_sprd_dec,pv01_not_unit, notional,flt1_pv01,
									flt1_spread, flt1_curr_fix, flt2_spread, flt2_curr_fix );
			
		logical flt_allow_extrap	= false;//do not allow extrap of fwd rates when we have an odd start or odd end period
		swap_fltflt swap 			= flfl.create_swap(disc_func, flt1_fwd_func, disc_func, flt2_fwd_func,flt_allow_extrap);
			
		QL_FAIL_COND(e.is_error(),e.message());
		QL_FAIL_COND(null(swap),"invalid swap");
		return swap;
	}

	/*-----------------------------------------------------------------------
	  swap_flt_flt_cross_ccy_tmpl
	  ----------------------------------------------------------------------*/	
	swap_fltflt swap_flt_flt_cross_ccy_tmpl(INSTR_TMPL.swap_fltflt_def_tmpl	tmpl,
											string 							name,
											date 	option(nullable) 		trade_date,
											date option(nullable) 			settle_date,
											date option(nullable) 			start_date,
											date option(nullable) 			maturity,
											number option(nullable) 		fx_quote,//as of settledate
											number option(nullable) 		fx_mtm_spot_quote,//as of spot date NOT swap settle
											string 							fx_quote_baseccy,
											string 							fx_quote_priceccy,
											logical 						pv_in_base_ccy,										
											logical							pay_flt1,
											//flt1
											number 							flt1_notional,											  
											disc_func option(nullable) 		flt1_disc_func,
											number option(nullable) 		flt1_spread,//decimal
											number option(nullable) 		flt1_curr_fix ,//decimal
											fwd_func  option(nullable) 		flt1_fwd_func,
											//flt2
											number 							flt2_notional,
											disc_func option(nullable) 		flt2_disc_func,
											number option(nullable) 		flt2_spread,//decimal
											number option(nullable) 		flt2_curr_fix ,//decimal
											fwd_func  option(nullable) 		flt2_fwd_func,											  
											error_info option(nullable) 	e)
	{
		string fwd_start_code 		= tmpl.fwd_start_code();
		string maturity_code 		= tmpl.maturity_code();
		
		integer imp_sprd_dec		= -1;//-1 --> no rounding				
		number pv01_not_unit  		= 100000;//rounding unit for notional when implied from pv01					
		number flt1_pv01 			= null;//the leg in question depends on which leg is the quote leg (use fltflt_parm.primary_quote_is_flt())
		
		if(null(maturity) && null(maturity_code))
		   QL_FAIL("invalid maturity/maturity_code");

		if(null(trade_date) && null(settle_date) && null(start_date) && null(fwd_start_code))
		   QL_FAIL("swap start not valid");//if either tradedate or settledate is input the startdate is implied via spot_code
		
		//create empty parm
		CORE_SWAPLIB.fltflt_parm flfl = new CORE_SWAPLIB.fltflt_parm();

		//update parm with static data using the template
		flfl.init_static(tmpl);
			
		logical q_is_1 = flfl.primary_quote_is_leg1();
		if(q_is_1) {
			if(null(flt1_spread) && (null(flt1_disc_func) || null(flt1_fwd_func) || null(trade_date)))
				QL_FAIL("flt1_spread_rate cannot be implied due to incomplete input");
		}
		else {
			if(null(flt2_spread) && (null(flt2_disc_func) || null(flt2_fwd_func) || null(trade_date)))
				QL_FAIL("flt1_spread_rate cannot be implied due to incomplete input");
		}

		stub_type  flt1_stub_type 		= null;
		date  flt1_eff_date 			= null;
		date  flt1_first_cpn_date 		= null;
		date  flt1_last_reg_date 		= null;
		vector(date) flt1_fixing_dates  = null;	
		vector(number) flt1_fixing_rates = null;
		number flt1_fix_proxy  			= null;
		logical flt1_allow_fwd_fix 		= null;

		stub_type flt2_stub_type 		= null;
		date flt2_eff_date 				= null;
		date flt2_first_cpn_date 		= null;
		date flt2_last_reg_date 		= null;
		vector(date) flt2_fixing_dates  = null;	
		vector(number) flt2_fixing_rates = null;
		number flt2_fix_proxy  			= null;
		logical flt2_allow_fwd_fix 		= null;

		flfl.set_plain(name, trade_date,settle_date,start_date,fwd_start_code,maturity ,
						maturity_code, pay_flt1, imp_sprd_dec,pv01_not_unit,
						fx_quote, fx_quote_baseccy, fx_quote_priceccy, pv_in_base_ccy,
								//flt1
						flt1_spread,
						flt1_stub_type,
						flt1_eff_date,
						flt1_first_cpn_date,
						flt1_last_reg_date,
						flt1_notional,
						flt1_pv01,
						flt1_curr_fix,
						flt1_fixing_dates ,	
						flt1_fixing_rates,
						flt1_fix_proxy ,
						flt1_allow_fwd_fix,
								//flt2
						flt2_spread,
						flt2_stub_type,
						flt2_eff_date,
						flt2_first_cpn_date,
						flt2_last_reg_date,
						flt2_notional,
						flt2_curr_fix,
						flt2_fixing_dates ,	
						flt2_fixing_rates,
						flt2_fix_proxy ,
						flt2_allow_fwd_fix);
			

		flfl.set_mtm_data(fx_mtm_spot_quote);//currently not as an input in set_plain func so need to set it separately

		
		logical flt_allow_extrap	= false;//do not allow extrap of fwd rates when we have an odd start or odd end period
		swap_fltflt swap = flfl.create_swap(flt1_disc_func, flt1_fwd_func, flt2_disc_func, flt2_fwd_func,flt_allow_extrap);
	
			
		QL_FAIL_COND(e.is_error(),e.message());
		QL_FAIL_COND(null(swap),"invalid swap");
		return swap;
	}
}