/*	
	float-float (2swap) swap example with a template
	Algorithmica Research, Magnus Nyström
			
*/

option(null: hard); // Throw an error if a null value is used in a non-nullable context

module BP_INST
{
	
	/*-----------------------------------------------------------------------
	  swap_flt_flt2s_tmpl
	  ----------------------------------------------------------------------*/	
	void swap_flt_flt2s_tmpl( 	INSTR_TMPL.swap_fltflt2s_def_tmpl	tmpl,//tmpl requires sprd_swap reset freq > flat_swap reset freq
								string 							name,
								date 	option(nullable) 		trade_date,
								date option(nullable) 			settle_date,
								date option(nullable) 			start_date,
								date option(nullable) 			maturity,
								number 							notional,
								logical							pay_sprd_leg,
								disc_func option(nullable) 		disc_func,
								number option(nullable) 		fix_spread,//decimal, spread on swap with highest reset_freq == sprd_swap
								number option(nullable) 		fix_cpn_rate_flat,
								number option(nullable) 		flt_sprd_curr_fix ,//decimal
								fwd_func  option(nullable) 		flt_sprd_fwd_func,
								number option(nullable) 		flt_flat_curr_fix ,//decimal								
								fwd_func  option(nullable) 		flt_flat_fwd_func,
								out swap_fixflt 				swap_fix_s,
								out swap_fixflt 				swap_fix_f,
								error_info option(nullable) 		e)
	{
		string fwd_start_code 		= tmpl.fwd_start_code();
		string maturity_code 		= tmpl.maturity_code();
		
		integer imp_fix_rate_dec	= -1;//-1 --> no rounding				
		number pv01_not_unit  		= 100000;//rounding unit for notional when implied from pv01					
		number fix_pv01 			= null;//the leg in question depends on which leg is the quote leg (use fltois_parm.primary_quote_is_flt())
		
		if(null(maturity) && null(maturity_code))
		   QL_FAIL("invalid maturity/maturity_code");

		if(null(trade_date) && null(settle_date) && null(start_date) && null(fwd_start_code))
		   QL_FAIL("swap start not valid");//if either tradedate or settledate is input the startdate is implied via spot_code
		
		//create empty parm
		CORE_SWAPLIB.fltflt2s_parm flfl = new CORE_SWAPLIB.fltflt2s_parm();

		//update parm with static data using the template
		flfl.init_static(tmpl);	
		
		//some checks eg. that we have an appropriate template
		QL_REQUIRE(!flfl.is_cross_currency(),"invalid template (must be single currency)");
		
		flfl.set_plain(	name,trade_date,settle_date,start_date,fwd_start_code,maturity ,
						maturity_code, pay_sprd_leg, imp_fix_rate_dec,pv01_not_unit, notional,fix_pv01,
						fix_cpn_rate_flat, fix_spread, flt_sprd_curr_fix, flt_flat_curr_fix );
			
		logical flt_allow_extrap	= false;//do not allow extrap of fwd rates when we have an odd start or odd end period
		
		flfl.create_swap(disc_func, flt_sprd_fwd_func, flt_flat_fwd_func, swap_fix_s,swap_fix_f,flt_allow_extrap,true);
			
		QL_FAIL_COND(e.is_error(),e.message());
		QL_FAIL_COND(null(swap_fix_s),"invalid swap_fixois");
		QL_FAIL_COND(null(swap_fix_f),"invalid swap_fixflt");
		return ;
	}
}