/*	
	float-ois (2swap) swap example with a template
	Algorithmica Research, Magnus Nyström
			
*/

option(null: hard); // Throw an error if a null value is used in a non-nullable context

module BP_INST
{
	
	/*-----------------------------------------------------------------------
	  swap_flt_ois2s_tmpl
	  ----------------------------------------------------------------------*/	
	void swap_flt_ois2s_tmpl( 	INSTR_TMPL.swap_fltois2s_def_tmpl	tmpl,
								string 							name,
								date 	option(nullable) 		trade_date,
								date option(nullable) 			settle_date,
								date option(nullable) 			start_date,
								date option(nullable) 			maturity,
								number 							notional,
								logical							pay_sprd_leg,
								disc_func option(nullable) 		disc_func,
								number option(nullable) 		fixo_spread,//decimal, spread on fixois swap always
								number option(nullable) 		fixf_cpn_rate_flat,
								number option(nullable) 		flt_curr_fix ,//decimal
								fwd_func  option(nullable) 		flt_fwd_func,												 
								fwd_func  option(nullable) 		ois_fwd_func,
								out swap_fixois 				swap_fixo,
								out swap_fixflt 				swap_fixf,
								error_info option(nullable) 		e)
	{
		string fwd_start_code 		= tmpl.fwd_start_code();
		string maturity_code 		= tmpl.maturity_code();
		
		integer imp_fix_rate_dec	= -1;//-1 --> no rounding				
		number pv01_not_unit  		= 100000;//rounding unit for notional when implied from pv01					
		number fix_pv01 			= null;//the leg in question depends on which leg is the quote leg (use fltois_parm.primary_quote_is_flt())
		
		if(null(maturity) && null(maturity_code))
		   QL_FAIL("invalid maturity/maturity_code");

		if(null(trade_date) && null(settle_date) && null(start_date) && null(fwd_start_code))
		   QL_FAIL("swap start not valid");//if either tradedate or settledate is input the startdate is implied via spot_code
		
		//create empty parm
		CORE_SWAPLIB.fltois2s_parm fio = new CORE_SWAPLIB.fltois2s_parm();

		//update parm with static data using the template
		fio.init_static(tmpl);
		
		//some checks eg. that we have an appropriate template
		QL_REQUIRE(!fio.is_cross_currency(),"invalid template (must be single currency)");
		
		fio.set_plain(	name,trade_date,settle_date,start_date,fwd_start_code,maturity ,
						maturity_code, pay_sprd_leg, imp_fix_rate_dec,pv01_not_unit, notional,fix_pv01,
						fixo_spread, fixf_cpn_rate_flat, flt_curr_fix );
			
		logical sync_endog_ok 		= true;//if this is true we are in charge of making sure that fwd_func and disc_func are in sync in case we have self discounting
		logical flt_allow_extrap	= false;//do not allow extrap of fwd rates when we have an odd start or odd end period

		
		fio.create_swap(disc_func, null<disc_func>, flt_fwd_func, null<disc_func>, ois_fwd_func, sync_endog_ok, swap_fixo,swap_fixf,flt_allow_extrap);
			
		QL_FAIL_COND(e.is_error(),e.message());
		QL_FAIL_COND(null(swap_fixo),"invalid swap_fixois");
		QL_FAIL_COND(null(swap_fixf),"invalid swap_fixflt");
		return ;
	}
}