/*	
	ois-ois swap example with a template
	Algorithmica Research, Magnus Nyström
			
*/

option(null: hard); // Throw an error if a null value is used in a non-nullable context

module BP_INST
{
	/*-----------------------------------------------------------------------
	  swap_ois_ois_single_ccy_tmpl
	  ----------------------------------------------------------------------*/	
	swap_oisois swap_ois_ois_single_ccy_tmpl( INSTR_TMPL.swap_oisois_def_tmpl	tmpl,
											  string 							name,
											  date 	option(nullable) 			trade_date,
											  date option(nullable) 			settle_date,
											  date option(nullable) 			start_date,
											  date option(nullable) 			maturity,
											  number 							notional,
											  logical							pay_ois1,
											  disc_func option(nullable) 		disc_func,
											  number option(nullable) 			ois1_spread,//decimal
											  fwd_func  option(nullable) 		ois1_fwd_func,	
											  number option(nullable) 			ois2_spread,//decimal
											  fwd_func  option(nullable) 		ois2_fwd_func,											  
											  error_info option(nullable) 		e)
	{
		string fwd_start_code 		= tmpl.fwd_start_code();
		string maturity_code 		= tmpl.maturity_code();
		
		integer imp_sprd_dec		= -1;//-1 --> no rounding				
		number pv01_not_unit  		= 100000;//rounding unit for notional when implied from pv01					
		number ois1_pv01 			= null;//the leg in question depends on which leg is the quote leg (use oisois_parm.primary_quote_is_flt())
		
		if(null(maturity) && null(maturity_code))
		   QL_FAIL("invalid maturity/maturity_code");

		if(null(trade_date) && null(settle_date) && null(start_date) && null(fwd_start_code))
		   QL_FAIL("swap start not valid");//if either tradedate or settledate is input the startdate is implied via spot_code
		
		//create empty parm
		CORE_SWAPLIB.oisois_parm oo = new CORE_SWAPLIB.oisois_parm();

		//update parm with static data using the template
		oo.init_static(tmpl);
			
		if(null(ois1_spread) && (null(disc_func) || null(ois1_fwd_func) || null(trade_date)))
			QL_FAIL("ois1_spread_rate cannot be implied due to incomplete input");
				
		//some checks eg. that we have an appropriate template
		QL_REQUIRE(!oo.is_cross_currency(),"invalid template (must be single currency)");
		
		oo.set_plain_single_ccy(	name,trade_date,settle_date,start_date,fwd_start_code,maturity ,
									maturity_code, pay_ois1, imp_sprd_dec,pv01_not_unit, notional,ois1_pv01,
									ois1_spread, ois2_spread );
			
		swap_oisois swap 			= oo.create_swap(disc_func, ois1_fwd_func, disc_func, ois2_fwd_func);
			
		QL_FAIL_COND(e.is_error(),e.message());
		QL_FAIL_COND(null(swap),"invalid swap");
		return swap;
	}

	/*-----------------------------------------------------------------------
	  swap_ois_ois_cross_ccy_tmpl
	  ----------------------------------------------------------------------*/	
	swap_oisois swap_ois_ois_cross_ccy_tmpl(INSTR_TMPL.swap_oisois_def_tmpl	tmpl,
											string 							name,
											date 	option(nullable) 		trade_date,
											date option(nullable) 			settle_date,
											date option(nullable) 			start_date,
											date option(nullable) 			maturity,
											number option(nullable) 		fx_quote,//spot
											number option(nullable) 		fx_mtm_spot_quote,//as of spot date NOT swap settle
											string 							fx_quote_baseccy,
											string 							fx_quote_priceccy,
											logical 						pv_in_base_ccy,											 
											logical							pay_ois1,
											//ois1
											number 							ois1_notional,											  
											disc_func option(nullable) 		ois1_disc_func,
											number option(nullable) 		ois1_spread,//decimal
											fwd_func  option(nullable) 		ois1_fwd_func,
											//ois2
											number 							ois2_notional,
											disc_func option(nullable) 		ois2_disc_func,
											number option(nullable) 		ois2_spread,//decimal
											fwd_func  option(nullable) 		ois2_fwd_func,											  
											error_info option(nullable) 	e)
	{
		string fwd_start_code 		= tmpl.fwd_start_code();
		string maturity_code 		= tmpl.maturity_code();
		
		integer imp_sprd_dec		= -1;//-1 --> no rounding				
		number pv01_not_unit  		= 100000;//rounding unit for notional when implied from pv01					
		number ois1_pv01 			= null;//the leg in question depends on which leg is the quote leg (use oisois_parm.primary_quote_is_flt())
		
		if(null(maturity) && null(maturity_code))
		   QL_FAIL("invalid maturity/maturity_code");

		if(null(trade_date) && null(settle_date) && null(start_date) && null(fwd_start_code))
		   QL_FAIL("swap start not valid");//if either tradedate or settledate is input the startdate is implied via spot_code
		
		//create empty parm
		CORE_SWAPLIB.oisois_parm oo = new CORE_SWAPLIB.oisois_parm();

		//update parm with static data using the template
		oo.init_static(tmpl);

		logical q_is_1 = oo.primary_quote_is_leg1();
		if(q_is_1) {
			if(null(ois1_spread) && ((null(ois1_disc_func) && null(ois1_fwd_func)) || null(trade_date)))
				QL_FAIL("ois1_spread cannot be implied due to incomplete input");
		}
		else {
			if(null(ois2_spread) && ((null(ois2_disc_func) && null(ois2_fwd_func)) || null(trade_date)))
				QL_FAIL("flt1_spread_rate cannot be implied due to incomplete input");
		}
		
				

		stub_type  ois1_stub_type 		= null;
		date  ois1_eff_date 			= null;
		date  ois1_first_cpn_date 		= null;
		date  ois1_last_reg_date 		= null;
		vector(date) ois1_fixing_dates  = null;	
		vector(number) ois1_fixing_rates = null;
		number ois1_fix_proxy  			= null;
		logical ois1_allow_fwd_fix 		= null;

		stub_type ois2_stub_type 		= null;
		date ois2_eff_date 				= null;
		date ois2_first_cpn_date 		= null;
		date ois2_last_reg_date 		= null;
		vector(date) ois2_fixing_dates  = null;	
		vector(number) ois2_fixing_rates = null;
		number ois2_fix_proxy  			= null;
		logical ois2_allow_fwd_fix 		= null;
		
		oo.set_plain(	name,trade_date,settle_date,start_date,fwd_start_code,maturity ,
						maturity_code, pay_ois1, imp_sprd_dec,pv01_not_unit,
						fx_quote, fx_quote_baseccy, fx_quote_priceccy, pv_in_base_ccy,
						//ois1
						ois1_spread,
						ois1_stub_type,
						ois1_eff_date,
						ois1_first_cpn_date,
						ois1_last_reg_date,
						ois1_notional,
						ois1_pv01,
						ois1_fixing_dates ,	
						ois1_fixing_rates,
						ois1_fix_proxy ,
						ois1_allow_fwd_fix,
						//ois2
						ois2_spread,
						ois2_stub_type,
						ois2_eff_date,
						ois2_first_cpn_date,
						ois2_last_reg_date,
						ois2_notional,
						ois2_fixing_dates ,	
						ois2_fixing_rates,
						ois2_fix_proxy ,
						ois2_allow_fwd_fix);				
				
		oo.set_mtm_data(fx_mtm_spot_quote);//currently not as an input in set_plain func so need to set it separately

		
		swap_oisois swap = oo.create_swap(ois1_disc_func, ois1_fwd_func, ois2_disc_func, ois2_fwd_func);
			
		QL_FAIL_COND(e.is_error(),e.message());
		QL_FAIL_COND(null(swap),"invalid swap");
		return swap;
	}
}