option(null: hard);

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_swap_leg.present_value(logical option(nullable) trade_date_pv = false)
{
	if(null(trade_date_pv))
		trade_date_pv = false;

	if(trade_date_pv)
		throw(E_INVALID_ARG,"trade_date_pv argument no longer supported");
	//date pv_date 			= trade_date_pv ? this.trade_date() : this.settlement_date();
	date settle 			= this.settlement_date();
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(settle,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_swap_leg.present_value(	date option(nullable) pv_date,
									date option(nullable) settle_date)
	option(com_name: 'present_value_alt')
{
	if(!null(pv_date))
		throw(E_INVALID_ARG,"pv_date argument no longer supported");
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(settle_date,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_swap_leg.present_value(	..disc_func disc_func,
									logical option(nullable) trade_date_pv = false)
	option(com_name: 'present_value_ext')
{
	if(null(trade_date_pv))
		trade_date_pv = false;

	if(trade_date_pv)
		throw(E_INVALID_ARG,"trade_date_pv argument no longer supported");
	
	//date pv_date 			= trade_date_pv ? this.trade_date() : this.settlement_date();
	date settle 			= this.settlement_date();
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(disc_func,settle,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_swap_leg.present_value(	..disc_func disc_func,
									date option(nullable) pv_date,
									date option(nullable) settle_date)	
	option(com_name: 'present_value_ext_alt')
{
	if(!null(pv_date))
		throw(E_INVALID_ARG,"pv_date argument no longer supported");
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(disc_func, settle_date,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_fix_leg.present_value(logical option(nullable) trade_date_pv = false)
{
	if(null(trade_date_pv))
		trade_date_pv = false;

	if(trade_date_pv)
		throw(E_INVALID_ARG,"trade_date_pv argument no longer supported");
	
	//date pv_date 			= trade_date_pv ? this.trade_date() : this.settlement_date();
	date settle 			= this.settlement_date();
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value( settle,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_fix_leg.present_value(	date option(nullable) pv_date,
									date option(nullable) settle_date)
	option(com_name: 'present_value_alt')
{
	if(!null(pv_date))
		throw(E_INVALID_ARG,"pv_date argument no longer supported");
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value( settle_date,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_fix_leg.present_value(	..disc_func disc_func,
									logical option(nullable) trade_date_pv = false)
	option(com_name: 'present_value_ext')
{
	if(null(trade_date_pv))
		trade_date_pv = false;

	if(trade_date_pv)
		throw(E_INVALID_ARG,"trade_date_pv argument no longer supported");
	
	//date pv_date 			= trade_date_pv ? this.trade_date() : this.settlement_date();
	date settle 			= this.settlement_date();
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(disc_func, settle,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_fix_leg.present_value(	..disc_func disc_func,
									date option(nullable) pv_date,
									date option(nullable) settle_date)	
	option(com_name: 'present_value_ext_alt')
{
	if(!null(pv_date))
		throw(E_INVALID_ARG,"pv_date argument no longer supported");
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(disc_func, settle_date,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_float_leg.present_value(logical option(nullable) trade_date_pv = false)
{
	if(null(trade_date_pv))
		trade_date_pv = false;

	if(trade_date_pv)
		throw(E_INVALID_ARG,"trade_date_pv argument no longer supported");
	
	//date pv_date 			= trade_date_pv ? this.trade_date() : this.settlement_date();
	date settle 			= this.settlement_date();
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value( settle,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_float_leg.present_value(	date option(nullable) pv_date,
									date option(nullable) settle_date)
	option(com_name: 'present_value_alt')
{
	if(!null(pv_date))
		throw(E_INVALID_ARG,"pv_date argument no longer supported");
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value( settle_date,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_float_leg.present_value(	..disc_func disc_func,
									..tenor_surface tenor_surface,
									logical option(nullable) trade_date_pv = false)
	option(com_name: 'present_value_ext')
{
	if(null(trade_date_pv))
		trade_date_pv = false;

	if(trade_date_pv)
		throw(E_INVALID_ARG,"trade_date_pv argument no longer supported");
	
	//date pv_date 			= trade_date_pv ? this.trade_date() : this.settlement_date();
	date settle 			= this.settlement_date();
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(disc_func,tenor_surface, settle,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_float_leg.present_value(	..disc_func disc_func,
									..tenor_surface tenor_surface,
									date option(nullable) pv_date,
									date option(nullable) settle_date)	
	option(com_name: 'present_value_ext_alt')
{
	if(!null(pv_date))
		throw(E_INVALID_ARG,"pv_date argument no longer supported");
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(disc_func,tenor_surface, settle_date,incl_issue_cf,incl_mat_cf);
}

/**/

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_ois_leg.present_value(logical option(nullable) trade_date_pv = false)
{
	if(null(trade_date_pv))
		trade_date_pv = false;

	if(trade_date_pv)
		throw(E_INVALID_ARG,"trade_date_pv argument no longer supported");
	//date pv_date 			= trade_date_pv ? this.trade_date() : this.settlement_date();
	date settle 			= this.settlement_date();
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value( settle,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_ois_leg.present_value(	date option(nullable) pv_date,
									date option(nullable) settle_date)
	option(com_name: 'present_value_alt')
{
	if(!null(pv_date))
		throw(E_INVALID_ARG,"pv_date argument no longer supported");
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value( settle_date,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_ois_leg.present_value(	..disc_func disc_func,
									..tenor_surface tenor_surface,
									logical option(nullable) trade_date_pv = false)
	option(com_name: 'present_value_ext')
{
	if(null(trade_date_pv))
		trade_date_pv = false;

	if(trade_date_pv)
		throw(E_INVALID_ARG,"trade_date_pv argument no longer supported");
	
	//date pv_date 			= trade_date_pv ? this.trade_date() : this.settlement_date();
	date settle 			= this.settlement_date();
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(disc_func,tenor_surface, settle,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_ois_leg.present_value(	..disc_func disc_func,
									..tenor_surface tenor_surface,
									date option(nullable) pv_date,
									date option(nullable) settle_date)	
	option(com_name: 'present_value_ext_alt')
{
	if(!null(pv_date))
		throw(E_INVALID_ARG,"pv_date argument no longer supported");
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(disc_func,tenor_surface, settle_date,incl_issue_cf,incl_mat_cf);
}

/**/

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_fix_zero_leg.present_value(logical option(nullable) trade_date_pv = false)
{
	if(null(trade_date_pv))
		trade_date_pv = false;

	if(trade_date_pv)
		throw(E_INVALID_ARG,"trade_date_pv argument no longer supported");
	
	//date pv_date 			= trade_date_pv ? this.trade_date() : this.settlement_date();
	date settle 			= this.settlement_date();
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value( settle,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_fix_zero_leg.present_value(	date option(nullable) pv_date,
										date option(nullable) settle_date)
	option(com_name: 'present_value_alt')
{
	if(!null(pv_date))
		throw(E_INVALID_ARG,"pv_date argument no longer supported");
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value( settle_date,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_fix_zero_leg.present_value(	..disc_func disc_func,
										logical option(nullable) trade_date_pv = false)
	option(com_name: 'present_value_ext')
{
	if(null(trade_date_pv))
		trade_date_pv = false;

	if(trade_date_pv)
		throw(E_INVALID_ARG,"trade_date_pv argument no longer supported");
	
	//date pv_date 			= trade_date_pv ? this.trade_date() : this.settlement_date();
	date settle 			= this.settlement_date();
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(disc_func, settle,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number ql_fix_zero_leg.present_value(	..disc_func disc_func,
										date option(nullable) pv_date,
										date option(nullable) settle_date)	
	option(com_name: 'present_value_ext_alt')
{
	if(!null(pv_date))
		throw(E_INVALID_ARG,"pv_date argument no longer supported");
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(disc_func, settle_date,incl_issue_cf,incl_mat_cf);
}


/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number  ql_fixed_income_swap.present_value(	out number 	pv_leg1,
											out number 	pv_leg2,
											logical option(nullable) trade_date_pv = false) 
{
	if(null(trade_date_pv))
		trade_date_pv = false;
	
	date pv_date 			= trade_date_pv ? this.trade_date() : this.settlement_date();
	date settle 			= this.settlement_date();
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(pv_leg1,pv_leg2,pv_date, settle,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number  ql_fixed_income_swap.present_value(disc_func disc_func_leg1,
											disc_func option(nullable) disc_func_leg2,
											out number 	pv_leg1,
											out number 	pv_leg2,
											logical option(nullable) trade_date_pv = false)
	option(com_name: 'present_value_ext')
{
	if(null(trade_date_pv))
		trade_date_pv = false;

	date pv_date 			= trade_date_pv ? this.trade_date() : this.settlement_date();
	date settle 			= this.settlement_date();
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,
							  pv_date, settle,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  present_value   overload
  ----------------------------------------------------------------------*/
number  ql_fixed_income_swap.present_value(disc_func disc_func_leg1,
											disc_func option(nullable) disc_func_leg2,
											out number 	pv_leg1,
											out number 	pv_leg2,
											date option(nullable) pv_date,
											date option(nullable) settle_date)
	option(com_name: 'present_value_ext_alt')
{	
	logical incl_issue_cf 	= true;
	logical incl_mat_cf 	= false;
	
	return this.present_value(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,
							  pv_date, settle_date,incl_issue_cf,incl_mat_cf);
}

/*-----------------------------------------------------------------------
  coupon_freq_to_int
  ----------------------------------------------------------------------*/
integer coupon_freq_to_int(coupon_freq freq)
option (category: 'Instrument/Interest Rate Swap (standalone)')
{
	
    switch (freq) {   
    case coupon_freq.CFR_ZERO:		return 0;
    case coupon_freq.CFR_ANN:		return 1 ; 
    case coupon_freq.CFR_SEMI_ANN:	return 2;
    case coupon_freq.CFR_QUART:		return 4;
    case coupon_freq.CFR_MONTH:		return 12;
    //case coupon_freq.CFR_WEEK:	return 52;//currently not supported as coupon freq
    case coupon_freq.CFR_DAILY:		return 365;
    default: 						throw(E_INVALID_ARG,"invalid frequency");

	
    }
}

/*-----------------------------------------------------------------------
  coupon_freq_from_int
  ----------------------------------------------------------------------*/
coupon_freq coupon_freq_from_int(integer freq)
option (category: 'Instrument/Interest Rate Swap (standalone)')
{
	switch (freq) {   
    case 0:		return coupon_freq.CFR_ZERO;
    case 1:		return coupon_freq.CFR_ANN; 
    case 2:		return coupon_freq.CFR_SEMI_ANN;
    case 4:		return coupon_freq.CFR_QUART;
    case 12:	return coupon_freq.CFR_MONTH;
    //case 52:	return coupon_freq.CFR_WEEK;//currently not supported as coupon freq
    case 365:	return coupon_freq.CFR_DAILY;
    default:	throw(E_INVALID_ARG,"invalid frequency");
    }
}
/*-----------------------------------------------------------------------
  reset_freq_to_int
  ----------------------------------------------------------------------*/
integer reset_freq_to_int(reset_freq freq)
option (category: 'Instrument/Interest Rate Swap (standalone)')
{
	
    switch (freq) {   
    case reset_freq.RFR_ZERO:		return 0;
    case reset_freq.RFR_ANN:		return 1 ; 
    case reset_freq.RFR_SEMI_ANN:	return 2;
    case reset_freq.RFR_QUART:		return 4;
    case reset_freq.RFR_MONTH:		return 12;
    case reset_freq.RFR_WEEK:	    return 52;
    case reset_freq.RFR_DAILY:		return 365;
    default: 						throw(E_INVALID_ARG,"invalid frequency");
    }
}
/*-----------------------------------------------------------------------
  reset_freq_from_int
  ----------------------------------------------------------------------*/
reset_freq reset_freq_from_int(integer freq)
option (category: 'Instrument/Interest Rate Swap (standalone)')
{
	switch (freq) {   
    case 0:		return reset_freq.RFR_ZERO;
    case 1:		return reset_freq.RFR_ANN; 
    case 2:		return reset_freq.RFR_SEMI_ANN;
    case 4:		return reset_freq.RFR_QUART;
    case 12:	return reset_freq.RFR_MONTH;
    case 52:	return reset_freq.RFR_WEEK;
    case 365:	return reset_freq.RFR_DAILY;
    default:	throw(E_INVALID_ARG,"invalid frequency");
    }
}

/*-----------------------------------------------------------------------
 ts_ir_index
  ----------------------------------------------------------------------*/
vector(ir_index) ts_ir_index(vector(tenor_code) 		tenor_codes,
							day_count_method 			tenor_daycount,
							bd_convention option(nullable) tenor_bus_day,	
							calendar 					tenor_calendar,
							calendar option(nullable) 	tenor_calendar_ccy,
							rate_type option(nullable) 	tenor_rate_type,
							logical option(nullable) 	tenor_eom,
							integer 					tenor_settle_days,
							string 						tenor_currency,							
							integer  					tenor_reset_days = -1,
							integer 					tenor1day_settle_days = -1,//0=on, 1=tn, 2=sn
							integer 					tenor1day_reset_days = -1)
{
	logical is_libor = !null(tenor_calendar_ccy);
	integer size = v_size(tenor_codes);
	if(size <= 0)
		throw(E_INVALID_ARG,"invalid tenor code vector");		
	
	vector(ir_index) idx[size];

	/*
    tenor_settle_days:	tenor == BD1 --> 0 (=ON), 1 (=TN), 2 (=SN)    
		tenor != BD1 --> spotlag --> 0 or 2
    reset_days:  same as settle_days is the normal case  (and -1 for fedfunds)
*/		
	
	for(integer i=0;i<size;i++){
		if(is_libor){
			if(tenor_codes[i].frequency() == 365){
				if(tenor1day_settle_days == -1)
					tenor1day_settle_days = 0;//o/n is default
				idx[i] = ir_index_libor("LIBOR",tenor_codes[i],tenor1day_settle_days,tenor_currency,tenor_calendar,
										"uk",tenor_calendar_ccy,tenor_currency,tenor_daycount, err_int());
			}
			else {
				idx[i] = ir_index_libor("LIBOR",tenor_codes[i],tenor_settle_days,tenor_currency,tenor_calendar,
										"uk",tenor_calendar_ccy,tenor_currency,tenor_daycount, err_int());
			}
		}
		else {
			integer spot_days = 2;
			if(tenor_codes[i].frequency() == 365){
				if(tenor1day_settle_days == -1)
					tenor1day_settle_days = 0;//o/n is default
				if(tenor1day_reset_days == -1)
					tenor1day_reset_days = tenor1day_settle_days;
				idx[i] = ir_index_ibor("IBOR",tenor_codes[i],tenor1day_settle_days,tenor1day_reset_days,tenor_currency,tenor_calendar,
										tenor_currency,tenor_daycount,tenor_bus_day,tenor_eom,spot_days);
			}
				
			else	{
				if(tenor_reset_days == -1)
					tenor_reset_days = tenor_settle_days;
				idx[i] = ir_index_ibor("IBOR",tenor_codes[i],tenor_settle_days,tenor_reset_days,tenor_currency,tenor_calendar,
										tenor_currency,tenor_daycount,tenor_bus_day,tenor_eom,spot_days);
			}
		}
	}
	return idx;
}

/*-----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
tenor_surface tenor_surface(date 				trade_date,
							disc_func 			disc_curve,
							vector(disc_func) 	tenor_curves,
							vector(tenor_code) 	tenor_codes,
							day_count_method 	tenor_daycount,
							bd_convention option(nullable) tenor_bus_day,	
							calendar 			tenor_calendar,
							calendar option(nullable) 	tenor_calendar_ccy,
							rate_type option(nullable) 	tenor_rate_type,
							logical option(nullable) 	tenor_eom,
							integer 					tenor_settle_days,
							string 						tenor_currency,
							logical option(nullable) allow_extrap = null<logical>,
							integer  					tenor_reset_days = -1,
							integer 					tenor1day_settle_days = -1,//0=on, 1=tn, 2=sn
							integer 					tenor1day_reset_days = -1)
{
	vector(ir_index) idx =  ts_ir_index(tenor_codes,tenor_daycount,tenor_bus_day,tenor_calendar,
							tenor_calendar_ccy,tenor_rate_type,tenor_eom,tenor_settle_days,tenor_currency,
							tenor_reset_days,tenor1day_settle_days,tenor1day_reset_days );
	
	return tenor_surface(trade_date,disc_curve,tenor_curves,idx,allow_extrap);
}
/*-----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
tenor_surface tenor_surface(date 				trade_date,
							disc_func 			disc_curve,
							vector(fwd_func) 	tenor_curves,
							vector(tenor_code) 	tenor_codes,
							day_count_method 	tenor_daycount,
							bd_convention option(nullable) tenor_bus_day,	
							calendar 			tenor_calendar,
							calendar option(nullable) 	tenor_calendar_ccy,
							rate_type option(nullable) 	tenor_rate_type,
							logical option(nullable) 	tenor_eom,
							integer 					tenor_settle_days,
							string 						tenor_currency,
							logical option(nullable) allow_extrap = null<logical>,
							integer  					tenor_reset_days = -1,
							integer 					tenor1day_settle_days = -1,//0=on, 1=tn, 2=sn
							integer 					tenor1day_reset_days = -1)
{
	vector(ir_index) idx =  ts_ir_index(tenor_codes,tenor_daycount,tenor_bus_day,tenor_calendar,
							tenor_calendar_ccy,tenor_rate_type,tenor_eom,tenor_settle_days,tenor_currency,
							tenor_reset_days,tenor1day_settle_days,tenor1day_reset_days );
	
	
	return tenor_surface(trade_date,disc_curve,tenor_curves,idx,allow_extrap);
}

/*-----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
ql_swap_fix_def ql_swap_fix_def(	string					name,	
									string 					currency,
									date_code 				settle_code,
									coupon_freq 			cpn_freq,
									day_count_method 		day_count_method,								
									bd_convention 			bus_day,	
									calendar 				cal,							    
									logical 				eom,																	
									notional_exchg_style 	notional_exchange)
	option (category: 'Instrument/Interest Rate Swap (standalone)') 
{
	return ql_swap_fix_def(name,currency,settle_code,cpn_freq,day_count_method,fix_roll_method.FIR_STRAIGHT,bus_day,	
							cal,eom,null<logical>,null<fix_comp_freq>,null<quote_style>,
							null<round_code>, null<logical>,null<logical>,null<interest_rule>,	0,0,0,0,
							notional_exchange,null<logical>,null<logical>);

	
}

/*-----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
ql_swap_float_def ql_swap_float_def(string					name,	
									string 					currency,
									date_code 				settle_code,
									coupon_freq 			cpn_freq,
									day_count_method 		day_count_method,								
									bd_convention 			bus_day,	
									calendar 				cal,							    
									logical 				eom,								
									ir_index				idx,
									flt_reset_style option(nullable) 	reset_style,
									notional_exchg_style 	notional_exchange)
	option (category: 'Instrument/Interest Rate Swap (standalone)') 
{
	return ql_swap_float_def(name,currency,settle_code,cpn_freq,day_count_method,flt_roll_method.FLR_STRAIGHT,bus_day,	
							cal,eom,null<reset_freq>, idx,null<tenor_code>,null<flt_index_rate_type>, null<coupon_freq>, null<quote_style>,
							null<round_code>,null<round_code>,null<flt_fwd_style>,null<flt_stub_fwd_style>,
							null<logical>,null<logical>,null<interest_rule>,							 
							null<fixing_stub_style>,0,0,0,0,
							null<flt_comp_avg_type>, null<flt_sprd_comp_method> , null<flt_avg_method> ,
							reset_style,notional_exchange,null<logical>,null<logical>);
}


/*-----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
ql_swap_float_def ql_swap_float_def(string					name,	
									string 					currency,
									date_code 				settle_code,
									coupon_freq 			cpn_freq,
									reset_freq 	option(nullable) reset_freq,
									day_count_method 		day_count_method,								
									bd_convention 			bus_day,	
									calendar 				cal,							    
									logical 				eom,
									flt_comp_avg_type option(nullable)		comp_avg,									
									flt_sprd_comp_method option(nullable) 	spread_comp_method,
									flt_avg_method option(nullable) 		avg_method,
									flt_stub_fwd_style option(nullable) stub_fwd_style,
									ir_index				idx,
									flt_reset_style option(nullable) 	reset_style,
									notional_exchg_style 	notional_exchange	)
	option (category: 'Instrument/Interest Rate Swap (standalone)') 
{
	return ql_swap_float_def(name,currency,settle_code,cpn_freq,day_count_method,flt_roll_method.FLR_STRAIGHT,bus_day,	
							cal,eom,reset_freq, idx,null<tenor_code>,null<flt_index_rate_type>, null<coupon_freq>, null<quote_style>,
							null<round_code>,null<round_code>,null<flt_fwd_style>,stub_fwd_style,
							null<logical>,null<logical>,null<interest_rule>,							 
							null<fixing_stub_style>,0,0,0,0,
							comp_avg, spread_comp_method, avg_method ,
							reset_style,notional_exchange,null<logical>,null<logical>);
}



/*-----------------------------------------------------------------------
 ql_swap_fix_zero_def  -plain vanilla version
  ----------------------------------------------------------------------*/
ql_swap_fix_zero_def ql_swap_fix_zero_def(	string					name,	
											string 					currency,
											date_code 				settle_code,											
											day_count_method 		day_count_method,								
											bd_convention 			bus_day,	
											calendar 				cal,
											logical 				eom,
											zero_rate_comp_style    comp_style,
											logical option(nullable) notional_net,	
											logical option(nullable) reverse,	
											notional_exchg_style 	notional_exchange)
	option (category: 'Instrument/Interest Rate Swap (standalone)')
{
	return ql_swap_fix_zero_def(name,currency,settle_code,day_count_method,bus_day,	
							cal,eom,comp_style,notional_net,reverse, null<quote_style>,null<round_code>,
							0,notional_exchange,null<logical>);
}

/*-----------------------------------------------------------------------
 ql_swap_fix_zero_def  -obsolete, only defined for backward compat
  ----------------------------------------------------------------------*/
ql_swap_fix_zero_def ql_swap_fix_zero_def(	string					name,	
											string 					currency,
											date_code 				settle_code,											
											day_count_method 		day_count_method,								
											bd_convention 			bus_day,	
											calendar 				cal,													
											zero_rate_comp_style    comp_style,
											logical option(nullable) notional_net,	
											logical option(nullable) reverse,	
											notional_exchg_style 	notional_exchange)
	option (category: 'Instrument/Interest Rate Swap (standalone)/obsolete')
{
	logical eom = false;
	return ql_swap_fix_zero_def(name,currency,settle_code,day_count_method,bus_day,	
							cal,eom,comp_style,notional_net,reverse, null<quote_style>,null<round_code>,
							0,notional_exchange,null<logical>);
}
/*-----------------------------------------------------------------------
   ql_swap_fix_zero_def  -obsolete, only defined for backward compat
  ----------------------------------------------------------------------*/
ql_swap_fix_zero_def ql_swap_fix_zero_def(	string					name,	
											string 					currency,
											date_code 				settle_code,											
											day_count_method 		day_count_method,								
											bd_convention 			bus_day,	
											calendar 				cal,													
											zero_rate_comp_style    comp_style,
											logical option(nullable) notional_net,	
											logical option(nullable) reverse,
											quote_style	option(nullable) qs,
											round_code option(nullable) pv_round_code,
											number option(nullable) pmt_delay,
											number option(nullable) mat_pmt_delay,//obsolete, not used
											notional_exchg_style 	notional_exchange,
											logical option(nullable) average_notional)
	option (category: 'Instrument/Interest Rate Swap (standalone)/obsolete')
{
	logical eom = false;
	return ql_swap_fix_zero_def(name,currency,settle_code,day_count_method,bus_day,	
							cal,eom,comp_style,notional_net,reverse, qs,pv_round_code,
							pmt_delay,notional_exchange,average_notional);
}

/*-----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
ql_swap_float_def ql_swap_float_def(string					name,	
									string 					currency,
									date_code 				settle_code,
									coupon_freq 			cpn_freq,
									day_count_method 		day_count_method,								
									bd_convention 			bus_day,	
									calendar 				calendar,							    
									logical 				eom,								
									number option(nullable)				reset_days,
									flt_reset_style option(nullable) 	reset_style,
									notional_exchg_style 	notional_exchange)
	option (category: 'Instrument/Interest Rate Swap (standalone)/obsolete')
{
	integer rd = null(reset_days) ? 2 : integer(reset_days);
		
	integer freq = coupon_freq_to_int(cpn_freq);

	if(freq == 0 || freq == 365)
		throw(E_INVALID_ARG,"invalid cpn_freq");	
	
	string m = str(12/freq);
	string t = strcat(m,"M");

	integer spot_days = 2;
	
	ir_index idx = ir_index_ibor("IBOR",t,rd,rd,currency,calendar,
								 "noname",day_count_method,bus_day,eom,spot_days);
	
	return ql_swap_float_def(name,	currency,settle_code,cpn_freq,day_count_method,bus_day,	
							calendar,eom,idx, reset_style, notional_exchange);
}

								
/*-----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
ql_swap_float_def ql_swap_float_def(string				name,	
									string 				currency,
									date_code 			settle_code,
									coupon_freq 		cpn_freq,
									day_count_method 	day_count_method,
									flt_roll_method		roll_method,
									bd_convention 		bus_day,	
									calendar 			calendar,							    
									logical 			eom,
									reset_freq option(nullable)				reset_freq,
									number option(nullable)					reset_days,
									tenor_code option(nullable)				index_tenor,
									flt_index_rate_type option(nullable)	idx_rate_type,
									coupon_freq  option(nullable)			idx_cpn_freq,
									day_count_method option(nullable) 		idx_day_count_method,
									bd_convention option(nullable) 			idx_bus_day,
									calendar option(nullable) 				idx_calendar,//if libor: this is uk
									logical option(nullable) 				idx_eom,									
									quote_style option(nullable) 			quote_style,
									round_code option(nullable) 			pv_round_code,
									round_code option(nullable) 			fwd_rate_round_code,
									flt_fwd_style option(nullable) 			fwd_rate_style,
									flt_stub_fwd_style option(nullable) 	fwd_stub_rate_style,
									logical option(nullable) 				start_stub_sprd_decomp,
									logical option(nullable) 				end_stub_sprd_decomp,									
									interest_rule option(nullable) 			interest_rule, 								
									fixing_stub_style   option(nullable) 	fixing_stub_style,									
									number option(nullable)					pmt_delay,
									number option(nullable)					mat_pmt_delay,
									number option(nullable)					pmt_delay_prin,
									number option(nullable)					mat_pmt_delay_prin,
									flt_comp_avg_type option(nullable)		comp_avg,									
									flt_sprd_comp_method option(nullable) 	spread_comp_method,
									flt_avg_method option(nullable) 		avg_method,
									flt_reset_style option(nullable) 		reset_style,																	
									notional_exchg_style 					notional_exchange,
									logical option(nullable)  				average_notional,
									logical option(nullable)  				compound_to_mat,									
									number option(nullable) 				sub_factor = null<number>,
									number option(nullable)			 		multi_factor = null<number>,									
									number option(nullable) 				power_factor = null<number> )
	option (category: 'Instrument/Interest Rate Swap (standalone)/obsolete')
{
	integer rd = null(reset_days) ? 2 : integer(reset_days);
	
	
	if(null(idx_day_count_method))
		idx_day_count_method = day_count_method;

	if(null(idx_calendar))
		idx_calendar = calendar;
	
	if(null(idx_bus_day))
		idx_bus_day = bus_day;
	
	if(null(idx_eom))
		idx_eom = eom;

	integer spot_days = 2;
	
	ir_index idx = ir_index_ibor("IBOR",null<string>,rd,rd,currency,idx_calendar,
								 "noname",idx_day_count_method,idx_bus_day,idx_eom,spot_days);
	
	return ql_swap_float_def(name,currency,settle_code,cpn_freq,day_count_method,roll_method,bus_day,	
							calendar,eom,reset_freq, idx,index_tenor,idx_rate_type, idx_cpn_freq, quote_style,
							pv_round_code,fwd_rate_round_code,fwd_rate_style,fwd_stub_rate_style,
							start_stub_sprd_decomp,end_stub_sprd_decomp,interest_rule, 								
							fixing_stub_style,pmt_delay,mat_pmt_delay,pmt_delay_prin,mat_pmt_delay_prin,comp_avg,spread_comp_method,
							avg_method,reset_style,notional_exchange,average_notional,compound_to_mat,
							sub_factor ,multi_factor ,power_factor);
}
/*-----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
ql_swap_ois_def ql_swap_ois_def(	string				name,	
									string 				currency,
									date_code 			settle_code,
									coupon_freq 		cpn_freq,
									day_count_method 	day_count_method,									
									bd_convention 		bus_day,	
									calendar 			calendar,							    
									logical 			eom,									
									ir_index 			idx,																		
									round_code option(nullable) 			comp_factor_round_code,
									round_code option(nullable) 			imp_rate_pcnt_round_code,														
									interest_rule option(nullable) 			interest_rule, 																
									number option(nullable)					pmt_delay,															
									rfr_arrears_type option(nullable)		arr_type,
									number option(nullable)					arr_days,	
									flt_comp_avg_type option(nullable)		comp_avg,									
									flt_sprd_comp_method option(nullable) 	spread_comp_method,
									flt_avg_method option(nullable) 		avg_method,									
									notional_exchg_style 					notional_exchange)
	option (category: 'Instrument/Interest Rate Swap (standalone)') 
{
	logical average_notional = null<logical>;
	number sub_factor 		= null<number>;
	number multi_factor 	= null<number>;
	number power_factor 	= null<number>;	
	logical endog_df 		= true;
	
	return ql_swap_ois_def(name,currency,settle_code,cpn_freq,day_count_method,flt_roll_method.FLR_STRAIGHT,bus_day,	
							calendar,eom,idx, null<quote_style>,
							null<round_code>,comp_factor_round_code,imp_rate_pcnt_round_code,
							interest_rule, 	pmt_delay,pmt_delay,pmt_delay,pmt_delay,arr_type,arr_days,comp_avg,spread_comp_method,
							avg_method,notional_exchange,average_notional,sub_factor,multi_factor,power_factor,endog_df );
}
/*-----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
ql_swap_ois_def ql_swap_ois_def(	string				name,	
									string 				currency,
									date_code 			settle_code,
									coupon_freq 		cpn_freq,
									day_count_method 	day_count_method,									
									bd_convention 		bus_day,	
									calendar 			calendar,							    
									logical 			eom,																		
									round_code option(nullable) 			comp_factor_round_code,
									round_code option(nullable) 			imp_rate_pcnt_round_code,														
									interest_rule option(nullable) 			interest_rule, 																
									number option(nullable)					pmt_delay,								
									flt_comp_avg_type option(nullable)		comp_avg,									
									flt_sprd_comp_method option(nullable) 	spread_comp_method,
									flt_avg_method option(nullable) 		avg_method,																								
									notional_exchg_style 					notional_exchange,									
									logical option(nullable) 				is_tn,
									number option(nullable) 				publication_lag )
	option (category: 'Instrument/Interest Rate Swap (standalone)/obsolete')
{
	integer  fix_days, val_days;
    if(null(publication_lag))
		publication_lag = 0;
    if(is_tn) {
		val_days = 1;
		fix_days = publication_lag > 0 ? 0 : 1;//we only allow 1 lag day
    }
    else{
		val_days = 0;
		fix_days = publication_lag > 0 ? -1 : 0;//we only allow 1 lag day
    }

	integer spot_days = 2;
	
	ir_index idx 				= ir_index_ibor("IBOR","1D",val_days,fix_days,currency,calendar,"noname",day_count_method,BD_FOLLOWING,false,spot_days);
	rfr_arrears_type arr_type 	= rfr_arrears_type.PLAIN;
	number arr_days				= 0;

	/*logical average_notional = null<logical>;
	number sub_factor 		= null<number>;
	number multi_factor 	= null<number>;
	number power_factor 	= null<number>;	
	logical endog_df 		= true;*/
	
	return ql_swap_ois_def(name,currency,settle_code,cpn_freq,day_count_method,bus_day,	
							calendar,eom,idx,  comp_factor_round_code,imp_rate_pcnt_round_code,
							interest_rule, 	pmt_delay,arr_type,arr_days,comp_avg,spread_comp_method,
							avg_method,notional_exchange );
}

/*-----------------------------------------------------------------------
  ----------------------------------------------------------------------*/
ql_swap_ois_def ql_swap_ois_def(	string				name,	
									string 				currency,
									date_code 			settle_code,
									coupon_freq 		cpn_freq,
									day_count_method 	day_count_method,
									flt_roll_method		roll_method,
									bd_convention 		bus_day,	
									calendar 			calendar,							    
									logical 			eom,									
									day_count_method option(nullable) 		idx_day_count_method,									
									calendar  	option(nullable)			idx_calendar,																
									quote_style option(nullable) 			quote_style,
									round_code option(nullable) 			pv_round_code,
									round_code option(nullable) 			comp_factor_round_code,
									round_code option(nullable) 			imp_rate_pcnt_round_code,														
									interest_rule option(nullable) 			interest_rule, 																
									number option(nullable)					pmt_delay,
									number option(nullable)					mat_pmt_delay,
									flt_comp_avg_type option(nullable)		comp_avg,									
									flt_sprd_comp_method option(nullable) 	spread_comp_method,
									flt_avg_method option(nullable) 		avg_method,
									flt_reset_style option(nullable) 		reset_style,//obsolete and not used																
									notional_exchg_style 					notional_exchange,
									logical option(nullable)  				average_notional,
									logical option(nullable) 				is_tn,
									number option(nullable) 				publication_lag,
									number option(nullable) 				sub_factor = null<number>,
									number option(nullable)			 		multi_factor = null<number>,									
									number option(nullable) 				power_factor = null<number>,
									logical option(nullable) 				endog_df  = true)
	option (category: 'Instrument/Interest Rate Swap (standalone)/obsolete')
{
	integer  fix_days, val_days;
    if(null(publication_lag))
		publication_lag = 0;
    if(is_tn) {
		val_days = 1;
		fix_days = publication_lag > 0 ? 0 : 1;//we only allow 1 lag day
    }
    else{
		val_days = 0;
		fix_days = publication_lag > 0 ? -1 : 0;//we only allow 1 lag day
    }

	integer spot_days = 2;
		
	ir_index idx 				= ir_index_ibor("IBOR","1D",val_days,fix_days,currency,(null(idx_calendar)?calendar:idx_calendar),
											"noname",(null(idx_day_count_method) ? day_count_method : idx_day_count_method),BD_FOLLOWING,false,spot_days);	
	rfr_arrears_type arr_type 	= rfr_arrears_type.PLAIN;
	number arr_days				= 0;

	
	return ql_swap_ois_def(name,currency,settle_code,cpn_freq,day_count_method,roll_method,bus_day,	
							calendar,eom,idx, quote_style,
							pv_round_code,comp_factor_round_code,imp_rate_pcnt_round_code,
							interest_rule, 	pmt_delay,mat_pmt_delay,pmt_delay,mat_pmt_delay,arr_type,arr_days,comp_avg,spread_comp_method,
							avg_method,notional_exchange,average_notional,
							sub_factor ,multi_factor ,power_factor);
}


ql_fixed_income_swap ql_fixed_income_swap(ql_swap_fix_def fix_def,
										  ql_swap_float_def flt_def,
											string id,
											date trade,
											date option(nullable)  settle,
											date option(nullable)  start,
											date option(nullable)  maturity,
											tenor_code option(nullable) maturity_code,
											logical pay_fixed,	
											number fix_notional,
											date option(nullable)  fix_first_cpn_date,
											date option(nullable)  fix_last_reg_date,
											number fix_coupon_rate,		
											disc_func option(nullable) fix_df,	
											number option(nullable) fix_cpn_roll_day,	
											number option(nullable) fix_fx_rate,
											number flt_notional,
											date option(nullable) 	  flt_first_cpn_date,	
											date option(nullable) 	    flt_last_reg_date,
											number option(nullable) flt_spread,	
											disc_func option(nullable) flt_df,
											tenor_surface option(nullable) flt_tenor_surface,		
											number option(nullable) flt_cpn_roll_day,
											number option(nullable) flt_fx_rate,	
											vector(date) option(nullable) flt_fixing_dates,
											vector(number) option(nullable) flt_fixings,
											number option(nullable) flt_fixing_proxy,
											logical option(nullable) flt_fixing_as_fwd)
	option (category: 'Instrument/Interest Rate Swap (standalone)') 
{
	date fix_effective_date = start;
	date flt_effective_date = start;
	return ql_fixed_income_swap(	fix_def, flt_def, id, trade, settle, start, maturity, maturity_code, pay_fixed, fix_notional,
									fix_effective_date,fix_first_cpn_date, fix_last_reg_date, fix_coupon_rate, null<number>,fix_df, 
									null<number>, null<number>, fix_cpn_roll_day, fix_fx_rate, sink_fund_style.SF_NONE,
									null<vector(date)>, null<vector(number)>, null<vector(date)>, null<vector(number)>, flt_notional,
									flt_effective_date,flt_first_cpn_date, flt_last_reg_date, flt_spread, null<number>, flt_df, flt_tenor_surface, 
									null<number>, null<number>, 
									flt_cpn_roll_day, flt_fx_rate, sink_fund_style.SF_NONE, null<vector(date)>, null<vector(number)>,
									null<vector(date)>, null<vector(number)>, flt_fixing_dates, flt_fixings, 
									flt_fixing_proxy,null<number>,null<number>,flt_fixing_as_fwd);
}

ql_fixed_income_swap ql_fixed_income_swap(ql_swap_fix_def fix_def,
										  ql_swap_float_def flt_def,
											string id,
											date trade,
											date option(nullable)  settle,
											date option(nullable)  start,
											date option(nullable)  maturity,
											tenor_code option(nullable) maturity_code,
											logical pay_fixed,	
											number fix_notional,
											date option(nullable)  fix_first_cpn_date,
											date option(nullable)  fix_last_reg_date,
											number fix_coupon_rate,		
											disc_func option(nullable) fix_df,	
											number option(nullable) fix_cpn_roll_day,	
											number option(nullable) fix_fx_rate,
											sink_fund_style option(nullable) fix_sink_fund_style,	
											vector(date) option(nullable) fix_sink_fund_dates,
											vector(number) option(nullable) fix_sink_fund,
											vector(date) option(nullable) fix_fee_dates,
											vector(number) option(nullable) fix_fees,
											number flt_notional,
											date option(nullable) 	  flt_first_cpn_date,	
											date option(nullable) 	    flt_last_reg_date,
											number option(nullable) flt_spread,	
											disc_func option(nullable) flt_df,
											tenor_surface option(nullable) flt_tenor_surface,		
											number option(nullable) flt_cpn_roll_day,
											number option(nullable) flt_fx_rate,

											sink_fund_style option(nullable) flt_sink_fund_style,	
											vector(date) option(nullable) flt_sink_fund_dates,
											vector(number) option(nullable) flt_sink_fund,
											vector(date) option(nullable) flt_fee_dates,
											vector(number) option(nullable) flt_fees,
										  
											vector(date) option(nullable) flt_fixing_dates,
											vector(number) option(nullable) flt_fixings,
											number option(nullable) flt_fixing_proxy,
											logical option(nullable) flt_fixing_as_fwd)
	option (category: 'Instrument/Interest Rate Swap (standalone)') 
{
	date fix_effective_date = start;
	date flt_effective_date = start;
	
	return ql_fixed_income_swap(	fix_def, flt_def, id, trade, settle, start, maturity, maturity_code, pay_fixed, fix_notional, 
									fix_effective_date,fix_first_cpn_date,fix_last_reg_date, fix_coupon_rate, null<number>,fix_df, 
									null<number>, null<number>, fix_cpn_roll_day, fix_fx_rate, fix_sink_fund_style,
									fix_sink_fund_dates, fix_sink_fund, fix_fee_dates, fix_fees, flt_notional,
									flt_effective_date,flt_first_cpn_date, flt_last_reg_date, flt_spread, null<number>, flt_df, flt_tenor_surface, 
									null<number>, null<number>, 
									flt_cpn_roll_day, flt_fx_rate, flt_sink_fund_style, flt_sink_fund_dates, flt_sink_fund,
									flt_fee_dates, flt_fees, flt_fixing_dates, flt_fixings, 
									flt_fixing_proxy,null<number>,null<number>,flt_fixing_as_fwd);
}

ql_fixed_income_swap ql_fixed_income_swap(ql_swap_fix_def fix_def,
										  ql_swap_float_def flt_def,
											string id,
											date trade,
											date option(nullable)  settle,
											date option(nullable)  start,
											date option(nullable)  maturity,
											tenor_code option(nullable) maturity_code,
											logical pay_fixed,	
											number fix_notional,
											date option(nullable)  fix_first_cpn_date,
											date option(nullable)  fix_last_reg_date,
											number fix_coupon_rate,
											number option(nullable) fix_compounding_rate,
											disc_func option(nullable) fix_df,
											number option(nullable) fix_start_stub_rate,
											number option(nullable) fix_end_stub_rate,
											number option(nullable) fix_cpn_roll_day,	
											number option(nullable) fix_fx_rate,
											sink_fund_style option(nullable) fix_sink_fund_style,	
											vector(date) option(nullable) fix_sink_fund_dates,
											vector(number) option(nullable) fix_sink_fund,
											vector(date) option(nullable) fix_fee_dates,
											vector(number) option(nullable) fix_fees,
											number flt_notional,
											date option(nullable) 	  flt_first_cpn_date,	
											date option(nullable) 	    flt_last_reg_date,
											number option(nullable) flt_spread,
											number option(nullable) flt_comp_spread,
											disc_func option(nullable) flt_df,
											tenor_surface option(nullable) flt_tenor_surface,
											number option(nullable) flt_start_stub_spread,
											number option(nullable) flt_end_stub_spread,
											number option(nullable) flt_cpn_roll_day,
											number option(nullable) flt_fx_rate,

											sink_fund_style option(nullable) flt_sink_fund_style,	
											vector(date) option(nullable) flt_sink_fund_dates,
											vector(number) option(nullable) flt_sink_fund,
											vector(date) option(nullable) flt_fee_dates,
											vector(number) option(nullable) flt_fees,
										  
											vector(date) option(nullable) flt_fixing_dates,
											vector(number) option(nullable) flt_fixings,
											number option(nullable) flt_fixing_proxy,
											number option(nullable) flt_fixing_start_stub,
											number option(nullable) flt_fixing_end_stub,
											logical option(nullable) flt_fixing_as_fwd,											
											number option(nullable) p ,//obsolete and not used
											quote_style option(nullable) qs = null<quote_style>)//obsolete and not used)
	option (category: 'Instrument/Interest Rate Swap (standalone)/obsolete')
{
	date fix_effective_date = start;
	date flt_effective_date = start;
	return ql_fixed_income_swap(	fix_def, flt_def, id, trade, settle, start, maturity, maturity_code, pay_fixed, fix_notional, 
									fix_effective_date,fix_first_cpn_date,fix_last_reg_date, fix_coupon_rate, fix_compounding_rate,fix_df, 
									fix_start_stub_rate, fix_end_stub_rate, fix_cpn_roll_day, fix_fx_rate, fix_sink_fund_style,
									fix_sink_fund_dates, fix_sink_fund, fix_fee_dates, fix_fees, flt_notional,
									flt_effective_date,flt_first_cpn_date, flt_last_reg_date, flt_spread, flt_comp_spread, flt_df, flt_tenor_surface, 
									flt_start_stub_spread, flt_end_stub_spread, 
									flt_cpn_roll_day, flt_fx_rate, flt_sink_fund_style, flt_sink_fund_dates, flt_sink_fund,
									flt_fee_dates, flt_fees, flt_fixing_dates, flt_fixings, 
									flt_fixing_proxy,flt_fixing_start_stub,flt_fixing_end_stub,flt_fixing_as_fwd);
}


ql_fixed_income_swap ql_fixed_income_swap(ql_swap_fix_def fix1_def,
										  ql_swap_fix_def fix2_def,
											string id,
											date trade,
											date option(nullable)  settle,
											date option(nullable)  start,
											date option(nullable)  maturity,
											tenor_code option(nullable) maturity_code,
											logical pay_fixleg1,	
											number fix1_notional,
											date option(nullable)  fix1_first_cpn_date,
											date option(nullable)  fix1_last_reg_date,
											number fix1_coupon_rate,		
											disc_func option(nullable) fix1_df,	
											number option(nullable) fix1_cpn_roll_day,	
											number option(nullable) fix1_fx_rate,
											number fix2_notional,
											date option(nullable)  fix2_first_cpn_date,
											date option(nullable)  fix2_last_reg_date,
											number fix2_coupon_rate,		
											disc_func option(nullable) fix2_df,	
											number option(nullable) fix2_cpn_roll_day,	
											number option(nullable) fix2_fx_rate)
	option (category: 'Instrument/Interest Rate Swap (standalone)') 
{
	date fix1_effective_date = start;
	date fix2_effective_date = start;
	return ql_fixed_income_swap(	fix1_def, fix2_def, id, trade, settle, start, maturity, maturity_code, pay_fixleg1,
									fix1_notional,
									fix1_effective_date,fix1_first_cpn_date, fix1_last_reg_date, fix1_coupon_rate, null<number>,fix1_df, 
									null<number>, null<number>, fix1_cpn_roll_day, fix1_fx_rate, sink_fund_style.SF_NONE,
									null<vector(date)>, null<vector(number)>, null<vector(date)>, null<vector(number)>, fix2_notional,
									fix2_effective_date,fix2_first_cpn_date, fix2_last_reg_date, fix2_coupon_rate, null<number>,fix2_df, 
									null<number>, null<number>, fix2_cpn_roll_day, fix2_fx_rate, sink_fund_style.SF_NONE,
									null<vector(date)>, null<vector(number)>, null<vector(date)>, null<vector(number)>);
}


ql_fixed_income_swap ql_fixed_income_swap(	ql_swap_float_def flt1_def,
											ql_swap_float_def flt2_def,
											string id,
											date trade,
											date option(nullable)  settle,
											date option(nullable)  start,
											date option(nullable)  maturity,
											tenor_code option(nullable) maturity_code,
											logical pay_floatleg1,																						 
											number flt1_notional,
											date option(nullable) 	  flt1_first_cpn_date,	
											date option(nullable) 	    flt1_last_reg_date,
											number option(nullable) flt1_spread,	
											disc_func option(nullable) flt1_df,
											tenor_surface option(nullable) flt1_tenor_surface,		
											number option(nullable) flt1_cpn_roll_day,
											number option(nullable) flt1_fx_rate,	
											vector(date) option(nullable) flt1_fixing_dates,
											vector(number) option(nullable) flt1_fixings,
											number option(nullable) flt1_fixing_proxy,
											logical option(nullable) flt1_fixing_as_fwd,
											number flt2_notional,
											date option(nullable) 	  flt2_first_cpn_date,	
											date option(nullable) 	    flt2_last_reg_date,
											number option(nullable) flt2_spread,	
											disc_func option(nullable) flt2_df,
											tenor_surface option(nullable) flt2_tenor_surface,		
											number option(nullable) flt2_cpn_roll_day,
											number option(nullable) flt2_fx_rate,	
											vector(date) option(nullable) flt2_fixing_dates,
											vector(number) option(nullable) flt2_fixings,
											number option(nullable) flt2_fixing_proxy,
											logical option(nullable) flt2_fixing_as_fwd)
	option (category: 'Instrument/Interest Rate Swap (standalone)') 
{
	date flt1_effective_date = start;
	date flt2_effective_date = start;
	return ql_fixed_income_swap(	flt1_def, flt2_def, id, trade, settle, start, maturity, maturity_code, pay_floatleg1, flt1_notional,
									flt1_effective_date,flt1_first_cpn_date, flt1_last_reg_date, flt1_spread, null<number>, flt1_df, flt1_tenor_surface, 
									null<number>, null<number>, 
									flt1_cpn_roll_day, flt1_fx_rate, sink_fund_style.SF_NONE, null<vector(date)>, null<vector(number)>,
									null<vector(date)>, null<vector(number)>, flt1_fixing_dates, flt1_fixings, 
									flt1_fixing_proxy,null<number>,null<number>,flt1_fixing_as_fwd,
									flt2_notional,
									flt2_effective_date,flt2_first_cpn_date, flt2_last_reg_date, flt2_spread, null<number>, flt2_df, flt2_tenor_surface, 
									null<number>, null<number>, 
									flt2_cpn_roll_day, flt2_fx_rate, sink_fund_style.SF_NONE, null<vector(date)>, null<vector(number)>,
									null<vector(date)>, null<vector(number)>, flt2_fixing_dates, flt2_fixings, 
									flt2_fixing_proxy,null<number>,null<number>,flt2_fixing_as_fwd);
}


ql_fixed_income_swap ql_fixed_income_swap(ql_swap_float_def flt1_def,
										  ql_swap_float_def flt2_def,
											string id,
											date trade,
											date option(nullable)  settle,
											date option(nullable)  start,
											date option(nullable)  maturity,
											tenor_code option(nullable) maturity_code,
											logical pay_floatleg1,	
											number flt1_notional,
											date option(nullable) 	  flt1_first_cpn_date,	
											date option(nullable) 	    flt1_last_reg_date,
											number option(nullable) flt1_spread,
											number option(nullable) flt1_comp_spread,
											disc_func option(nullable) flt1_df,
											tenor_surface option(nullable) flt1_tenor_surface,
											number option(nullable) flt1_start_stub_spread,
											number option(nullable) flt1_end_stub_spread,
											number option(nullable) flt1_cpn_roll_day,
											number option(nullable) flt1_fx_rate,

											sink_fund_style option(nullable) flt1_sink_fund_style,	
											vector(date) option(nullable) flt1_sink_fund_dates,
											vector(number) option(nullable) flt1_sink_fund,
											vector(date) option(nullable) flt1_fee_dates,
											vector(number) option(nullable) flt1_fees,
										  
											vector(date) option(nullable) flt1_fixing_dates,
											vector(number) option(nullable) flt1_fixings,
											number option(nullable) flt1_fixing_proxy,
											number option(nullable) flt1_fixing_start_stub,
											number option(nullable) flt1_fixing_end_stub,
											logical option(nullable) flt1_fixing_as_fwd,
											
											number flt2_notional,
											date option(nullable) 	  flt2_first_cpn_date,	
											date option(nullable) 	    flt2_last_reg_date,
											number option(nullable) flt2_spread,
											number option(nullable) flt2_comp_spread,
											disc_func option(nullable) flt2_df,
											tenor_surface option(nullable) flt2_tenor_surface,
											number option(nullable) flt2_start_stub_spread,
											number option(nullable) flt2_end_stub_spread,
											number option(nullable) flt2_cpn_roll_day,
											number option(nullable) flt2_fx_rate,

											sink_fund_style option(nullable) flt2_sink_fund_style,	
											vector(date) option(nullable) flt2_sink_fund_dates,
											vector(number) option(nullable) flt2_sink_fund,
											vector(date) option(nullable) flt2_fee_dates,
											vector(number) option(nullable) flt2_fees,
										  
											vector(date) option(nullable) flt2_fixing_dates,
											vector(number) option(nullable) flt2_fixings,
											number option(nullable) flt2_fixing_proxy,
											number option(nullable) flt2_fixing_start_stub,
											number option(nullable) flt2_fixing_end_stub,
											logical option(nullable) flt2_fixing_as_fwd,
											
											number option(nullable) p ,//obsolete and not used
											quote_style option(nullable) qs = null<quote_style> )//obsolete and not used)
	option (category: 'Instrument/Interest Rate Swap (standalone)/obsolete')
{
	date flt1_effective_date = start;
	date flt2_effective_date = start;
	return ql_fixed_income_swap(	flt1_def, flt2_def, id, trade, settle, start, maturity, maturity_code, pay_floatleg1,
									flt1_notional,
									flt1_effective_date,flt1_first_cpn_date, flt1_last_reg_date, flt1_spread, flt1_comp_spread, flt1_df, flt1_tenor_surface, 
									flt1_start_stub_spread, flt1_end_stub_spread, 
									flt1_cpn_roll_day, flt1_fx_rate, flt1_sink_fund_style, flt1_sink_fund_dates, flt1_sink_fund,
									flt1_fee_dates, flt1_fees, flt1_fixing_dates, flt1_fixings, 
									flt1_fixing_proxy,flt1_fixing_start_stub,flt1_fixing_end_stub,flt1_fixing_as_fwd,
									flt2_notional,
									flt2_effective_date,flt2_first_cpn_date, flt2_last_reg_date, flt2_spread, flt2_comp_spread, flt2_df, flt2_tenor_surface, 
									flt2_start_stub_spread, flt2_end_stub_spread, 
									flt2_cpn_roll_day, flt2_fx_rate, flt2_sink_fund_style, flt2_sink_fund_dates, flt2_sink_fund,
									flt2_fee_dates, flt2_fees, flt2_fixing_dates, flt2_fixings, 
									flt2_fixing_proxy,flt2_fixing_start_stub,flt2_fixing_end_stub,flt2_fixing_as_fwd);
}

/*ql_fixed_income_swap ql_fixed_income_swap(ql_swap_fix_def fix_def,
										  ql_swap_ois_def ois_def,
											string id,
											date trade,
											date option(nullable)  settle,
											date option(nullable)  start,
											date option(nullable)  maturity,
											tenor_code option(nullable) maturity_code,
											logical pay_fixed,	
											number fix_notional,
											date option(nullable)  fix_first_cpn_date,
											date option(nullable)  fix_last_reg_date,
											number fix_coupon_rate,
											number option(nullable) fix_compounding_rate,
											disc_func option(nullable) fix_df,
											number option(nullable) fix_start_stub_rate,
											number option(nullable) fix_end_stub_rate,
	
											number option(nullable) fix_cpn_roll_day,	
											number option(nullable) fix_fx_rate,
											sink_fund_style option(nullable) fix_sink_fund_style,
											vector(date) option(nullable) fix_sink_fund_dates,
											vector(number) option(nullable) fix_sink_fund,
											vector(date) option(nullable) fix_fee_dates,
											vector(number) option(nullable) fix_fees,
											number ois_notional,
											date option(nullable) 	  ois_first_cpn_date,	
											date option(nullable) 	    ois_last_reg_date,
											number option(nullable) ois_spread,
											number option(nullable) ois_comp_spread,//obsolete and not used
											disc_func option(nullable) ois_df,
											//fwd_func option(nullable) ois_fwd,
											tenor_surface option(nullable) ois_tenor_surface,
											number option(nullable) ois_cpn_roll_day,
											number option(nullable) ois_fx_rate,
										  
											sink_fund_style option(nullable) ois_sink_fund_style,
											vector(date) option(nullable) ois_sink_fund_dates,
											vector(number) option(nullable) ois_sink_fund,
											vector(date) option(nullable) ois_fee_dates,
											vector(number) option(nullable) ois_fees,
										  
											vector(date) option(nullable) ois_fixing_dates,
											vector(number) option(nullable) ois_fixings,
											number option(nullable) ois_fixing_proxy,
											logical option(nullable) ois_fixing_as_fwd,
											logical option(nullable) use_ois_depo_approx,
											number option(nullable) p = null,//obsolete and not used
											quote_style option(nullable) qs = null)//obsolete and not used
											 
	option (category: 'Instrument/Interest Rate Swap (standalone)/obsolete')
{
	date fix_effective_date = start;
	date ois_effective_date = start;
	return ql_fixed_income_swap(	fix_def, ois_def, id, trade, settle, start, maturity, maturity_code, pay_fixed, fix_notional,
									fix_effective_date,fix_first_cpn_date, fix_last_reg_date, fix_coupon_rate, fix_compounding_rate,fix_df, 
									fix_start_stub_rate, fix_end_stub_rate, fix_cpn_roll_day, fix_fx_rate,fix_sink_fund_style,
									fix_sink_fund_dates, fix_sink_fund, fix_fee_dates, fix_fees,
									
									ois_notional,
									ois_effective_date,ois_first_cpn_date, ois_last_reg_date, ois_spread,  ois_df, ois_tenor_surface, 
									ois_cpn_roll_day, ois_fx_rate, ois_sink_fund_style, ois_sink_fund_dates, ois_sink_fund,
									ois_fee_dates, ois_fees, ois_fixing_dates, ois_fixings, 
									ois_fixing_proxy,ois_fixing_as_fwd,use_ois_depo_approx);
}
*/
/*ql_fixed_income_swap ql_fixed_income_swap(ql_swap_fix_def fix_def,
										  ql_swap_ois_def ois_def,
											string id,
											date trade,
											date option(nullable)  settle,
											date option(nullable)  start,
											date option(nullable)  maturity,
											tenor_code option(nullable) maturity_code,
											logical pay_fixed,	
											number fix_notional,
											date option(nullable)  fix_first_cpn_date,
											date option(nullable)  fix_last_reg_date,
											number fix_coupon_rate,		
											disc_func option(nullable) fix_df,	
											number option(nullable) fix_cpn_roll_day,	
											number option(nullable) fix_fx_rate,
											number ois_notional,
											date option(nullable) 	  ois_first_cpn_date,	
											date option(nullable) 	    ois_last_reg_date,
											number option(nullable) ois_spread,
											number option(nullable) ois_comp_spread,//obsolete and not used
											disc_func option(nullable) ois_df,
											fwd_func option(nullable) ois_fwd,		
											number option(nullable) ois_cpn_roll_day,
											number option(nullable) ois_fx_rate,	
											vector(date) option(nullable) ois_fixing_dates,
											vector(number) option(nullable) ois_fixings,
											number option(nullable) ois_fixing_proxy,
											logical option(nullable) ois_fixing_as_fwd,
											logical option(nullable) use_ois_depo_approx )
	option (category: "Instrument/Interest Rate Swap (standalone)/obsolete")
{
	date fix_effective_date = start;
	date ois_effective_date = start;
	return ql_fixed_income_swap(	fix_def, ois_def, id, trade, settle, start, maturity, maturity_code, pay_fixed, fix_notional,
									fix_effective_date,fix_first_cpn_date, fix_last_reg_date, fix_coupon_rate, null<number>,fix_df, 
									null<number>, null<number>, fix_cpn_roll_day, fix_fx_rate, sink_fund_style.SF_NONE,
									null<vector(date)>, null<vector(number)>, null<vector(date)>, null<vector(number)>,
									ois_notional,
									ois_effective_date,ois_first_cpn_date, ois_last_reg_date, ois_spread,  ois_df, ois_fwd, 
									ois_cpn_roll_day, ois_fx_rate, sink_fund_style.SF_NONE, null<vector(date)>, null<vector(number)>,
									null<vector(date)>, null<vector(number)>, ois_fixing_dates, ois_fixings, 
									ois_fixing_proxy,ois_fixing_as_fwd,use_ois_depo_approx);
}*/

ql_fixed_income_swap ql_fixed_income_swap(	ql_swap_ois_def ois1_def,
											ql_swap_ois_def ois2_def,
											string id,
											date trade,
											date option(nullable)  settle,
											date option(nullable)  start,
											date option(nullable)  maturity,
											tenor_code option(nullable) maturity_code,
											logical pay_oisleg1,																						 
											number ois1_notional,
											date option(nullable)  ois1_effective_date,
											date option(nullable) 	  ois1_first_cpn_date,	
											date option(nullable) 	    ois1_last_reg_date,
											number option(nullable) ois1_spread,	
											disc_func option(nullable) ois1_df,
											//fwd_func option(nullable) ois1_fwd,
											tenor_surface option(nullable) ois1_tenor_surface,
											number option(nullable) ois1_cpn_roll_day,
											number option(nullable) ois1_fx_rate,	
											vector(date) option(nullable) ois1_fixing_dates,
											vector(number) option(nullable) ois1_fixings,
											number option(nullable) ois1_fixing_proxy,
											logical option(nullable) ois1_fixing_as_fwd,
											number ois2_notional,
											date option(nullable)  ois2_effective_date,
											date option(nullable) 	  ois2_first_cpn_date,	
											date option(nullable) 	    ois2_last_reg_date,
											number option(nullable) ois2_spread,	
											disc_func option(nullable) ois2_df,
											//fwd_func option(nullable) ois2_fwd,
											tenor_surface option(nullable) ois2_tenor_surface,
											number option(nullable) ois2_cpn_roll_day,
											number option(nullable) ois2_fx_rate,	
											vector(date) option(nullable) ois2_fixing_dates,
											vector(number) option(nullable) ois2_fixings,
											number option(nullable) ois2_fixing_proxy,
											logical option(nullable) ois2_fixing_as_fwd,
											logical option(nullable) use_ois_depo_approx )
	option (category: 'Instrument/Interest Rate Swap (standalone)') 
{
	
	return ql_fixed_income_swap(	ois1_def, ois2_def, id, trade, settle, start, maturity, maturity_code, pay_oisleg1,

									ois1_notional,
									ois1_effective_date,ois1_first_cpn_date, ois1_last_reg_date, ois1_spread, ois1_df, ois1_tenor_surface, 									
									ois1_cpn_roll_day, ois1_fx_rate, sink_fund_style.SF_NONE, null<vector(date)>, null<vector(number)>,
									null<vector(date)>, null<vector(number)>, ois1_fixing_dates, ois1_fixings, 
									ois1_fixing_proxy, ois1_fixing_as_fwd,
									
									ois2_notional,
									ois2_effective_date,ois2_first_cpn_date, ois2_last_reg_date, ois2_spread,ois2_df, ois2_tenor_surface, 
									 
									ois2_cpn_roll_day, ois2_fx_rate, sink_fund_style.SF_NONE, null<vector(date)>, null<vector(number)>,
									null<vector(date)>, null<vector(number)>, ois2_fixing_dates, ois2_fixings, 
									ois2_fixing_proxy, ois2_fixing_as_fwd,use_ois_depo_approx);
}

ql_fixed_income_swap ql_fixed_income_swap(	ql_swap_float_def flt_def,
											ql_swap_ois_def ois_def,
											string id,
											date trade,
											date option(nullable)  settle,
											date option(nullable)  start,
											date option(nullable)  maturity,
											tenor_code option(nullable) maturity_code,
											logical pay_floatleg1,																						 
											number flt_notional,
											date option(nullable)  flt_effective_date,
											date option(nullable) 	  flt_first_cpn_date,	
											date option(nullable) 	    flt_last_reg_date,
											number option(nullable) flt_spread,	
											disc_func option(nullable) flt_df,
											tenor_surface option(nullable) flt_tenor_surface,		
											number option(nullable) flt_cpn_roll_day,
											number option(nullable) flt_fx_rate,	
											vector(date) option(nullable) flt_fixing_dates,
											vector(number) option(nullable) flt_fixings,
											number option(nullable) flt_fixing_proxy,
											logical option(nullable) flt_fixing_as_fwd,
											number ois_notional,
											date option(nullable)  ois_effective_date,
											date option(nullable) 	  ois_first_cpn_date,	
											date option(nullable) 	    ois_last_reg_date,
											number option(nullable) ois_spread,	
											disc_func option(nullable) ois_df,
											//fwd_func option(nullable) ois_fwd,
											tenor_surface option(nullable) ois_tenor_surface,
											number option(nullable) ois_cpn_roll_day,
											number option(nullable) ois_fx_rate,	
											vector(date) option(nullable) ois_fixing_dates,
											vector(number) option(nullable) ois_fixings,
											number option(nullable) ois_fixing_proxy,
											logical option(nullable) ois_fixing_as_fwd,
											logical option(nullable) use_ois_depo_approx )
	option (category: 'Instrument/Interest Rate Swap (standalone)') 
{
	return ql_fixed_income_swap(	flt_def, ois_def, id, trade, settle, start, maturity, maturity_code, pay_floatleg1, flt_notional,
									flt_effective_date,flt_first_cpn_date, flt_last_reg_date, flt_spread, null<number>, flt_df, flt_tenor_surface, 
									null<number>, null<number>, 
									flt_cpn_roll_day, flt_fx_rate, sink_fund_style.SF_NONE, null<vector(date)>, null<vector(number)>,
									null<vector(date)>, null<vector(number)>, flt_fixing_dates, flt_fixings, 
									flt_fixing_proxy,null<number>,null<number>,flt_fixing_as_fwd,
									ois_notional,
									ois_effective_date,ois_first_cpn_date, ois_last_reg_date, ois_spread, ois_df, ois_tenor_surface, 									
									ois_cpn_roll_day, ois_fx_rate, sink_fund_style.SF_NONE, null<vector(date)>, null<vector(number)>,
									null<vector(date)>, null<vector(number)>, ois_fixing_dates, ois_fixings, 
									ois_fixing_proxy,ois_fixing_as_fwd,use_ois_depo_approx);
}


ql_fixed_income_swap ql_fixed_income_swap(	ql_swap_fix_zero_def zero_def,
											ql_swap_float_def flt_def,
											string id,
											date trade,
											date option(nullable)  settle,
											date option(nullable)  start,
											date option(nullable)  maturity,
											tenor_code option(nullable) maturity_code,
											logical pay_zero,	
											number zero_notional,											
											number zero_coupon_rate,		
											disc_func option(nullable) zero_df,												
											number option(nullable) zero_fx_rate,
											number flt_notional,
											date option(nullable) 	  flt_first_cpn_date,	
											date option(nullable) 	    flt_last_reg_date,
											number option(nullable) flt_spread,	
											disc_func option(nullable) flt_df,
											tenor_surface option(nullable) flt_tenor_surface,		
											number option(nullable) flt_cpn_roll_day,
											number option(nullable) flt_fx_rate,	
											vector(date) option(nullable) flt_fixing_dates,
											vector(number) option(nullable) flt_fixings,
											number option(nullable) flt_fixing_proxy,
											logical option(nullable) flt_fixing_as_fwd)
	option (category: 'Instrument/Interest Rate Swap (standalone)') 
{
	date flt_effective_date = start;
	return ql_fixed_income_swap(	zero_def, flt_def, id, trade, settle, start, maturity, maturity_code, pay_zero, zero_notional,
									zero_coupon_rate, zero_df,  zero_fx_rate, sink_fund_style.SF_NONE,
									null<vector(date)>, null<vector(number)>, null<vector(date)>, null<vector(number)>, flt_notional,
									flt_effective_date,flt_first_cpn_date, flt_last_reg_date, flt_spread, null<number>, flt_df, flt_tenor_surface, 
									null<number>, null<number>, 
									flt_cpn_roll_day, flt_fx_rate, sink_fund_style.SF_NONE, null<vector(date)>, null<vector(number)>,
									null<vector(date)>, null<vector(number)>, flt_fixing_dates, flt_fixings, 
									flt_fixing_proxy,null<number>,null<number>,flt_fixing_as_fwd);
}

ql_fixed_income_swap ql_fixed_income_swap(	ql_swap_fix_zero_def zero_def,
											ql_swap_ois_def ois_def,
											string id,
											date trade,
											date option(nullable)  settle,
											date option(nullable)  start,
											date option(nullable)  maturity,
											tenor_code option(nullable) maturity_code,
											logical pay_zero,	
											number zero_notional,											
											number zero_coupon_rate,		
											disc_func option(nullable) zero_df,												
											number option(nullable) zero_fx_rate,
											number ois_notional,
											date option(nullable)  ois_effective_date,
											date option(nullable) 	  ois_first_cpn_date,	
											date option(nullable) 	    ois_last_reg_date,
											number option(nullable) ois_spread,	
											disc_func option(nullable) ois_df,
											//fwd_func option(nullable) ois_fwd,
											tenor_surface option(nullable) ois_tenor_surface,
											number option(nullable) ois_cpn_roll_day,
											number option(nullable) ois_fx_rate,	
											vector(date) option(nullable) ois_fixing_dates,
											vector(number) option(nullable) ois_fixings,
											number option(nullable) ois_fixing_proxy,
											logical option(nullable) ois_fixing_as_fwd,
											logical option(nullable) use_ois_depo_approx )
	option (category: 'Instrument/Interest Rate Swap (standalone)') 
{
	return ql_fixed_income_swap(	zero_def, ois_def, id, trade, settle, start, maturity, maturity_code, pay_zero,zero_notional,
									zero_coupon_rate, zero_df,  zero_fx_rate, sink_fund_style.SF_NONE,
									null<vector(date)>, null<vector(number)>, null<vector(date)>, null<vector(number)>,
									ois_notional,
									ois_effective_date,ois_first_cpn_date, ois_last_reg_date, ois_spread, ois_df, ois_tenor_surface, 									
									ois_cpn_roll_day, ois_fx_rate, sink_fund_style.SF_NONE, null<vector(date)>, null<vector(number)>,
									null<vector(date)>, null<vector(number)>, ois_fixing_dates, ois_fixings, 
									ois_fixing_proxy,ois_fixing_as_fwd,use_ois_depo_approx);
}

ql_fixed_income_swap ql_fixed_income_swap(	ql_swap_leg swap_leg1,
											ql_swap_leg swap_leg2,
											string id,
											number option(nullable) p,//obsolete, not used
											quote_style option(nullable) qs = null<quote_style>,//obsolete, not used
											logical option(nullable) no_check = null<logical>)
	option (category: "Instrument/Interest Rate Swap (standalone)/obsolete")
{
	return ql_fixed_income_swap(swap_leg1,swap_leg2,id,no_check);
}


module CORE_INT_SWAPLIB
{
	/*-----------------------------------------------------------------------
	  swap_lib_fx_handler_ccy

		ex oisois nowa/sofr ccbs
		1) fx input:  fx_quote = 10, 	fx_quote_baseccy = "USD" fx_quote_priceccy = "NOK"

		pv_in_base_ccy = false  i.e. pv in NOK -->
		ois1_fx_mult = 1
		ois2_fx_mult = 10

		pv_in_base_ccy = true  i.e. pv in USD -->
		leg1_fx_mult = 0.1
		ois2_fx_mult = 1

		2) fx input reverse:  fx_quote = 0.1,	fx_quote_baseccy = "NOK",  fx_quote_priceccy = "USD"

		pv_in_base_ccy = false i.e. pv in USD -->
		ois1_fx_mult = 0.1
		ois2_fx_mult = 1

		pv_in_base_ccy = true i.e. pv in NOK -->
		leg1_fx_mult = 1
		ois2_fx_mult = 10
	  ----------------------------------------------------------------------*/
	void swap_lib_fx_handler_ccy(string 	leg1_curr,
								 string 	leg2_curr,
								 string 	base_ccy,
								 string 	price_ccy,
								 logical 	pv_in_base_ccy,
								 number 	fxs_quote_used,
								 out logical 	leg1_is_base_ccy,
								 out number 	leg1_fx_mult,
								 out number 	leg2_fx_mult)
	{
		if(equal_casei(leg1_curr,leg2_curr)) {
			leg1_is_base_ccy = null;
			leg1_fx_mult = leg2_fx_mult = 1;
		}
			
		leg1_is_base_ccy 			= equal_casei(leg1_curr,base_ccy);//ex. true (flip fx: false)
		logical leg2_is_base_ccy ;//	= equal_casei(leg2_curr,base_ccy);

		if(leg1_is_base_ccy) {
			if(!equal_casei(leg2_curr,price_ccy))
				throw(E_INVALID_ARG,"invalid currency");
			leg2_is_base_ccy = false;
		}
		else {
			if(!equal_casei(leg1_curr,price_ccy))
				throw(E_INVALID_ARG,"invalid currency");
			leg2_is_base_ccy = equal_casei(leg2_curr,base_ccy);
			if(!leg2_is_base_ccy)
				throw(E_INVALID_ARG,"invalid currency");
			//QL_REQUIRE(leg2_is_base_ccy , "invalid currency");
		}
		
		//QL_FAIL_COND(!leg1_is_base_ccy && !equal_casei(leg1_curr,price_ccy), "invalid fx_spot currencies", E_INIT);
		//QL_FAIL_COND(!leg2_is_base_ccy && !equal_casei(leg2_curr,price_ccy), "invalid fx_spot currencies", E_INIT);

		if(pv_in_base_ccy)//EUR (flip fx: USD)
			leg1_fx_mult = leg1_is_base_ccy ? 1: 1/fxs_quote_used;//ex. 1  		(flip fx: 1/0.7=1.4)
		else
			leg1_fx_mult = leg1_is_base_ccy ? fxs_quote_used: 1 ;//ex. 1.4 		(flip fx: 1)

		if(pv_in_base_ccy)//EUR (flip fx: USD)
			leg2_fx_mult = leg2_is_base_ccy ? 1: 1/fxs_quote_used;//ex. 1/1.4 	(flip fx: 1)
		else
			leg2_fx_mult = leg2_is_base_ccy ? fxs_quote_used :1 ;//ex. 1 		(flip fx: 0.7)
	}
	/*-----------------------------------------------------------------------
	  swap_lib_fx_handler_leg
	  ----------------------------------------------------------------------*/
	void swap_lib_fx_handler_leg(string 	leg1_curr,
								 string 	leg2_curr,
								 string 	base_ccy,
								 string 	price_ccy,
								 logical 	pv_in_leg1,
								 number 	fxs_quote_used,
								 out logical 	leg1_is_base_ccy,
								 out number 	leg1_fx_mult,
								 out number 	leg2_fx_mult)
	{		
		leg1_is_base_ccy 		= equal_casei(leg1_curr,base_ccy);//ex. true (flip fx: false)
		logical pv_in_base_ccy 	= pv_in_leg1? leg1_is_base_ccy : !leg1_is_base_ccy;
		
		swap_lib_fx_handler_ccy(leg1_curr,leg2_curr,base_ccy,price_ccy,pv_in_base_ccy,
								fxs_quote_used,leg1_is_base_ccy,leg1_fx_mult,leg2_fx_mult);
		
	}
}