/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	-----------------
	 bill create funcs
	-----------------			
*/

option(null: hard);	


//--------
// from db
//--------
/*-----------------------------------------------------------------------
  bill
  ----------------------------------------------------------------------*/
bill bill(	instrument_name 			instrument_name, 
			date option(nullable) 		trade_date 	= null<date>,
			string option(nullable) 	quote_side 	= null<string>,
			date option(nullable) 		settle_date = null<date>,
			error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Bill")
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, settle_date );		
		return create_bill(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bill");
		return null<bill>;
	}
}


/*-----------------------------------------------------------------------
  bill
  ----------------------------------------------------------------------*/
bill bill(	instrument_name 			instrument_name, 
			date option(nullable) 		trade_date ,
			number  option(nullable) 	quote ,
			date option(nullable) 		settle_date = null<date> ,
			error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Bill")
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, settle_date );
		return create_bill(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bill");
		return null<bill>;
	}
}

/*-----------------------------------------------------------------------
  bill
  ----------------------------------------------------------------------*/
bill bill(	instr_def 					instr_def, 
			date option(nullable) 		trade_date 	= null<date>,
			string option(nullable) 	quote_side 	= null<string>,
			date option(nullable) 		settle_date = null<date>,
			error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Bill")
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, settle_date );
		return create_bill(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bill");
		return null<bill>;
	}
}
/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
bill bill(	instr_def 					instr_def, 
			date option(nullable) 		trade_date ,
			number  option(nullable) 	quote ,
			date option(nullable) 		settle_date = null<date>,
			error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Bill")
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, settle_date );
		return create_bill(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bill");
		return null<bill>;
	}
}
//----------------
// from db or not
//----------------

/*-----------------------------------------------------------------------
  func: instrument_bill_nodb
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name

  ----------------------------------------------------------------------*/
bill bill(	instr_def 				instr_def, 
			string 					instrument_name  ,			
			date  option(nullable)	issue_date,
			date  					maturity,
			number option(nullable)	coupon,
			date option(nullable) 	trade_date ,
			date option(nullable) 	settle_date ,
			number option(nullable) quote ,
			quote_style option(nullable) quote_style,
			number 	option(nullable) nominal = 100,
			error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Bill")
{	
	try{
		if(null(nominal)) nominal = 100;
		__instrument c = __instrument_bill_nodb(instr_def,instrument_name,issue_date,maturity,coupon,
												trade_date,settle_date,quote,quote_style,nominal );

		return create_bill( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bill");
		return null<bill>;
	}
}

