/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström	

	-------------------------
	 bill_future create funcs	
	-------------------------	
*/

option(null: hard);	

//--------
// from db
//--------

/*-----------------------------------------------------------------------
  bill_future
  ----------------------------------------------------------------------*/
bill_future bill_future(instrument_name 			instrument_name, 
						date option(nullable) 		trade_date 	= null<date>,
						string option(nullable) 	quote_side 	= null<string>,					
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bill Future')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_bill_future(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bill_future");
		return null<bill_future>;
	}
}

/*-----------------------------------------------------------------------
  bill_future
  ----------------------------------------------------------------------*/
bill_future bill_future(instrument_name 			instrument_name, 
						date option(nullable) 		trade_date ,
						number  option(nullable) 	quote ,				
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bill Future')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote,null<date> );
		return create_bill_future(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bill_future");
		return null<bill_future>;
	}
}

/*-----------------------------------------------------------------------
  bill_future
  ----------------------------------------------------------------------*/
bill_future bill_future(instr_def 					instr_def, 
						date option(nullable) 		trade_date 	= null<date>,
						string option(nullable) 	quote_side 	= null<string>,			
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bill Future')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_bill_future(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bill_future");
		return null<bill_future>;
	}
}
/*-----------------------------------------------------------------------
  bill_future
  ----------------------------------------------------------------------*/
bill_future bill_future(instr_def 					instr_def, 
						date option(nullable) 		trade_date ,
						number  option(nullable) 	quote ,				
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bill Future')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_bill_future(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bill_future");
		return null<bill_future>;
	}
}

//----------------
// from db or not
//----------------

