/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	-----------------
	 bond create funcs	
	-----------------			
*/

option(null: hard);	


//--------
// from db
//--------
/*-----------------------------------------------------------------------
  bond
  ----------------------------------------------------------------------*/
bond bond(	instrument_name 			instrument_name, 
			date option(nullable) 		trade_date 	= null<date>,
			string option(nullable) 	quote_side 	= null<string>,
			date option(nullable) 		settle_date = null<date>,
			error_info option(nullable) error		= null<error_info>)
option(com_name: 'bond_db_qs')
option (category: "Instrument/Bond")
{	
	try{
		trade_date = conv_null_date_com(trade_date) ;	
		quote_side = conv_null_string_com(quote_side) ;
		settle_date = conv_null_date_com(settle_date) ;			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, settle_date );		
		return create_bond(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond");
		return null<bond>;
	}
}

/*-----------------------------------------------------------------------
  bond
  ----------------------------------------------------------------------*/
bond bond(	instrument_name 			instrument_name, 
			date option(nullable) 		trade_date ,
			number  option(nullable) 	quote ,
			date option(nullable) 		settle_date = null<date> ,
			error_info option(nullable) error		= null<error_info>)
option(com_name: 'bond_db')
option (category: "Instrument/Bond")
{	
	try{	
		trade_date 	= conv_null_date_com(trade_date) ;	
		quote 		= conv_null_number_com(quote) ;
		settle_date = conv_null_date_com(settle_date) ;
			
		__instrument c = __instrument(instrument_name,trade_date,quote, settle_date );
		return create_bond(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond");
		return null<bond>;
	}
}

/*-----------------------------------------------------------------------
  bond
  ----------------------------------------------------------------------*/
bond bond(	instr_def 					instr_def, 
			date option(nullable) 		trade_date 	= null<date>,
			string option(nullable) 	quote_side 	= null<string>,
			date option(nullable) 		settle_date = null<date>,
			error_info option(nullable) error		= null<error_info>)
option(com_name: 'bond_from_def_qs')
option (category: "Instrument/Bond")
{	
	try{	
		trade_date = conv_null_date_com(trade_date) ;	
		quote_side = conv_null_string_com(quote_side) ;
		settle_date = conv_null_date_com(settle_date) ;
			
		__instrument c = __instrument(instr_def,trade_date,quote_side, settle_date );
		return create_bond(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond");
		return null<bond>;
	}
}
/*-----------------------------------------------------------------------
  bond
  ----------------------------------------------------------------------*/
bond bond(	instr_def 					instr_def, 
			date option(nullable) 		trade_date ,
			number  option(nullable) 	quote ,
			date option(nullable) 		settle_date = null<date> ,
			error_info option(nullable) error		= null<error_info>)
option(com_name: 'bond_from_def')
option (category: "Instrument/Bond")
{	
	try{	
		trade_date 	= conv_null_date_com(trade_date) ;	
		quote		= conv_null_number_com(quote) ;
		settle_date = conv_null_date_com(settle_date) ;		
		__instrument c = __instrument(instr_def,trade_date,quote, settle_date );
		return create_bond(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond");
		return null<bond>;
	}
}
/*-----------------------------------------------------------------------
  bond
  ----------------------------------------------------------------------*/
bond bond(	instr_def 					instr_def, 
			date option(nullable) 		trade_date ,
			quote_link option(nullable) quote_link ,
			date option(nullable) 		settle_date = null<date> ,
			error_info option(nullable) error		= null<error_info>)
option(com_name: 'bond_from_def_ql')
option (category: "Instrument/Bond")
{	
	try{			
		number quote = quote_link.quote();	
		__instrument c = __instrument(instr_def,trade_date,quote, settle_date );
		return create_bond(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond");
		return null<bond>;
	}
}

//----------------
// from db or not
//----------------


/*-----------------------------------------------------------------------
  func: bond
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name
  ----------------------------------------------------------------------*/
bond bond(	instr_def 				instr_def, 
			string 					instrument_name  ,			
			date  					issue_date,
			date  option(nullable)	cpn_start_date,
    		date  option(nullable)	first_cpn_date,
    		date  option(nullable)	last_reg_cpn_date,
			date  					maturity,
			number option(nullable)	coupon,
			date option(nullable) 	trade_date ,
			date option(nullable) 	settle_date ,
			number option(nullable) quote ,
			quote_style option(nullable) quote_style,
			number 	option(nullable) nominal		= 100,
			error_info option(nullable) error		= null<error_info>)
option(com_name: 'bond')
option (category: 'Instrument/Bond')
{	
	try{
		if(null(nominal)) nominal = 100;
		__instrument c = __instrument_bond_nodb(instr_def,instrument_name,issue_date,cpn_start_date,first_cpn_date,last_reg_cpn_date,
												maturity,coupon,trade_date,settle_date,quote,quote_style,nominal );

		return create_bond( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond");
		return null<bond>;
	}
}


/*-----------------------------------------------------------------------
  bond_par
  create a bond where cp=100 from a disc_func
  ----------------------------------------------------------------------*/
bond bond_par(	bond template_bond,
				string 	name,
				date trade_date,
				date settle_date,
				date option(nullable) issue_date,
				date maturity,
				disc_func df,
				integer round_cpn_dec,
				error_info option(nullable) error)
{
	try{
		error_info ee 		= new error_info(true,true);
		..instr_def def 	= template_bond.instr_def(ee);
		integer cpn_freq 	= template_bond.coupon_freq(ee);
		if(null(issue_date))
			issue_date = settle_date;

		..instr_def idef_t 	= ..instr_def(def, "", maturity,100,0.01,cpn_freq,issue_date ,null<date>, null<number>,false ,ee);
		bond bn 			= bond(idef_t,trade_date,1,settle_date);
		number imp_cpn 		= bn.price_to_coupon(100, df);
		imp_cpn				= round (imp_cpn*100, round_cpn_dec)/100.0;
		idef_t 				= ..instr_def(def, name, maturity,100,imp_cpn,cpn_freq,issue_date ,null<date>, null<number>,false ,ee);
		bn 					= bond(idef_t,trade_date,1,settle_date);
		bn 					= bn.set_clean_price(100,null<date>,null<date>,ee);
		//number y			= bn.yield(df,false,ee);
		//bn					= bn.set_yield(y,ee);
		return bn;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_par");
		return null<bond>;
	}
}

/*-----------------------------------------------------------------------
  bond
  create a bond where cp=100
  ----------------------------------------------------------------------*/
bond bond_par(	bond template_bond,
				string 	name,
				date trade_date,
				date settle_date,
				date option(nullable) issue_date,
				date maturity,
				number cpn,			
				error_info option(nullable) error)
{
	try{
		error_info ee 		= new error_info(true,true);
		..instr_def def 	= template_bond.instr_def(ee);
		integer cpn_freq 	= template_bond.coupon_freq(ee);
		if(null(issue_date))
			issue_date = settle_date;
		..instr_def idef_t 	= ..instr_def(def, name, maturity,100,cpn,cpn_freq,issue_date ,null<date>, null<number>,false ,ee);
		bond bn 			= bond(idef_t,trade_date,1,settle_date);
		bn					= bn.set_clean_price(100,null<date>,null<date>,ee);
		return bn;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_par");
		return null<bond>;
	}
}


/*for(integer i=0; i < y_points; i++) {
			name[i] 			= strcat(["parbond",str(i+1,0),"Y"]);
			mat[i] 				= date_code(strcat(str(i+1,0),"Y")).apply_fwd(settle, cal);
			instr_def idef_t 	= instr_def(idef, "", mat[i],100,0.01,cpn_freq,settle ,null<date>);			
			instrument inst_t 	= instrument(idef_t,g_trade_date,1,settle);
			par_yield[i] 		= inst_t.price_to_coupon (100, df_base)*100;
			par_yield_sprd[i] 	= par_yield[i] + (null(spread[i]) ? 0 : spread[i]/100);

			instr_def idef_cr 	= instr_def(idef, "", mat[i],100,par_yield_sprd[i]/100,cpn_freq,settle ,null<date>);	
			instrument inst_cr 	= instrument(idef_cr,g_trade_date,1,settle);
			inst_cr 			= inst_cr.set_yield(par_yield_sprd[i]/100);
			push_back(v_i_cr, inst_cr);
		}*/