/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström	

	-----------------
	 bond_future create funcs	
	-----------------		
*/

option(null: hard);	

//--------
// from db
//--------

/*-----------------------------------------------------------------------
  bond_future
  ----------------------------------------------------------------------*/
bond_future bond_future(instrument_name 			instrument_name, 
						date option(nullable) 		trade_date 	= null<date>,
						string option(nullable) 	quote_side 	= null<string>,					
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_bond_future(c,null<string>,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future>;
	}
}

/*-----------------------------------------------------------------------
  bond_future
  ----------------------------------------------------------------------*/
bond_future bond_future(instrument_name 			instrument_name, 
						date option(nullable) 		trade_date ,
						string option(nullable) 	quote_side,
						string option(nullable) 	del_quote_side,		
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_bond_future(c,del_quote_side,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future>;
	}
}

/*-----------------------------------------------------------------------
  bond_future
  ----------------------------------------------------------------------*/
bond_future bond_future(instrument_name 			instrument_name, 
						date option(nullable) 		trade_date ,
						number  option(nullable) 	quote ,				
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote,null<date> );
		return create_bond_future(c,null<string>,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future>;
	}
}

/*-----------------------------------------------------------------------
  bond_future
  ----------------------------------------------------------------------*/
bond_future bond_future(instrument_name 			instrument_name, 
						date option(nullable) 		trade_date ,
						number  option(nullable) 	quote ,
						string option(nullable) 	del_quote_side,	
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote,null<date> );
		return create_bond_future(c,del_quote_side,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future>;
	}
}
/*-----------------------------------------------------------------------
  bond_future
  ----------------------------------------------------------------------*/
bond_future bond_future(instr_def 					instr_def, 
						date option(nullable) 		trade_date 	= null<date>,
						string option(nullable) 	quote_side 	= null<string>,			
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_bond_future(c,null<string>,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future>;
	}
}
/*-----------------------------------------------------------------------
  bond_future
  ----------------------------------------------------------------------*/
bond_future bond_future(instr_def 					instr_def, 
						date option(nullable) 		trade_date 	,
						string option(nullable) 	quote_side,
						string option(nullable) 	del_quote_side,		
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_bond_future(c,del_quote_side,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future>;
	}
}
/*-----------------------------------------------------------------------
  bond_future
  ----------------------------------------------------------------------*/
bond_future bond_future(instr_def 					instr_def, 
						date option(nullable) 		trade_date ,
						number  option(nullable) 	quote ,				
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_bond_future(c,null<string>,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future>;
	}
}
/*-----------------------------------------------------------------------
  bond_future
  ----------------------------------------------------------------------*/
bond_future bond_future(instr_def 					instr_def, 
						date option(nullable) 		trade_date ,
						number  option(nullable) 	quote ,
						string option(nullable) 	del_quote_side,	
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_bond_future(c,del_quote_side,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future>;
	}
}
//----------------
// from db or not
//----------------
/*-----------------------------------------------------------------------
  func: instrument_bondfut_nodb
	arguments: 
	instr_def: 	can be created either from the db or user defined 
				no lookup of quotes 
				instr_def is copied and modified
  ----------------------------------------------------------------------*/
bond_future bond_future(instr_def 				instr_def, 
						string 					instrument_name  ,
						date option(nullable) 	trade_date ,
						date  					expiry_settle_date ,
						number option(nullable) quote,										
						number 	option(nullable) nominal,
						vector(string) option(nullable) deliverables,
						string 	option(nullable) deliv_qs,
						vector(number) option(nullable) price_factors,
						vector(number) option(nullable) repo_rates,
						day_count_method option(nullable) repo_dc,
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{			
		__instrument c = __instrument_bondfut_nodb(instr_def,instrument_name,trade_date,expiry_settle_date,
												quote,nominal,deliverables, price_factors);
		return create_bond_future(c, deliverables,deliv_qs,price_factors, repo_rates, repo_dc, error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future >;
	}
}


/*-----------------------------------------------------------------------
  func: instrument_bondfut_nodb
	arguments: 
	instr_def: 	can be created either from the db or user defined 
				no lookup of quotes 
				instr_def is copied and modified
  ----------------------------------------------------------------------*/
bond_future bond_future(instr_def 				instr_def, 
						string 					instrument_name  ,
						date option(nullable) 	trade_date ,
						date  					expiry_settle_date ,
						number option(nullable) quote,										
						number 	option(nullable) nominal,
						vector(bond) option(nullable) deliverables,
						vector(number) option(nullable) price_factors,
						vector(number) option(nullable) repo_rates,
						day_count_method option(nullable) repo_dc,
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{		
		vector(string) del 	= null(deliverables) ? null<vector(string)> : deliverables.name();		
		__instrument c 		= __instrument_bondfut_nodb(instr_def,instrument_name,trade_date,expiry_settle_date,
														quote,nominal,del, price_factors);//assoc table will be filled up with del's and pf's
		return create_bond_future(c, deliverables,price_factors, repo_rates, repo_dc,error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future >;
	}
}


/*-----------------------------------------------------------------------
  func: instrument_bondfut_nodb
	arguments: 
	instr_def: 	can be created either from the db or user defined 
				no lookup of quotes 
				instr_def is copied and modified
  ----------------------------------------------------------------------*/
bond_future bond_future(instr_def 				instr_def, 
						string 					instrument_name  ,
						date option(nullable) 	trade_date ,
						date  					expiry_settle_date ,
						number option(nullable) quote,										
						number 	option(nullable) nominal,
						bond option(nullable) 	ctd,
						number option(nullable) ctd_price_factor,
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{		
		vector(string) del 	= null(ctd) ? null<vector(string)> : [ctd.name()];		
		__instrument c 		= __instrument_bondfut_nodb(instr_def,instrument_name,trade_date,expiry_settle_date,
														quote,nominal,del, [ctd_price_factor]);//assoc table will be filled up with del's and pf's
		return create_bond_future(c, [ctd],[ctd_price_factor], null<vector(number)>, null<day_count_method>,error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future >;
	}
}
 
/*-----------------------------------------------------------------------
  func: bond_future  from template
  ----------------------------------------------------------------------*/
bond_future bond_future(INSTR_TMPL.bondfut_def_tmpl			tmpl, 
						string 					instrument_name  ,
						date option(nullable) 	trade_date ,
						date  					expiry_settle_date ,
						number option(nullable) quote,										
						number 	option(nullable) nominal,
						bond option(nullable) 	ctd,
						number option(nullable) ctd_price_factor,
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{
		error_info ee = new error_info(true,true);
		instr_def def = instr_def_bond_future(tmpl, ee );

		return bond_future(	def,  instrument_name  , trade_date , expiry_settle_date , quote,										
							nominal, ctd, ctd_price_factor, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future >;
	}
}

/*-----------------------------------------------------------------------
  func: bond_future  from template
  ----------------------------------------------------------------------*/
bond_future bond_future(INSTR_TMPL.bondfut_def_tmpl			tmpl, 
						string 					instrument_name  ,
						date option(nullable) 	trade_date ,
						date  					expiry_settle_date ,
						number option(nullable) quote,										
						number 	option(nullable) nominal,
						vector(bond) option(nullable) deliverables,
						vector(number) option(nullable) price_factors,
						vector(number) option(nullable) repo_rates,
						day_count_method option(nullable) repo_dc,
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Bond Future')
{	
	try{
		error_info ee = new error_info(true,true);
		instr_def def = instr_def_bond_future(tmpl, ee );

		return bond_future(	def,  instrument_name  , trade_date , expiry_settle_date , quote,										
							nominal, deliverables, price_factors, repo_rates, repo_dc, error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "bond_future");
		return null<bond_future >;
	}
}
