/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	------------
	 deposit create funcs	
	------------		
*/

option(null: hard);	

//--------
// from db
//--------

/*-----------------------------------------------------------------------
  deposit
  ----------------------------------------------------------------------*/
deposit deposit(instrument_name 			instrument_name, 
				date option(nullable) 		trade_date 	= null<date>,
				string option(nullable) 	quote_side 	= null<string>,
				date option(nullable) 		settle_date = null<date>,
				error_info option(nullable) error		= null<error_info>)
option(com_name: 'deposit_db_qs')
option (category: 'Instrument/Deposit')
{	
	try{			
		__instrument c 	= __instrument(instrument_name,trade_date,quote_side, settle_date );		
		return create_deposit(c,error, E_INIT);
		
		/*	case 1: dep not null AND e.is_error()==false (valid)  --> OK
			case 2: dep not null AND e.is_error()==true (not valid)
			case 3: dep is null AND e.is_error()==false (valid)  --> should not happen
			case 4: dep is null AND e.is_error()==true (not valid)  --> because INSTR_CREATE_NULL_ERR is true
		*/		
	}
	catch {		
		CORE_INT.catch_error_info(error,err.type(),err.message(), "deposit");
		return null<deposit>;
	}
}

/*-----------------------------------------------------------------------
  deposit
  ----------------------------------------------------------------------*/
deposit deposit(instrument_name 			instrument_name, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,
				date option(nullable) 		settle_date = null<date>,
				error_info option(nullable) error		= null<error_info>)
option(com_name: 'deposit_db')
option (category: 'Instrument/Deposit')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, settle_date );
		return create_deposit(c,error, E_INIT);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "deposit");
		return null<deposit>;
	}
}

/*-----------------------------------------------------------------------
  deposit
  ----------------------------------------------------------------------*/
deposit deposit(instr_def 				instr_def, 
				date option(nullable) 	trade_date 	= null<date>,
				string option(nullable) quote_side 	= null<string>,
				date option(nullable) 	settle_date = null<date>,
				error_info option(nullable) error	= null<error_info>)
option(com_name: 'deposit_from_def_qs')
option (category: 'Instrument/Deposit')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, settle_date );
		return create_deposit(c,error, E_INIT);				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "deposit");
		return null<deposit>;
	}
}
/*-----------------------------------------------------------------------
  deposit
  ----------------------------------------------------------------------*/
deposit deposit(instr_def 					instr_def, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,
				date option(nullable) 		settle_date = null<date>,
				error_info option(nullable) error		= null<error_info>)
option(com_name: 'deposit_from_def')
option (category: 'Instrument/Deposit')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, settle_date );
		return create_deposit(c,error, E_INIT);				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "deposit");
		return null<deposit>;
	}
}

/*-----------------------------------------------------------------------
  deposit
  ----------------------------------------------------------------------*/
deposit deposit(instr_def 					instr_def, 
				date option(nullable) 		trade_date ,
				quote_link option(nullable) quote_link ,
				date option(nullable) 		settle_date = null<date>,
				error_info option(nullable) error		= null<error_info>)
option(com_name: 'deposit_from_def_ql')
option (category: 'Instrument/Deposit')
{	
	try{	
		number quote = quote_link.quote();		
		__instrument c = __instrument(instr_def,trade_date,quote, settle_date );
		return create_deposit(c,error, E_INIT);				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "deposit");
		return null<deposit>;
	}
}
//----------------
// from db or not
//----------------

/*-----------------------------------------------------------------------
  func: deposit
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name
	<this version could be useful for an aged depo in the book because 
		- explicit maturity
		- coupon required but not yield, yield will remain null)>
	if the intention is to create a par deposit: set coupon_rate = null and market_rate = not null
	--> in this case the deposit will remain a par deposit even after using functions such as set_date and move_date
  ----------------------------------------------------------------------*/
deposit deposit(instr_def 				instr_def, 
				string 					instrument_name  ,
				date option(nullable) 	trade_date ,
				date option(nullable) 	settle_date ,
				date option(nullable)	start_date,
				date  option(nullable) 	maturity,//maturity has precedence over mat_code
				string option(nullable) maturity_code,	
				number option(nullable)	coupon_rate,
				number option(nullable) market_rate		= null<number> ,
				number option(nullable) nominal			= 100,
				error_info option(nullable) error		= null<error_info>)
option(com_name: 'deposit')
option (category: 'Instrument/Deposit')
{	
	try{
		if(null(nominal)) nominal = 100;
		__instrument c;

		if(!null(maturity))
			c = __instrument_depo_nodb(instr_def,instrument_name,trade_date,settle_date,
										start_date,maturity,coupon_rate,market_rate,nominal );
		else
			c = __instrument_depo_nodb(instr_def,instrument_name,trade_date,settle_date,
										start_date,maturity_code,coupon_rate,market_rate,nominal );
		
		return create_deposit(c,error, E_INIT);				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "deposit");
		return null<deposit>;
	}
}


/*-----------------------------------------------------------------------
  func: deposit (maturity_code)
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name
	if the intention is to create a par deposit: set coupon_rate = null and market_rate = not null
	--> in this case the deposit will remain a par deposit even after using functions such as set_date and move_date
  ----------------------------------------------------------------------*/
/*deposit deposit(instr_def 				instr_def, 
				string 					instrument_name  ,
				date option(nullable) 	trade_date ,
				date option(nullable) 	settle_date ,
				date option(nullable) 	start_date,
				string 					maturity_code,
				number option(nullable) coupon_rate 	= null<number>,
				number option(nullable) market_rate		= null<number> ,
				number option(nullable) nominal 		= 100,	
				error_info option(nullable) error		= null<error_info>)
option(com_name: 'deposit_code')
option (category: 'Instrument/Deposit')
{	
	try{
		if(null(nominal)) nominal = 100;
		__instrument c = __instrument_depo_nodb(instr_def,instrument_name,trade_date,settle_date,
												start_date,maturity_code,coupon_rate,market_rate,nominal );
		return create_deposit(c,error, E_INIT);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "deposit");
		return null<deposit>;
	}
}*/

/*-----------------------------------------------------------------------
  func: swap_fixoisplain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
deposit deposit(	INSTR_TMPL.deposit_def_tmpl	tmpl,
					string 						instrument_name,	
					date option(nullable) 		trade_date,	
					date option(nullable) 		settle_date,
					date option(nullable) 		start_date,
					date 	option(nullable)	maturity,
					string 	option(nullable)	maturity_code,																													
					number option(nullable)		coupon_rate ,
					number option(nullable)		market_rate ,
					number 	 					nominal,																																					   
					error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Deposit')
{
	try{		
		instr_def def = instr_def_deposit(tmpl,error);		
		if(!CORE_INT.check_instr_def(def))
			return null<deposit>;
		return deposit(	def,instrument_name,trade_date,settle_date,start_date,
						maturity,maturity_code,coupon_rate ,market_rate, nominal,error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "deposit");
		return null<deposit>;
	}
}

module CORE_INT
{
	/*-----------------------------------------------------------------------
	  Name :  	create_par_depo 
	  Notes :           
	  Changes:
	  			Date    		Who     Detail
	  			3-Aug-2016 		MN 		for backward compat				      
	  ----------------------------------------------------------------------*/
	deposit create_par_depo(day_count_method 	dc,
							bd_convention 		bd,
							logical 			eom,
							string 				settle_code,
							calendar 			cal,   
							string 				currency,
							string				name, 
							date 				d, 
							date				settle,
							date 				mat,
							number				rate,
							date option(nullable) issue_date = null<date>,
							number face_amount = 100)
	
	{
		try{
			instr_def def 		= create_depo_instr_def(dc,bd,eom,settle_code,cal,currency);
			if(null(issue_date)) issue_date = settle;
			logical chk_id_s 	= issue_date == settle;
			error_info ee 		= error_info(true,true);
			deposit depo 		= deposit(def, name,d,settle,issue_date,mat,null<string>,null<number>,rate,face_amount,ee);			
			QL_FAIL_COND(null(depo.yield(false,ee)),"invalid deposit yield");
			QL_FAIL_COND(chk_id_s && depo.issue_date(ee) != depo.settle_date(ee),"invalid issue date");					
			return depo;
		}
		catch {
			CORE_INT.write_warning_message(err.message());
			return null<deposit >;
		}
	}
	//-------------------------------------------------------
	// create_class_depo
	//-------------------------------------------------------
	deposit  create_class_depo(	string 	class_name, 
								date 	d)
	{
		deposit  depo = deposit(instr_def(class_name), "", d,d+5, d+2, d+15, null<string>,null<number>, 0.01);
		return depo; 
	}
}

