option(null: hard);

/*
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	equity vanilla options create funcs
	--------------------------------------------------------------------			
*/

//--------
// from db  --> NOT POSSIBLE
//--------

/*-----------------------------------------------------------------------
  equity_option_vanilla
  ----------------------------------------------------------------------*/
equity_option_vanilla equity_option_vanilla(string 					name,
											vanilla_option_eq_def	eq_def,
											equity					eq_spot ,
											option_model_e 			opt_mod,											
											date option(nullable) 	trade,
											date 					expiry,
											number 	option(nullable) spot_price,
											number 	option(nullable) fwd_price,
											number 	 				strike,
											number 					vol_prem, 
											number 					rate_cont,
											number option(nullable) div_yld_cont,											
											error_info option(nullable) error = null<error_info> )
option (category: 'Instrument/Equity Option')
{
	try{
		error_info ee 	= new error_info(true,true);
		logical valid = eq_spot.is_valid(ee);
		if(!valid)
			QL_FAIL("underlying equity not valid");

		//quote_style_eq_opt		qs = quote_style_eq_opt.VOL; //FIX_ME 
		return new equity_option_vanilla(name,eq_def,eq_spot,opt_mod,trade,expiry, spot_price,
										 fwd_price,strike,vol_prem,rate_cont,div_yld_cont);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "equity_option_vanilla");
		return null<equity_option_vanilla>;
	}
}

/*-----------------------------------------------------------------------
  equity_option_vanilla
  ----------------------------------------------------------------------*/
/*equity_option_vanilla equity_option_vanilla(string 							name,
											equity							eq_spot ,
											option_model_e opt_mod,
											exercise_type 	exercise_type,
											opt_type 		type,
											date option(nullable) trade,
											date 			expiry,
											number 	option(nullable) spot_price,
											number 	option(nullable) fwd_price,
											number 	 		strike,
											number 			vol, 
											number 			rate_cont,
											number option(nullable) div_yld_cont,											
											number			ul_quantity,
											error_info option(nullable) error = null<error_info> )
option (category: 'Instrument/Equity Option')
{
	try{
		error_info ee 	= new error_info(true,true);
		logical valid = eq_spot.is_valid(ee);
		if(!valid)
			QL_FAIL("underlying equity not valid");
		return new equity_option_vanilla(name,eq_spot,opt_mod,exercise_type,type, trade,expiry, spot_price,fwd_price,strike,
										 vol,rate_cont,div_yld_cont,ul_quantity);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "equity_option_vanilla");
		return null<equity_option_vanilla>;
	}
}
*/
