/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	equity create funcs
	--------------------------------------------------------------------			
*/

option(null: hard);	


//--------
// from db
//--------
/*-----------------------------------------------------------------------
  equity
  ----------------------------------------------------------------------*/
equity equity(instrument_name 			instrument_name, 
				date option(nullable) 	trade_date 	= null<date>,
				string option(nullable) quote_side 	= null<string>,
				date option(nullable) 	settle_date = null<date>,
				error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Equity")
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, settle_date );		
		return create_equity(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "equity");
		return null<equity>;
	}
}

/*-----------------------------------------------------------------------
  equity
  ----------------------------------------------------------------------*/
equity equity(instrument_name 			instrument_name, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,
				date option(nullable) 		settle_date = null<date>,
				error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Equity")
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, settle_date );
		return create_equity(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "equity");
		return null<equity>;
	}
}


/*-----------------------------------------------------------------------
  equity
  ----------------------------------------------------------------------*/
equity equity(instr_def 					instr_def, 
				date option(nullable) 	trade_date 	= null<date>,
				string option(nullable) quote_side 	= null<string>,
				date option(nullable) 	settle_date = null<date>,
				error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Equity")
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, settle_date );
		return create_equity(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "equity");
		return null<equity>;
	}
}
/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
equity equity(instr_def 					instr_def, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,
				date option(nullable) 		settle_date= null<date> ,
				error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Equity")
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, settle_date );
		return create_equity(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "equity");
		return null<equity>;
	}
}

//----------------
// from db or not
//----------------

//-----------------------------------------------------------------------
//	func: instrument_equity
//		arguments: 
//		instr_def: 	can be created either from the db or user defined 
//					no lookup of quotes 
//					instr_def is copied and modified
//		instrument_name: user defined name
//  ----------------------------------------------------------------------
equity equity(	instr_def 					instr_def, 
				string 						instrument_name  ,
				date option(nullable) 		trade_date ,
				date option(nullable) 		settle_date ,					
				number option(nullable) 		quote,				
				error_info option(nullable) error		= null<error_info>) 
option (category: 'Instrument/Equity')
{	
	try{	
		//number nominal = null<number>;		
		__instrument c = __instrument_equity_nodb(instr_def,instrument_name,trade_date, settle_date, quote);
		return create_equity(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "equity");
		return null<equity>;
	}
}




