option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
		swap_fixfix create funcs - cannot be created from db currently
	--------------------------------------------------------------------			
*/

//--------
// from db
//--------

/*-----------------------------------------------------------------------
  swap_fixfix
  ----------------------------------------------------------------------*/
swap_fixfix swap_fixfix(instrument_name 			instrument_name, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Fixed')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_swap_fixfix(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixfix");
		return null<swap_fixfix>;
	}
}


/*-----------------------------------------------------------------------
  swap_fixfix
  ----------------------------------------------------------------------*/
swap_fixfix swap_fixfix(instrument_name 			instrument_name, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Fixed')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_swap_fixfix(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixfix");
		return null<swap_fixfix>;
	}
}

/*-----------------------------------------------------------------------
  swap_fixfix
  ----------------------------------------------------------------------*/
swap_fixfix swap_fixfix(instr_def 					instr_def, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Fixed')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_swap_fixfix(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixfix");
		return null<swap_fixfix>;
	}
}
/*-----------------------------------------------------------------------
  swap_fixfix
  ----------------------------------------------------------------------*/
swap_fixfix swap_fixfix(instr_def 					instr_def, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Fixed')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_swap_fixfix(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixfix");
		return null<swap_fixfix>;
	}
}

//----------------
// from db or not
//----------------


/*-----------------------------------------------------------------------
  func: swap_fixfix
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name

  ----------------------------------------------------------------------*/
swap_fixfix swap_fixfix(	instr_def 				instr_def, 
							string 					instrument_name  ,
							date option(nullable) 	trade_date ,
							date option(nullable) 	settle_date ,							
							date  option(nullable) 	maturity,//maturity has precedence over mat_code
								string option(nullable)	maturity_code,
							number option(nullable)	fix1_rate,
							number option(nullable)	fix2_rate,								
							number 					nominal = 100,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Fixed')
{	
	try{
		__instrument c;
		if(!null(maturity))
			c = __instrument_fixfix_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity,fix1_rate,fix2_rate,nominal );
		else if(!null(maturity_code))
			c = __instrument_fixfix_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity_code,fix1_rate,fix2_rate, nominal );
		else
			QL_FAIL("invalid maturity/maturity_code");

		return create_swap_fixfix( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixfix");
		return null<swap_fixfix>;
	}
}


//----------------
// no db, not par 
//----------------

/*-----------------------------------------------------------------------
  func: swap_fixfix
  ----------------------------------------------------------------------*/
swap_fixfix swap_fixfix(ql_fix_leg 		ql_fix_leg1, 							
						ql_fix_leg 		ql_fix_leg2,
						string 			id,
						error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Fixed')
{	
	try{			
		
		//QL_FAIL_COND(swap_instr_type(ql_swap_leg1,ql_swap_leg2) != INST_FIX_FIX_SWAP, "invalid instrument type");

		__instrument c = __instrument_swap(ql_fix_leg1,ql_fix_leg2,id);
		return create_swap_fixfix( c, error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixfix");
		return null<swap_fixfix>;
	}
}
 

/*-----------------------------------------------------------------------
  func: swap_fixfix
  ----------------------------------------------------------------------*/
swap_fixfix swap_fixfix(ql_fixed_income_swap ql_fixed_income_swap,
						error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Fixed')
{	
	try{	
		QL_FAIL_COND(CORE_INT.swap_instr_type(ql_fixed_income_swap) != instr_type.SWAP_FIXFIX, "invalid instrument type");

		__instrument c = __instrument_swap(ql_fixed_income_swap);

		return create_swap_fixfix( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixfix");
		return null<swap_fixfix>;
	}
}
 