option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap_fixflt_asw create funcs
	--------------------------------------------------------------------			
*/

//--------
// from db  --> NOT POSSIBLE
//--------


/*-----------------------------------------------------------------------
  swap_fixflt_asw  <single curr>
  ----------------------------------------------------------------------*/
swap_fixflt_asw swap_fixflt_asw(	string 							name,
									bond							b,									
									INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
									number 							nominal,
									disc_func 						disc_func,									
									fwd_func  						flt_fwd_func,	
									number option(nullable) 		curr_fixing,
									asw_type						type,
									number option(nullable) 		quote_spread,
									number option(nullable) 		fund_spread,
									number option(nullable) 		inv_spread,
									error_info option(nullable) error = null<error_info> )
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float ASW')
{
	try{
		error_info ee 	= new error_info(true,true);
		logical valid = b.is_valid(ee);
		if(!valid)
			QL_FAIL("fixed coupon bond not valid");
		return new swap_fixflt_asw(name,null<bond>,b,tmpl,nominal,disc_func,flt_fwd_func,curr_fixing,type,
								   null<number>,quote_spread,fund_spread,inv_spread);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_asw");
		return null<swap_fixflt_asw>;
	}
}

/*-----------------------------------------------------------------------
  swap_fixflt_asw   <cross curr>
  ----------------------------------------------------------------------*/
swap_fixflt_asw swap_fixflt_asw(	string 							name,
									bond							b,									
									INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
									number option(nullable)			nominal,
									number 							fx,
									disc_func 						disc_func_fix,
									disc_func 						disc_func_flt,									
									fwd_func  						flt_fwd_func,	
									number option(nullable) 		curr_fixing,
									asw_type						type,
									number option(nullable) 		quote_spread,
									number option(nullable) 		fund_spread,
									number option(nullable) 		inv_spread,
									error_info option(nullable) error = null<error_info> )
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float ASW')
{
	try{
		error_info ee 	= new error_info(true,true);
		logical valid = b.is_valid(ee);
		if(!valid)
			QL_FAIL("fixed coupon bond not valid");
		return new swap_fixflt_asw(name,null<bond>,b,tmpl,nominal,null<number>,fx,disc_func_fix,disc_func_flt,flt_fwd_func,
								   curr_fixing,type, null<number>, quote_spread,fund_spread,inv_spread);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_asw");
		return null<swap_fixflt_asw>;
	}
}

/*-----------------------------------------------------------------------
  swap_fixflt_asw  <single curr, aged>
  ----------------------------------------------------------------------*/
swap_fixflt_asw swap_fixflt_asw(	string 							name,
									bond							b_start	,
									bond							b_curr,	//used for mark-to-market									
									INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
									number option(nullable)			nominal,
									disc_func 						disc_func,									
									fwd_func  						flt_fwd_func,	
									number option(nullable) 		curr_fixing,
									asw_type						type,
									number 	option(nullable)		quote_spread_start,
									number option(nullable) 		quote_spread,	//used for mark-to-market, if null it will be implied
									number option(nullable) 		fund_spread,
									number option(nullable) 		inv_spread,
									error_info option(nullable) error = null<error_info> )
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float ASW')
{
	try{
		error_info ee	= new error_info(true,true);
		logical valid 	= b_curr.is_valid(ee);
		if(!valid)
			QL_FAIL("fixed coupon bond not valid (current)");
		valid 	= b_start.is_valid(ee);
		if(!valid)
			QL_FAIL("fixed coupon bond not valid (at start date)");
		return new swap_fixflt_asw(name,b_start,b_curr,tmpl,nominal,disc_func,flt_fwd_func,curr_fixing,type,quote_spread_start,
								   quote_spread,fund_spread,inv_spread);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_asw");
		return null<swap_fixflt_asw>;
	}
}

/*-----------------------------------------------------------------------
  swap_fixflt_asw  <cross curr, aged>
  ----------------------------------------------------------------------*/
swap_fixflt_asw swap_fixflt_asw(	string 							name,
									bond							b_start	,
									bond							b_curr,	//used for mark-to-market									
									INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
									number option(nullable)			nominal,
									number option(nullable)			fx_start,
									number 							fx,
									disc_func 						disc_func_fix,
									disc_func 						disc_func_flt,										
									fwd_func  						flt_fwd_func,	
									number option(nullable) 		curr_fixing,
									asw_type						type,
									number option(nullable)			quote_spread_start,
									number option(nullable) 		quote_spread,	//used for mark-to-market, if null it will be implied
									number option(nullable) 		fund_spread,
									number option(nullable) 		inv_spread,
									error_info option(nullable) error = null<error_info> )
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float ASW')
{
	try{
		error_info ee	= new error_info(true,true);
		logical valid 	= b_curr.is_valid(ee);
		if(!valid)
			QL_FAIL("fixed coupon bond not valid (current)");
		valid 	= b_start.is_valid(ee);
		if(!valid)
			QL_FAIL("fixed coupon bond not valid (at start date)");
		return new swap_fixflt_asw(name,b_start,b_curr,tmpl,nominal,fx_start,fx,disc_func_fix,disc_func_flt,flt_fwd_func,
								   curr_fixing,type,quote_spread_start, quote_spread,fund_spread,inv_spread);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_asw");
		return null<swap_fixflt_asw>;
	}
}

/*
 True asw or Synthetic FRNs:
	
	Taking the concept of a matched-maturity asset swap one step further, we can offset all of the cash-flows of a bond
	exactly – i.e. including the fixed rate. When we do so, we transfer the yield spread (or more aptly, the credit spread)
	onto the floating Libor leg of the swap. The spread, thus quoted, hence describes the credit-worthiness of the issuer
	relative to Libor markets as opposed to government bond markets.

	This is liquidity transformation of a different sort. Instead of leveraging separate liquidity pools by maturity
	and transferring them into different asset classes, this swap allows bond investors to create a synthetic
	Floating Rate Note (FRN)  for any issuer – even if they have never issued floating rate debt.

						Bond								Swap
	Price & Yield 		Dirty, Clean or Par					b.p. over Libor 
	Settlement Date 	As per request						To match bond 
	Maturity Date 		As issued							To match bond 
	Payment Frequencies As issued							To match bond 
	Payment daycount 	As issued							To match bond 
	Fixed Coupons 		As issued							To match bond ("full first")
	Libor frequency 	N/A									As per request
	Upfront fee			Dirty or Clean price				To match bond
 */


/*-----------------------------------------------------------------------
  func: swap_fixflt_bond_match

	Matched Maturity Asset Swap:
	government bond versus a swap with exactly matching maturity dates – a so-called Matched Maturity Asset Swap.
	This may be considered a more conservative way of trading as it minimises the differences between the bond
	contract and the swap contract by way of exactly matching cashflow dates where possible. This can have added
	operational and cash-management benefits in the case where a trade may be held to maturity. It also becomes an
	easier exercise to use bond auctions to move into and out of swap-spread positions as they do not need to be rolled.


						Bond								Swap
	Price & Yield 		Standard Market Price				Yield-spread (b.p.) to bond yield 
	Settlement Date 	Standard bond market convention		To match bond 
	Maturity Date 		As issued							To match bond 
	Payment Frequencies As issued							To match bond 
	Payment daycount 	As issued							To match bond 
	Fixed Coupons 		As issued							Typically short first coupon 
	Libor frequency 	N/A									Standard swaps convention

	These matched maturity asset swaps have a number of utilities:

	- Delta neutral way to maintain duration whilst reducing (or increasing) credit exposure.
	- Both legs are transacted at-market.
	- Simple quotation mechanism (yield-spread).
	- Allow swap traders to transfer liquidity between swaps markets and government bond markets without any curve risk.
	- Concentrates liquidity in two complementary Rates markets in the same maturities.
	- A swaps trader may prefer to increase (decrease) the amount of physical collateral they hold at any time without
		affecting their overall duration exposure.
	- An end investor may prefer to receive a higher fixed rate of interest from the Swaps market than they receive on their
		underlying bonds. This is particularly the case if they view a daily-collateralised, centrally cleared swap as a
		higher-rated credit than the underlying government bond.

	
	
  ----------------------------------------------------------------------*/
swap_fixflt swap_fixflt_bond_match(	string 							name,
									instrument						bi,
									INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
									number option(nullable)			nominal,
									disc_func 						disc_func,									
									vector(fwd_func)  				flt_fwd_func,
									vector(tenor_code) 				flt_tenor_code,
									logical 						allow_surf_extrap,
									number option(nullable) 		curr_fixing,									
									out number 						spread,
									error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float')
{	
	try{
		CORE_INT.reset_single(error);
		error_info ee 				= error_info(true,true);
		instr_def def 				= instr_def_swap_fixflt(tmpl,ee);

		CORE_SWAPLIB.fixflt_parm fip = new CORE_SWAPLIB.fixflt_parm();
		fip.init_static(def,"BD2");
		QL_FAIL_COND(fip.is_cross_currency(), "constructor not applicable for currency swap", E_INIT);

		instr_type t = bi.instr_type(ee);
		QL_REQUIRE(t == instr_type.FIXED_CPN_BOND || t == instr_type.BILL,"invalid instrument type (only bonds and bills supported)");
		
		string curr = bi.currency(ee);	
		QL_FAIL_COND(!equal_casei(curr,fip.fix_leg_parm().fix_ccy_),"bond currency does not match currency of swap template");

		fip.name_					= name;
		fip.pay_leg1_				= true;
		fip.trade_date_ 			= bi.trade_date(ee);
		fip.spot_code_				= bi.settle_code(ee);
		fip.fwd_start_code_ 		= null;		
		fip.settle_date_ 			= bi.settle_date(ee);
		fip.start_date_ 			= fip.settle_date_;
		fip.maturity_ 				= bi.maturity(ee);
		fip.maturity_code_ 			= null;
		//fip.cpn_roll_day_ 			= 0;
		fip.ne_ 					= notional_exchg_style.NE_NONE;
		
		if(null(nominal))
			nominal = bi.nominal(ee);
		
		fip.fix_leg_parm().fix_cpn_freq_  		= coupon_freq_from_int(bi.coupon_freq(ee))  ;
		fip.fix_leg_parm().fix_dc_ 				= bi.accr_dc_method(ee);
		fip.fix_leg_parm().fix_pmt_bus_day_ 	= bi.pmt_bus_day(ee);
		fip.fix_leg_parm().fix_pmt_calendar_ 	= bi.calendar(ee);
		fip.fix_leg_parm().fix_end_of_month_ 	= bi.eom(ee);
		fip.fix_leg_parm().fix_coupon_rate_		= null;
		
		fip.fix_leg_parm().fix_eff_date_ 		= null<date>;
		fip.fix_leg_parm().fix_first_cpn_date_ 	= null;//b.next_cpn_date(ee);
		fip.fix_leg_parm().fix_last_reg_date_ 	= null;//b.last_reg_cpn_date(ee);
		fip.fix_leg_parm().fix_notional_ 		= nominal;	
		fip.fix_leg_parm().fix_fx_mult_			= 1;

		fip.flt_leg_parm().flt_eff_date_ 		= null<date>;
		fip.flt_leg_parm().flt_first_cpn_date_ 	= null<date>;
		fip.flt_leg_parm().flt_last_reg_date_ 	= null<date>;
		fip.flt_leg_parm().flt_spread_ 			= 0;		
		fip.flt_leg_parm().flt_notional_ 		= nominal;
		fip.flt_leg_parm().flt_fx_mult_			= 1;
		fip.flt_leg_parm().flt_curr_fix_		= curr_fixing;
	
		fip.flt_leg_parm().flt_fixing_dates_ 	= null;	
		fip.flt_leg_parm().flt_fixing_rates_	= null;
		fip.flt_leg_parm().flt_fix_proxy_ 		= null;
		fip.flt_leg_parm().flt_allow_fwd_fix_	= false;

		fip.start_date_helper();

		swap_fixflt  swap 	= fip.create_swap(disc_func, disc_func, flt_fwd_func, flt_tenor_code, allow_surf_extrap);
		number fix_r 		= swap.coupon_rate(ee);
		spread 				= bi.yield(false,ee)-fix_r;

		return swap;
				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_bond_match");
		return null<swap_fixflt>;
	}
}


/*-----------------------------------------------------------------------
  func: swap_fixflt_par_asw 
  ----------------------------------------------------------------------*/
/*swap_fixflt swap_fixflt_par_asw_ccy(string 							name,
									bond							b,
									INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
									number option(nullable)			bond_nominal,
									number 							fx_rate,//bond currency = base currency, at bond settlement
									disc_func 						disc_func_fix,
									disc_func  						disc_func_flt,										
									fwd_func 						flt_fwd_func,	
									number option(nullable) 		curr_fixing,									
									out number 	spread,
									error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float')
{
	
	try{
		CORE_INT.reset_single(error);
		
		instr_def def = instr_def_swap_fixflt(tmpl,error);
		if(!CORE_INT.check_instr_def(def))
			return null<swap_fixflt>;

		error_info ee 	= error_info(true,true);
		string curr 	= b.currency(ee);
		
		logical is_ccy	= def.is_ccy_swap();						
		QL_FAIL_COND(!is_ccy,"function only applicable for currency swaps", E_INIT);
		
		string c1 = def.swap_currency_leg1(ee);
		
		QL_FAIL_COND(!equal_casei(curr,c1),"bond currency does not match fixed leg currency of swap template", E_INIT);
		string curr_flt = def.swap_currency_leg2(ee);
		
		if(null(bond_nominal)) bond_nominal = b.nominal(ee);					

		vector(date) dates;
		vector(number) amounts;

		b.cash_flow_data(bond_nominal,true,ir_cf_code.COUPON, true, false,dates,amounts,ee);		
		QL_FAIL_COND(v_size(dates) < 1, "invalid bond date vector", E_INIT);
		date m 				= dates[v_size(dates)-1];

		number ai100 		= b.accrued(false,true,ee);
		CORE_INT.instr_fail_check(null(ai100), "invalid accrued",b.name(),ee);
		
		number cp100 		= b.clean_price(false,true,ee);
		CORE_INT.instr_fail_check(null(cp100), "invalid clean price",b.name(),ee);
		
		date td 			= b.trade_date(ee);
		date sd 			= b.settle_date(ee);
		//number dfs 			= disc_func_fix.disc((sd-td)/365.0) ;
		//number pv_cpn 		= disc_func_fix.disc((dates-td)/365.0) * amounts;
		//number pv_cpn100 	= pv_cpn/bond_nominal*100.0;
		//pv_cpn100 			/= dfs;
	
		notional_exchg_style not_exchange = NE_BOTH;				
		date_code	settle_code		= date_code(b.settle_code(ee));

		ql_swap_fix_def fix_def 	= ql_swap_fix_def(	"fix_def", curr, settle_code, coupon_freq_from_int(b.coupon_freq(ee)),
														b.accr_dc_method(ee),b.pmt_bus_day(ee),b.calendar(ee),b.eom(ee),not_exchange);
						
		ir_index flt_ir_index 		= def.swap_ir_index_leg2(ee);				
		ql_swap_float_def flt_def 	= ql_swap_float_def("float_def",curr_flt,settle_code,coupon_freq_from_int(def.swap_coupon_freq_leg2(ee)),
														null<reset_freq>,def.swap_dc_method_leg2(ee),def.swap_pmt_bus_day_leg2(ee),
														def.swap_calendar_leg2(ee),def.swap_eom_leg2(ee),null<flt_comp_avg_type>,
														null<flt_sprd_comp_method>,null<flt_avg_method>,
														flt_ir_index,RS_NORM,not_exchange);

		//---leg---
		date  fix_first_cpn_date 	= b.next_cpn_date(ee);
		date  fix_last_reg_date 	= b.last_reg_cpn_date(ee);
		date  flt_first_cpn_date 	= null<date>;
		date  flt_last_reg_date 	= null<date>;		
		//date trade_date				= b.trade_date(ee);
		//date settle_date 			= b.settle_date(ee);
		date start_date 			= sd;				
		logical pay_fixed			= true;		
		vector(date) fee_dates 		= [sd];	
		vector(number) fee			= [(ai100 + (cp100 - 100))/100.0*bond_nominal];

		ql_fix_leg fix 				= ql_fix_leg(	fix_def,"fix_leg",td,sd,start_date,m,null<tenor_code>,
													pay_fixed,bond_nominal,start_date,fix_first_cpn_date,fix_last_reg_date, amounts,	
													disc_func_fix,null<number>,1,fee_dates,fee);
	
		number flt_nominal			= bond_nominal * fx_rate;
		tenor_surface flt_ts 		= tenor_surface(td, disc_func_flt,[flt_fwd_func],[flt_ir_index],false);
				
		ql_float_leg flt 			= ql_float_leg(flt_def,"float_leg",td,sd,start_date,m,null<tenor_code>,
														!pay_fixed,flt_nominal,start_date,flt_first_cpn_date,flt_last_reg_date,0,disc_func_flt,	
														flt_ts,null<number>,1/fx_rate,null<vector(date)>,null<vector(number)>,curr_fixing,false);

		
		ql_fixed_income_swap sw 	= ql_fixed_income_swap(fix,flt,name);

		spread 	= sw.solver(0,SS_FLT_SPRD_LEG1,false);
		QL_FAIL_COND(null(spread ),"error solving for spread", E_INIT);

		flt 				= ql_float_leg(flt_def,"float_leg",td,sd,start_date,m,null<tenor_code>,
											!pay_fixed,flt_nominal,start_date,flt_first_cpn_date,flt_last_reg_date,spread ,disc_func_flt,	
											flt_ts,null<number>,1/fx_rate,null<vector(date)>,null<vector(number)>,curr_fixing,false);

		sw 					= ql_fixed_income_swap(fix,flt,name);

		return swap_fixflt(sw, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_par_asw_ccy");
		return null<swap_fixflt>;
	}
}
*/
/*-----------------------------------------------------------------------
  func: swap_fixflt_par_asw   
  ----------------------------------------------------------------------*/
/*swap_fixflt swap_fixflt_par_asw(	string 							name,
									bond							b,									
									INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
									number option(nullable)			nominal,
									disc_func 						disc_func,									
									fwd_func  						flt_fwd_func,	
									number option(nullable) 		curr_fixing,									
									out number 	spread,
									error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float')
{
	
	try{
		CORE_INT.reset_single(error);
		error_info ee 				= error_info(true,true);
		instr_def def 				= instr_def_swap_fixflt(tmpl,ee);
		string curr 				= b.currency(ee);
		logical is_ccy				= def.is_ccy_swap();						
		QL_FAIL_COND(is_ccy,"inapplicable function call for cross currency swaps");
		string c2 = def.swap_currency_leg2(ee);
		
		QL_FAIL_COND(!equal_casei(curr,c2),"bond currency does not match currency of swap template");

		if(null(nominal)) nominal 	= b.nominal(ee);
		
		vector(date) dates;
		vector(number) amounts;

		ee.reset();
		b.cash_flow_data(nominal,true,ir_cf_code.COUPON, true, false,dates,amounts,ee);
		QL_FAIL_COND(v_size(dates) < 1, "invalid bond date vector", E_INIT);
				
		date m 				= dates[v_size(dates)-1];
		number ai100 		= b.accrued(false,true,ee);
		CORE_INT.instr_fail_check(null(ai100), "invalid accrued",b.name(),ee);
					
		number cp100 		= b.clean_price(false,true,ee);
		CORE_INT.instr_fail_check(null(cp100), "invalid clean price",b.name(),ee);
				
		date td 			= b.trade_date(ee);
		date sd 			= b.settle_date(ee);
		//number dfs 			= disc_func.disc((sd-td)/365.0) ;
		//number pv_cpn 		= disc_func.disc((dates-td)/365.0) * amounts;
		//number pv_cpn100 	= pv_cpn/nominal*100.0;
		//pv_cpn100 			/= dfs;
	
		notional_exchg_style not_exchange = NE_NONE;		
		coupon_freq  fix_cpn_freq 	= coupon_freq_from_int(b.coupon_freq(ee))  ;
		date_code	settle_code		= date_code(b.settle_code(ee));

		ql_swap_fix_def fix_def 	= ql_swap_fix_def(	"fix_def", curr, settle_code, fix_cpn_freq,b.accr_dc_method(ee),
														b.pmt_bus_day(ee),b.calendar(ee),b.eom(ee),not_exchange);
				
		flt_reset_style reset_style = RS_NORM;
		coupon_freq  flt_cpn_freq 	= coupon_freq_from_int(def.swap_coupon_freq_leg2(ee))  ;
		ir_index flt_ir_index 		= def.swap_ir_index_leg2(ee);
				
		ql_swap_float_def flt_def 	= ql_swap_float_def("float_def",curr,settle_code,flt_cpn_freq,
														null<reset_freq>,def.swap_dc_method_leg2(ee),def.swap_pmt_bus_day_leg2(ee),
														def.swap_calendar_leg2(ee),def.swap_eom_leg2(ee),null<flt_comp_avg_type>,
														null<flt_sprd_comp_method>,null<flt_avg_method>,
														flt_ir_index,reset_style,not_exchange);

		//---leg---
		date  fix_first_cpn_date 	= b.next_cpn_date(ee);
		date  fix_last_reg_date 	= b.last_reg_cpn_date(ee);
		date  flt_first_cpn_date 	= null<date>;
		date  flt_last_reg_date 	= null<date>;		
		date start_date 			= sd;				
		logical pay_fixed			= true;		
		vector(date) fee_dates 		= [sd];	
		vector(number) fee			= [(ai100 + (cp100 - 100))/100.0*nominal];

		ql_fix_leg fix 				= ql_fix_leg(	fix_def,"fix_leg",td,sd,start_date,m,null<tenor_code>,
													pay_fixed,nominal,start_date,fix_first_cpn_date,fix_last_reg_date, amounts,	
													disc_func,null<number>,1,fee_dates,fee);
	
		tenor_surface flt_ts 		= tenor_surface(td, disc_func,[flt_fwd_func],[flt_ir_index],false);
				
		ql_float_leg flt 			= ql_float_leg(flt_def,"float_leg",td,sd,start_date,m,null<tenor_code>,
														!pay_fixed,nominal,start_date,flt_first_cpn_date,flt_last_reg_date,0,disc_func,	
														flt_ts,null<number>,1,null<vector(date)>,null<vector(number)>,curr_fixing,false);

		
		ql_fixed_income_swap sw 	= ql_fixed_income_swap(fix,flt,name);

		spread 	= sw.solver(0,SS_FLT_SPRD_LEG1,false);
		QL_FAIL_COND(null(spread ),"error solving for spread");

		flt 				= ql_float_leg(flt_def,"float_leg",td,sd,start_date,m,null<tenor_code>,
											!pay_fixed,nominal,start_date,flt_first_cpn_date,flt_last_reg_date,spread ,disc_func,	
											flt_ts,null<number>,1,null<vector(date)>,null<vector(number)>,curr_fixing,false);

		sw 					= ql_fixed_income_swap(fix,flt,name);
		
		
		return swap_fixflt(sw, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_par_asw");
		return null<swap_fixflt>;
	}
}

*/