option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap_fixflt spread funcs
	--------------------------------------------------------------------			
*/

module CORE_INT
{
	void spread_trd_helper(	INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
							string 						instrument_name,	
							date option(nullable) 		trade_date,	
							string option(nullable) 	fwd_start_code,//if tmpl have a code it is ignored
							string 						maturity_code_sh,//if tmpl have a code it is ignored
							string 						maturity_code_lo,//if tmpl have a code it is ignored
							number option(nullable)		fix_coupon_rate_sh ,//if null --> will be set to par
							number option(nullable)		fix_coupon_rate_lo ,//if null --> will be set to par
							logical 					pay_lo,
							..disc_func option(nullable) disc_func,								
							fwd_func option(nullable) 	flt_fwd_func,																																			
							number option(nullable) 	curr_fix,									
							integer 					fix_r_rnd_dec,
							out swap_fixflt 			sw_sh,
							out swap_fixflt 			sw_lo,
							out number 					pv01_sh,
							out number 					pv01_lo)
	{
		error_info ee 	= new error_info(true,true);
		number not 		= 1000000;
		string name 	= strcat([instrument_name,": ",maturity_code_lo]);
		sw_lo 			= swap_fixflt_plain(tmpl, name,	 trade_date, fwd_start_code,maturity_code_lo,																												
											fix_coupon_rate_lo ,fix_r_rnd_dec,not,pay_lo, disc_func,  flt_fwd_func, curr_fix,ee);
		pv01_lo 		= sw_lo.pv01(null<number>,null<number>,null<disc_func>,ee);
		
		name 			= strcat([instrument_name,": ",maturity_code_sh]);
		sw_sh 			= swap_fixflt_plain(tmpl, name,	 trade_date, fwd_start_code,maturity_code_sh,																												
											fix_coupon_rate_sh ,fix_r_rnd_dec,not,!pay_lo, disc_func,  flt_fwd_func, curr_fix,ee);
		pv01_sh 		= sw_sh.pv01(null<number>,null<number>,null<disc_func>,ee);

		pv01_lo			= round(pv01_lo,3);
		pv01_sh			= round(pv01_sh,3);
	}
}

/*-----------------------------------------------------------------------
  func: swap_fixflt_plain_spread_trd
  ----------------------------------------------------------------------*/
void swap_fixflt_plain_spread_trd(	INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
									string 						instrument_name,	
									date option(nullable) 		trade_date,	
									string option(nullable) 	fwd_start_code,//if tmpl have a code it is ignored
									string 						maturity_code_sh,//if tmpl have a code it is ignored
									string 						maturity_code_lo,//if tmpl have a code it is ignored
									number option(nullable)		fix_coupon_rate_sh ,//if null --> will be set to par
									number option(nullable)		fix_coupon_rate_lo ,//if null --> will be set to par 
									number option(nullable) 	not_sh,	 
									number option(nullable) 	not_lo,
									number option(nullable) 	pv01,
									logical 					pv01_prio,
									logical 					pay_lo,
									..disc_func option(nullable) disc_func,								
									fwd_func option(nullable) 	flt_fwd_func,																																			
									number option(nullable) 	curr_fix,
									number option(nullable)		not_rnd,
									integer 					fix_r_rnd_dec,
									out swap_fixflt 			sw_sh,
									out swap_fixflt 			sw_lo,										
									error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float')
{
	try{
		QL_REQUIRE(!tmpl.is_cross_curr(),"cross currency swap not supported");
		QL_REQUIRE(pv01>0,"invalid pv01");
		error_info ee = new error_info(true,true);
		if(null(not_rnd))
			not_rnd = 1;
		
		if(!null(pv01) && (pv01_prio || (null(not_sh) && null(not_lo)))) {

			number pv01_sh, pv01_lo;
			CORE_INT.spread_trd_helper(	tmpl, instrument_name,	 trade_date, fwd_start_code,
										maturity_code_sh, maturity_code_lo, fix_coupon_rate_sh , fix_coupon_rate_lo , pay_lo,
										disc_func,flt_fwd_func,curr_fix, fix_r_rnd_dec,sw_sh, sw_lo, pv01_sh, pv01_lo);
			
			number not 		= 1000000;
			not_lo 			= abs(pv01/pv01_lo*not);
			not_lo 			= round(not_lo/not_rnd)*not_rnd;
			sw_lo.add_notional(not_lo);

			not_sh 			= abs(pv01/pv01_sh*not);
			not_sh 			= round(not_sh/not_rnd)*not_rnd;
			sw_sh.add_notional(not_sh);
		}
		else if(!null(not_sh) && !null(not_lo)) {
			not_lo = abs(not_lo);
			not_sh = abs(not_sh);
			sw_lo = swap_fixflt_plain(	tmpl, instrument_name,trade_date, fwd_start_code,maturity_code_lo,																												
										fix_coupon_rate_lo ,fix_r_rnd_dec,not_lo,pay_lo, disc_func,  flt_fwd_func, curr_fix,ee);
			
			sw_sh = swap_fixflt_plain(	tmpl, instrument_name,	 trade_date, fwd_start_code,maturity_code_sh,																												
										fix_coupon_rate_sh ,fix_r_rnd_dec,not_sh,!pay_lo, disc_func,  flt_fwd_func, curr_fix,ee);
		}
		else if(!null(not_sh)) {

			number pv01_sh, pv01_lo;
			CORE_INT.spread_trd_helper(	tmpl, instrument_name, trade_date, fwd_start_code,
										maturity_code_sh, maturity_code_lo, fix_coupon_rate_sh , fix_coupon_rate_lo , pay_lo,
										disc_func,flt_fwd_func,curr_fix, fix_r_rnd_dec,sw_sh, sw_lo, pv01_sh, pv01_lo);
			not_sh 			= abs(not_sh);
			sw_sh.add_notional(not_sh);
			
			not_lo 			= abs(pv01_sh/pv01_lo*not_sh);
			not_lo 			= round(not_lo/not_rnd)*not_rnd;
			sw_lo.add_notional(not_lo);
			
		}
		else if(!null(not_lo)) {
			number pv01_sh, pv01_lo;
			CORE_INT.spread_trd_helper(	tmpl, instrument_name,trade_date, fwd_start_code,
										maturity_code_sh, maturity_code_lo, fix_coupon_rate_sh , fix_coupon_rate_lo , pay_lo,
										disc_func,flt_fwd_func,	curr_fix, fix_r_rnd_dec,sw_sh, sw_lo, pv01_sh, pv01_lo);
			not_lo 			= abs(not_lo);
			sw_lo.add_notional(not_lo);
			
			not_sh 			= abs(pv01_lo/pv01_sh*not_lo);
			not_sh 			= round(not_sh/not_rnd)*not_rnd;
			sw_sh.add_notional(not_sh);
		}
		else {
			QL_FAIL("missing input (notionals or pv01)");
		}
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_plain_spread_trd");
		sw_lo = sw_sh = null<swap_fixflt>;
		return ;
	}
}

module CORE_INT
{
	void bfly_trd_helper(	INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
							string 						instrument_name,	
							date option(nullable) 		trade_date,	
							string option(nullable) 	fwd_start_code,//if tmpl have a code it is ignored
							string 						maturity_code_sh,//if tmpl have a code it is ignored
							string 						maturity_code_be,//if tmpl have a code it is ignored
							string 						maturity_code_lo,//if tmpl have a code it is ignored
							number option(nullable)		fix_coupon_rate_sh ,//if null --> will be set to par
							number option(nullable)		fix_coupon_rate_be ,//if null --> will be set to par 
							number option(nullable)		fix_coupon_rate_lo ,//if null --> will be set to par
							logical 					pay_belly,
							..disc_func option(nullable) disc_func,								
							fwd_func option(nullable) 	flt_fwd_func,																																			
							number option(nullable) 	curr_fix,								
							integer 					fix_r_rnd_dec,
							out swap_fixflt 			sw_sh,
							out swap_fixflt 			sw_be,
							out swap_fixflt 			sw_lo,
							out number 					pv01_sh,
							out number 					pv01_be,
							out number 					pv01_lo)
	{
		error_info ee 	= new error_info(true,true);
		number not 		= 1000000;
		string name 	= strcat([instrument_name,": ",maturity_code_lo]);
		sw_lo 			= swap_fixflt_plain(tmpl, name,	 trade_date, fwd_start_code,maturity_code_lo,																												
											fix_coupon_rate_lo ,fix_r_rnd_dec,not,!pay_belly, disc_func,  flt_fwd_func, curr_fix,ee);
		pv01_lo 		= sw_lo.pv01(null<number>,null<number>,null<disc_func>,ee);
		
		name 			= strcat([instrument_name,": ",maturity_code_sh]);
		sw_sh 			= swap_fixflt_plain(tmpl, name,	 trade_date, fwd_start_code,maturity_code_sh,																												
											fix_coupon_rate_sh ,fix_r_rnd_dec,not,!pay_belly, disc_func,  flt_fwd_func, curr_fix,ee);
		pv01_sh 		= sw_sh.pv01(null<number>,null<number>,null<disc_func>,ee);

		name 			= strcat([instrument_name,": ",maturity_code_be]);
		sw_be 			= swap_fixflt_plain(tmpl, name,	 trade_date, fwd_start_code,maturity_code_be,																												
											fix_coupon_rate_be ,fix_r_rnd_dec,not,pay_belly, disc_func,  flt_fwd_func, curr_fix,ee);
		pv01_be 		= sw_be.pv01(null<number>,null<number>,null<disc_func>,ee);
		
		pv01_lo			= round(pv01_lo,3);
		pv01_be			= round(pv01_be,3);
		pv01_sh			= round(pv01_sh,3);
	}
}

/*-----------------------------------------------------------------------
  func: swap_fixflt_plain_bfly_trd
  Note on allowed notional input
  1. all non null (notional input for all legs used)
  2. all null (--> pv01-input must be used)
  3. only one notional ()
  ----------------------------------------------------------------------*/
void swap_fixflt_plain_bfly_trd(	INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
									string 						instrument_name,	
									date option(nullable) 		trade_date,	
									string option(nullable) 	fwd_start_code,//if tmpl have a code it is ignored
									string 						maturity_code_sh,//if tmpl have a code it is ignored
									string 						maturity_code_be,//if tmpl have a code it is ignored
									string 						maturity_code_lo,//if tmpl have a code it is ignored
									number option(nullable)		fix_coupon_rate_sh ,//if null --> will be set to par
									number option(nullable)		fix_coupon_rate_be ,//if null --> will be set to par 
									number option(nullable)		fix_coupon_rate_lo ,//if null --> will be set to par 
									number option(nullable) 	not_sh,
									number option(nullable) 	not_be,	
									number option(nullable) 	not_lo,
									number option(nullable) 	pv01,
									logical 					pv01_prio,																										
									logical 					pay_belly,
									..disc_func option(nullable) disc_func,								
									fwd_func option(nullable) 	flt_fwd_func,																																			
									number option(nullable) 	curr_fix,
									number option(nullable)		not_rnd,
									integer 					fix_r_rnd_dec,
									out swap_fixflt 			sw_wing_sh,
									out swap_fixflt 			sw_belly,
									out swap_fixflt 			sw_wing_lo,									
									error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float')
{
	try{
		QL_REQUIRE(!tmpl.is_cross_curr(),"cross currency swap not supported");
		
		error_info ee = new error_info(true,true);
		if(null(not_rnd))
			not_rnd = 1;
		
		
		if(!null(pv01) && (pv01_prio || (null(not_sh) && null(not_be) && null(not_lo)))) {
			QL_REQUIRE(pv01>0,"invalid pv01");
			number pv01_sh, pv01_lo, pv01_be;
			CORE_INT.bfly_trd_helper(	tmpl, instrument_name,trade_date, fwd_start_code,
										maturity_code_sh, maturity_code_be, maturity_code_lo, fix_coupon_rate_sh , fix_coupon_rate_be,fix_coupon_rate_lo ,
										pay_belly,disc_func,flt_fwd_func,	curr_fix, fix_r_rnd_dec,sw_wing_sh, sw_belly, sw_wing_lo, pv01_sh, pv01_be,pv01_lo);

			number not 		= 1000000;
			not_be 			= abs(pv01/pv01_be*not);
			not_be 			= round(not_be/not_rnd)*not_rnd;
			sw_belly.add_notional(not_be);

			not_sh 			= abs(pv01/pv01_sh*not/2.0);
			not_sh 			= round(not_sh/not_rnd)*not_rnd;
			sw_wing_sh.add_notional(not_sh);

			not_lo 			= abs(pv01/pv01_lo*not/2.0);
			not_lo 			= round(not_lo/not_rnd)*not_rnd;
			sw_wing_lo.add_notional(not_lo);
		}
		else if(!null(not_sh) && !null(not_be) && !null(not_lo)) {
			not_lo 		= abs(not_lo);
			not_be 		= abs(not_be);
			not_sh 		= abs(not_sh);

			sw_belly 	= swap_fixflt_plain(	tmpl, instrument_name,	 trade_date, fwd_start_code,maturity_code_be,																												
											fix_coupon_rate_be ,fix_r_rnd_dec,not_be,pay_belly, disc_func,  flt_fwd_func, curr_fix,ee);

			sw_wing_sh 	= swap_fixflt_plain(	tmpl, instrument_name,	 trade_date, fwd_start_code,maturity_code_sh,																												
											fix_coupon_rate_sh ,fix_r_rnd_dec,not_sh,!pay_belly, disc_func,  flt_fwd_func, curr_fix,ee);

			sw_wing_lo 	= swap_fixflt_plain(	tmpl, instrument_name,	 trade_date, fwd_start_code,maturity_code_lo,																												
											fix_coupon_rate_lo ,fix_r_rnd_dec,not_lo,!pay_belly, disc_func,  flt_fwd_func, curr_fix,ee);
		}
		else if(!null(not_lo)) {
			QL_REQUIRE(null(not_be) && null(not_sh), "ambigous input of notionals (only one or all is allowed)");
			number pv01_sh, pv01_lo, pv01_be;
			CORE_INT.bfly_trd_helper(	tmpl, instrument_name,trade_date, fwd_start_code,
										maturity_code_sh, maturity_code_be, maturity_code_lo, fix_coupon_rate_sh , fix_coupon_rate_be,fix_coupon_rate_lo ,
										pay_belly,disc_func,flt_fwd_func,	curr_fix, fix_r_rnd_dec,sw_wing_sh, sw_belly, sw_wing_lo, pv01_sh, pv01_be,pv01_lo);
						
			not_lo 			= abs(not_lo);
			sw_wing_lo.add_notional(not_lo);
			
			not_sh 	= abs(pv01_lo/pv01_sh*not_lo);
			not_sh 			= round(not_sh/not_rnd)*not_rnd;
			sw_wing_sh.add_notional(not_sh);

			not_be 	= abs(pv01_lo/pv01_be*not_lo*2.0);
			not_be 			= round(not_be/not_rnd)*not_rnd;
			sw_belly.add_notional(not_be);
			
		}
		else if(!null(not_be)) {
			QL_REQUIRE(null(not_lo) && null(not_sh), "ambigous input of notionals (only one or all is allowed)");
			number pv01_sh, pv01_lo, pv01_be;
			CORE_INT.bfly_trd_helper(	tmpl, instrument_name,trade_date, fwd_start_code,
										maturity_code_sh, maturity_code_be, maturity_code_lo, fix_coupon_rate_sh , fix_coupon_rate_be,fix_coupon_rate_lo ,
										pay_belly,disc_func,flt_fwd_func,	curr_fix, fix_r_rnd_dec,sw_wing_sh, sw_belly, sw_wing_lo, pv01_sh, pv01_be,pv01_lo);
			
			not_be 			= abs(not_be);
			sw_belly.add_notional(not_be);

			not_sh 			= abs(pv01_be/pv01_sh*not_be/2.0);
			not_sh 			= round(not_sh/not_rnd)*not_rnd;
			sw_wing_sh.add_notional(not_sh);

			not_lo 			= abs(pv01_be/pv01_lo*not_be/2.0);
			not_lo 			= round(not_lo/not_rnd)*not_rnd;
			sw_wing_lo.add_notional(not_lo);
		}
		else if(!null(not_sh)) {
			QL_REQUIRE(null(not_be) && null(not_lo), "ambigous input of notionals (only one or all is allowed)");
			number pv01_sh, pv01_lo, pv01_be;
			CORE_INT.bfly_trd_helper(	tmpl, instrument_name,trade_date, fwd_start_code,
										maturity_code_sh, maturity_code_be, maturity_code_lo, fix_coupon_rate_sh , fix_coupon_rate_be,fix_coupon_rate_lo ,
										pay_belly,disc_func,flt_fwd_func,	curr_fix, fix_r_rnd_dec,sw_wing_sh, sw_belly, sw_wing_lo, pv01_sh, pv01_be,pv01_lo);
			
			not_sh 			= abs(not_sh);
			sw_wing_sh.add_notional(not_sh);

			not_lo 			= abs(pv01_sh/pv01_lo*not_sh);
			not_lo 			= round(not_lo/not_rnd)*not_rnd;
			sw_wing_lo.add_notional(not_lo);

			not_be 			= abs(pv01_lo/pv01_be*not_lo*2.0);
			not_be 			= round(not_be/not_rnd)*not_rnd;
			sw_belly.add_notional(not_be);
			
		}
		else {
			QL_FAIL("missing input (notionals or pv01)");
		}
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_plain_bfly_trd");
		sw_wing_sh = sw_wing_lo = sw_belly = null<swap_fixflt>;
		return;
	}
}

/*-----------------------------------------------------------------------
  func: swap_fixflt_plain_condor_trd
  ----------------------------------------------------------------------*/
void swap_fixflt_plain_condor_trd(	INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
										string 						instrument_name,	
										date option(nullable) 		trade_date,	
										string option(nullable) 	fwd_start_code,//if tmpl have a code it is ignored
										string 						maturity_code_1,//if tmpl have a code it is ignored
										string 						maturity_code_2,//if tmpl have a code it is ignored
										string 						maturity_code_3,//if tmpl have a code it is ignored
										string 						maturity_code_4,//if tmpl have a code it is ignored
										number option(nullable)		fix_coupon_rate_1 ,//if null --> will be set to par
										number option(nullable)		fix_coupon_rate_2 ,//if null --> will be set to par
										number option(nullable)		fix_coupon_rate_3 ,//if null --> will be set to par
										number option(nullable)		fix_coupon_rate_4 ,//if null --> will be set to par 
										number 	 					pv01,																										
										logical 					pay_4,
										..disc_func option(nullable) disc_func,								
										fwd_func option(nullable) 	flt_fwd_func,																																			
										number option(nullable) 	curr_fix,
										number option(nullable)		not_rnd,
										integer						fix_r_rnd_dec,
										out swap_fixflt 			sw_1,
										out swap_fixflt 			sw_2,
										out swap_fixflt 			sw_3,
										out swap_fixflt 			sw_4,
										error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float')
{
	try{
		QL_REQUIRE(!tmpl.is_cross_curr(),"cross currency swap not supported");
		QL_REQUIRE(pv01>0,"invalid pv01");
		error_info ee = new error_info(true,true);
		swap_fixflt_plain_spread_trd(	tmpl,instrument_name,trade_date,fwd_start_code, maturity_code_1, maturity_code_2,
										fix_coupon_rate_1,fix_coupon_rate_2, null<number>, null<number>, pv01, true,!pay_4,disc_func,flt_fwd_func,curr_fix,
										not_rnd,fix_r_rnd_dec,sw_1,sw_2,ee);

		swap_fixflt_plain_spread_trd(	tmpl,instrument_name,trade_date,fwd_start_code, maturity_code_3, maturity_code_4,
										fix_coupon_rate_3,fix_coupon_rate_4, null<number>, null<number>,pv01, true,pay_4,disc_func,flt_fwd_func,curr_fix,
										not_rnd,fix_r_rnd_dec,sw_3,sw_4,ee);
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_plain_condor_trd");
		sw_1 = sw_2 = sw_3 = sw_4 = null<swap_fixflt>;
		return ;
	}
}


/*-----------------------------------------------------------------------
  func: swap_fixflt_plain_pascal_trd
  ----------------------------------------------------------------------*/
void swap_fixflt_plain_pascal_trd(	INSTR_TMPL.swap_fixflt_def_tmpl	tmpl,
										string 						instrument_name,	
										date option(nullable) 		trade_date,	
										string option(nullable) 	fwd_start_code,//if tmpl have a code it is ignored
										string 						maturity_code_1,//if tmpl have a code it is ignored
										string 						maturity_code_2,//if tmpl have a code it is ignored
										string 						maturity_code_3,//if tmpl have a code it is ignored
										string 						maturity_code_4,//if tmpl have a code it is ignored
										number option(nullable)		fix_coupon_rate_1 ,//if null --> will be set to par
										number option(nullable)		fix_coupon_rate_2 ,//if null --> will be set to par
										number option(nullable)		fix_coupon_rate_3 ,//if null --> will be set to par
										number option(nullable)		fix_coupon_rate_4 ,//if null --> will be set to par 
										number 	 					pv01,																										
										logical 					pay,
										..disc_func option(nullable) disc_func,								
										fwd_func option(nullable) 	flt_fwd_func,																																			
										number option(nullable) 	curr_fix,
										number option(nullable)		not_rnd,
										integer						fix_r_rnd_dec,
										out swap_fixflt 			sw_1,
										out swap_fixflt 			sw_2,
										out swap_fixflt 			sw_3,
										out swap_fixflt 			sw_4,
										error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float')
{
	try{
		QL_REQUIRE(!tmpl.is_cross_curr(),"cross currency swap not supported");
		
		error_info ee = new error_info(true,true);
		swap_fixflt_plain_bfly_trd(	tmpl,instrument_name,trade_date,fwd_start_code, maturity_code_1, maturity_code_2, maturity_code_3,
									fix_coupon_rate_1 ,fix_coupon_rate_2 , fix_coupon_rate_3 , null<number>,null<number>,null<number>,pv01,true, pay,
									disc_func,flt_fwd_func,curr_fix,not_rnd,fix_r_rnd_dec,sw_1,sw_2,sw_3,ee);
			
		swap_fixflt sw_tmp2,sw_tmp3;
		swap_fixflt_plain_bfly_trd(	tmpl,instrument_name,trade_date,fwd_start_code, maturity_code_2, maturity_code_3, maturity_code_4,
									fix_coupon_rate_2 ,fix_coupon_rate_3 , fix_coupon_rate_4 , null<number>,null<number>,null<number>,pv01,true,!pay,
									disc_func,	flt_fwd_func,curr_fix,not_rnd,fix_r_rnd_dec,sw_tmp2,sw_tmp3,sw_4,ee);

		number n2 = sw_tmp2.notional(ee) + sw_2.notional(ee);
		sw_2.add_notional(n2);
		number n3 = sw_tmp3.notional(ee) + sw_3.notional(ee);
		sw_3.add_notional(n3);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixflt_plain_pascal_trd");
		sw_1 = sw_2 = sw_3 = sw_4 = null<swap_fixflt>;
		return ;
	}
}