option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström	

	--------------------------------------------------------------------
		swap_fixois create funcs
	--------------------------------------------------------------------		
*/

//--------
// from db
//--------

/*-----------------------------------------------------------------------
  swap_fixois
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois(instrument_name 			instrument_name, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_swap_fixois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois");
		return null<swap_fixois>;
	}
}


/*-----------------------------------------------------------------------
  swap_fixois
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois(instrument_name 			instrument_name, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_swap_fixois(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois");
		return null<swap_fixois>;
	}
}


/*-----------------------------------------------------------------------
  swap_fixois
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois(instr_def 					instr_def, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_swap_fixois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois");
		return null<swap_fixois>;
	}
}
/*-----------------------------------------------------------------------
  swap_fixois
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois(instr_def 					instr_def, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_swap_fixois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois");
		return null<swap_fixois>;
	}
}

//----------------
// from db or not
//----------------

/*-----------------------------------------------------------------------
  func: swap_fixois
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name

  ----------------------------------------------------------------------*/
swap_fixois swap_fixois(instr_def 				instr_def, 
							string 					instrument_name  ,
							date option(nullable) 	trade_date ,
							date option(nullable) 	settle_date ,							
							date  option(nullable) 	maturity,//maturity has precedence
							string option(nullable) maturity_code,
							number option(nullable)	fix_rate,							
							number 					nominal 	= 100,
							error_info option(nullable) error	= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{	
	try{
		__instrument c;
		
		if(!null(maturity))
			c = __instrument_fixois_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity,fix_rate,nominal );
		else if(!null(maturity_code))
			c = __instrument_fixois_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity_code,fix_rate,nominal );
		else
			QL_FAIL("invalid maturity/maturity_code");
		
		return create_swap_fixois( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois");
		return null<swap_fixois>;
	}
}



 
module CORE_INT_FIXOIS
{
	/*-----------------------------------------------------------------------
	  create_fixois_par
	  ----------------------------------------------------------------------*/
	
	swap_fixois create_fixois_par(instr_class_name 	class_name, 
								string				instrument_name, 									
								date 				trade_date, 
								date				settle_date,
								date 				maturity,
								number				rate)
	
	{
		try{
			error_info ee = new error_info(true,false);
			instr_def i_d 	= instr_def(class_name ,ee);
			if(ee.is_error())
				QL_FAIL(ee.message());
			
			ee = new error_info(true,true);
			swap_fixois sw 	= ..swap_fixois(i_d, instrument_name,trade_date,settle_date, 
												maturity,null<string>,rate,100, ee);			
			return sw;
		}
		catch {
			CORE_INT.write_warning_message(err.message());
			return null<swap_fixois>;
		}
	}

	/*-----------------------------------------------------------------------
	  func: swap_fixois_plain
	  minimal constructor for single curr "screen"-swap,
	  ----------------------------------------------------------------------*/		
	swap_fixois swap_fixois_plain_int(	instr_def option(nullable)						def,//only one of the def, tmpl, sw_base can be input
										swap_fixois option(nullable)					sw_base,
										INSTR_TMPL.swap_fixois_def_tmpl	option(nullable) tmpl,
										string 						name,	
										date option(nullable) 		trade_date,
										date option(nullable) 		settle_date,
										string option(nullable) 	spot_code,//not used with template
										date option(nullable) 		start_date,
										string  option(nullable)	fwd_start_code,																				
										date 	option(nullable)	maturity,
										string 	option(nullable)	maturity_code,
										number option(nullable)		fix_coupon_rate ,//if null --> will be set to par
										integer						fix_r_rnd_dec,
										number 	option(nullable)	notional,
										number 	 option(nullable)	pv01,																										
										logical 					pay_fixed,
										..disc_func option(nullable) disc_func,								
										fwd_func option(nullable) 	ois_fwd_func,
										..disc_func option(nullable) ois_fwd_disc_func,
										//number option(nullable) 	curr_fix, //used as proxy for all unknowns
										
										number option(nullable) 	ois_spread ,
										error_info option(nullable) error )
	{	
		try{

			CORE_SWAPLIB.fixois_parm fop = new CORE_SWAPLIB.fixois_parm();

			//update parm with init_static()
			if(!null(def)) {
				fop.init_static(def,spot_code);
			}
			else if(!null(sw_base)){							
				fop.init_static(sw_base,spot_code);
			}
			else if(!null(tmpl)){
				fop.init_static(tmpl);
			}
			else{
				QL_FAIL("err");
			}
			
			QL_FAIL_COND(fop.is_cross_currency(), "constructor not applicable for currency swap", E_INIT);

			//update parm with current input
			number pv01_not_unit  = 100000;//rounding unit for notional when implied from pv01

			fop.set_plain_single_ccy(name, trade_date,settle_date,start_date,fwd_start_code,maturity ,maturity_code,
										 pay_fixed,fix_r_rnd_dec,pv01_not_unit,notional,pv01,
										 fix_coupon_rate,ois_spread);

			logical sync_endog_ok = true;
			swap_fixois swap = fop.create_swap( disc_func, disc_func, ois_fwd_func,ois_fwd_disc_func,sync_endog_ok);
	
			return swap;					
		}
		catch {
			CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois_plain");
			return null<swap_fixois>;
		}
	}

	//-------------------------------------------------------
	// create_class_fixois  for backward compat
	//-------------------------------------------------------
	swap_fixois create_class_fixois(string class_name)
	{
		try {
			//dates not matter since the swap serves only as a class template
			date d 	= #2011-03-12;
			date s 	= #2011-03-14;	
			date m 	= #2011-04-14;
	
			error_info ee = error_info(true,false);
			string name = strcat(class_name,"_");
			instr_def i_d 	= instr_def(class_name , ee);			
			//QL_FAIL_COND(error.is_error(), error.message());
			ee = new error_info(true,true);
			swap_fixois sw 	= ..swap_fixois(i_d, name,d,s,m,null<string>,0.01,100, ee);					
			return sw;
		}
		catch {
			CORE_INT.write_warning_message(err.message());
			return null<swap_fixois>;
		}
	}
}
/*-----------------------------------------------------------------------
  func: swap_fixois_plain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois_plain(	instr_def 					def,
								string 						instrument_name,	
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								string option(nullable) 	spot_settle_code,
								date option(nullable) 		start_date,			//start_date has precedence over fwd_start_code
								string option(nullable) 	fwd_start_code,
								date option(nullable)		maturity,			//maturity has precedence over mat_code
								string 	option(nullable)	maturity_code,	
								number option(nullable)		fix_coupon_rate ,	//if null --> will be set to par
								integer						fix_r_rnd_dec,
								number 	 					notional,																										
								logical 					pay_fixed,
								..disc_func option(nullable) df_disc_func,								
								fwd_func option(nullable) 	ois_fwd_func,	//	ois_fwd_func has precedence if endog_df
							    //number option(nullable) 	curr_fix,
								
								number option(nullable) 	ois_spread = 0,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{
	return CORE_INT_FIXOIS.swap_fixois_plain_int(def,null,null,instrument_name,trade_date,settle_date,spot_settle_code,start_date,
												 fwd_start_code,maturity,maturity_code,
												 fix_coupon_rate ,fix_r_rnd_dec,notional, null,pay_fixed,df_disc_func,ois_fwd_func, null<disc_func>,
												 ois_spread,error );
}

/*-----------------------------------------------------------------------
  func: swap_fixois_plain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois_plain(	instr_def 					def,
								string 						instrument_name,	
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								string option(nullable) 	spot_settle_code,
								date option(nullable) 		start_date,			//start_date has precedence over fwd_start_code
								string option(nullable) 	fwd_start_code,
								date option(nullable)		maturity,			//maturity has precedence over mat_code
								string 	option(nullable)	maturity_code,																													
								number option(nullable)		fix_coupon_rate ,//if null --> will be set to par
								integer						fix_r_rnd_dec,
								number 	 					notional,																										
								logical 					pay_fixed,
								..disc_func option(nullable) df_disc_func,								
								disc_func option(nullable) 	ois_fwddf_func,	//	ois_fwddf_func has precedence if endog_df																																		
							    //number option(nullable) 	curr_fix,
								
								number option(nullable) 	ois_spread = 0,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{
	return CORE_INT_FIXOIS.swap_fixois_plain_int(def,null,null,instrument_name,trade_date,settle_date,spot_settle_code,start_date,fwd_start_code,maturity,maturity_code,
								 fix_coupon_rate ,fix_r_rnd_dec,notional, null,pay_fixed,df_disc_func,null<fwd_func>,ois_fwddf_func,
								 ois_spread,error );
}

/*-----------------------------------------------------------------------
  func: swap_fixois_plain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois_plain(	swap_fixois 				sw,
								string 						instrument_name,	
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								string option(nullable) 	spot_settle_code,
								date option(nullable) 		start_date,			//start_date has precedence over fwd_start_code
								string option(nullable) 	fwd_start_code,
								date option(nullable)		maturity,			//maturity has precedence over mat_code
								string 	option(nullable)	maturity_code,	
								number option(nullable)		fix_coupon_rate ,	//if null --> will be set to par
								integer						fix_r_rnd_dec,
								number 	 					notional,																										
								logical 					pay_fixed,
								..disc_func option(nullable) df_disc_func,								
								fwd_func option(nullable) 	ois_fwd_func,		//	ois_fwd_func has precedence if endog_df																																	
							    //number option(nullable) 	curr_fix,
							   
								number option(nullable) 	ois_spread = 0,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{
	return CORE_INT_FIXOIS.swap_fixois_plain_int(null,sw,null,instrument_name,trade_date,settle_date,spot_settle_code,start_date,
												 fwd_start_code,maturity,maturity_code, fix_coupon_rate ,fix_r_rnd_dec,notional,
												 null, pay_fixed,df_disc_func,ois_fwd_func, null<disc_func>, ois_spread,error );
}

/*-----------------------------------------------------------------------
  func: swap_fixois_plain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois_plain(	swap_fixois 				sw,
								string 						instrument_name,	
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								string option(nullable) 	spot_settle_code,
								date option(nullable) 		start_date,			//start_date has precedence over fwd_start_code
								string option(nullable) 	fwd_start_code,
								date option(nullable)		maturity,			//maturity has precedence over mat_code
								string 	option(nullable)	maturity_code,																													
								number option(nullable)		fix_coupon_rate ,//if null --> will be set to par
								integer						fix_r_rnd_dec,
								number 	 					notional,																										
								logical 					pay_fixed,
								..disc_func option(nullable) df_disc_func,								
								disc_func option(nullable) 	ois_fwddf_func,	//	ois_fwddf_func has precedence if endog_df																																			
							    //number option(nullable) 	curr_fix,
							
								number option(nullable) 	ois_spread = 0,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{
	return CORE_INT_FIXOIS.swap_fixois_plain_int(null,sw,null,instrument_name,trade_date,settle_date,spot_settle_code,start_date,fwd_start_code,maturity,maturity_code,
								 fix_coupon_rate ,fix_r_rnd_dec,notional,null, pay_fixed,df_disc_func,null<fwd_func>, ois_fwddf_func, ois_spread,error );
}


/*-----------------------------------------------------------------------
  func: swap_fixoisplain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois_plain(	INSTR_TMPL.swap_fixois_def_tmpl	tmpl,
								string 						instrument_name,	
								date option(nullable) 		trade_date,	
								string option(nullable) 	fwd_start_code,//if tmpl have a code it is ignored
								string 	option(nullable)	maturity_code,//if tmpl have a code it is ignored																													
								number option(nullable)		fix_coupon_rate ,//if null --> will be set to par
								integer						fix_r_rnd_dec,
								number 	 					notional,																										
								logical 					pay_fixed,
								..disc_func option(nullable) df_disc_func,								
								disc_func option(nullable) 	ois_fwddf_func,		//	ois_fwddf_func has precedence if endog_df																																			
							    //number option(nullable) 	curr_fix,
							 
								number option(nullable) 	ois_spread = 0,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{
	try{		
		return CORE_INT_FIXOIS.swap_fixois_plain_int(null,null,tmpl,instrument_name,trade_date,null,null,null,fwd_start_code,null,maturity_code,
								 fix_coupon_rate ,fix_r_rnd_dec,notional, null,pay_fixed,df_disc_func,null, ois_fwddf_func,
								 ois_spread,error );
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois_plain");
		return null<swap_fixois>;
	}
}

/*-----------------------------------------------------------------------
  func: swap_fixoisplain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois_plain(	INSTR_TMPL.swap_fixois_def_tmpl	tmpl,
								string 						instrument_name,	
								date option(nullable) 		trade_date,	
								string option(nullable) 	fwd_start_code,//if tmpl have a code it is ignored
								string 	option(nullable)	maturity_code,//if tmpl have a code it is ignored																													
								number option(nullable)		fix_coupon_rate ,//if null --> will be set to par
								integer						fix_r_rnd_dec,
								number 	 					notional,																										
								logical 					pay_fixed,
								..disc_func option(nullable) df_disc_func,								
								fwd_func option(nullable) 	ois_fwd_func,																																		
							    //number option(nullable) 	curr_fix,
								number option(nullable) 	ois_spread = 0,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{
	try{		
		return CORE_INT_FIXOIS.swap_fixois_plain_int(null,null,tmpl,instrument_name,trade_date,null,null,null,fwd_start_code,null,maturity_code,
								 fix_coupon_rate ,fix_r_rnd_dec,notional, null,pay_fixed,df_disc_func,ois_fwd_func, null<disc_func>,
								 ois_spread,error );
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois_plain");
		return null<swap_fixois>;
	}
}

/*-----------------------------------------------------------------------
  func: swap_fixoisplain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois_plain(	INSTR_TMPL.swap_fixois_def_tmpl	tmpl,
								string 						instrument_name,	
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								date option(nullable) 		start_date,//if tmpl have a code it is ignored
								date 	option(nullable)	maturity,//if tmpl have a code it is ignored																													
								number option(nullable)		fix_coupon_rate ,//if null --> will be set to par
								integer						fix_r_rnd_dec,
								number 	 					notional,																										
								logical 					pay_fixed,
								..disc_func option(nullable) df_disc_func,								
								disc_func option(nullable) 	ois_fwddf_func,																																					
							    //number option(nullable) 	curr_fix,
							
								number option(nullable) 	ois_spread = 0,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{
	try{		
		return CORE_INT_FIXOIS.swap_fixois_plain_int(null,null,tmpl,instrument_name,trade_date,settle_date,null,start_date,null,maturity,null,
								 fix_coupon_rate ,fix_r_rnd_dec,notional, null,pay_fixed,df_disc_func,null, ois_fwddf_func,
								 ois_spread,error );
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois_plain");
		return null<swap_fixois>;
	}
}

/*-----------------------------------------------------------------------
  func: swap_fixoisplain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois_plain(	INSTR_TMPL.swap_fixois_def_tmpl	tmpl,
								string 						instrument_name,	
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								date option(nullable) 		start_date,//if tmpl have a code it is ignored
								date 	option(nullable)	maturity,//if tmpl have a code it is ignored																													
								number option(nullable)		fix_coupon_rate ,//if null --> will be set to par
								integer						fix_r_rnd_dec,
								number 	 					notional,																										
								logical 					pay_fixed,
								..disc_func option(nullable) df_disc_func,								
								fwd_func option(nullable) 	ois_fwd_func,																																				
							    //number option(nullable) 	curr_fix,
							    
								number option(nullable) 	ois_spread = 0,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{
	try{		
		return CORE_INT_FIXOIS.swap_fixois_plain_int(null,null,tmpl,instrument_name,trade_date,settle_date,null,start_date,null,maturity,null,
								 fix_coupon_rate ,fix_r_rnd_dec,notional, null,pay_fixed,df_disc_func,ois_fwd_func, null<disc_func>,
								 ois_spread,error );
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois_plain");
		return null<swap_fixois>;
	}
}

/*-----------------------------------------------------------------------
  func: swap_fixois_plain
  this version: using instr_def
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois_plain(	instr_def 					instr_def, 
								string 						name  ,
								date option(nullable) 		trade_date ,
								date option(nullable) 		settle_date ,
								string option(nullable) 	spot_settle_code,
								date  option(nullable) 		start_date,
								string  option(nullable)	fwd_start_code,
								date  option(nullable)		maturity,
								string  option(nullable)	maturity_code,
								//integer						cpn_roll_day,
								logical 					pay_fixed,
								number 	option(nullable)	fx_quote,//required if instr_def is a cross curr, as of settle
								string 	 option(nullable)	fx_quote_baseccy ,//required if instr_def is a cross curr
								string   option(nullable)	fx_quote_priceccy ,//required if instr_def is a cross curr
								logical option(nullable)	pv_in_base_ccy ,

								stub_type option(nullable) 	fix_stub_type,
								date option(nullable) 		fix_eff_date,
					    		date  option(nullable)		fix_first_cpn_date,
					    		date  option(nullable)		fix_last_reg_date,														
								number  option(nullable) 	fix_coupon_rate ,
								integer						fix_r_rnd_dec,
								number 	 					fix_notional,	
								disc_func option(nullable) 	fix_disc_func,	//note: separate leg disc_funcs even if single currency

								stub_type option(nullable) 	ois_stub_type,
								date option(nullable) 		ois_eff_date,
								date  option(nullable)		ois_first_cpn_date,
					    		date  option(nullable)		ois_last_reg_date,													
								number 	option(nullable) 	ois_notional,
								number						ois_spread,	
								..disc_func option(nullable) ois_disc_func,	//note: separate leg disc_funcs even if single currency							
								fwd_func option(nullable) 	ois_fwd_func,	//						
														
								vector(date) option(nullable) 	ois_fixing_dates,	
								vector(number) option(nullable) ois_fixing_rates,
								//number option(nullable) first_fixing,
							    //number option(nullable) last_fixing,
							    number option(nullable) 	ois_fix_proxy, 
							    logical  option(nullable) 	ois_allow_fwd_fix,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{	
	try{

		CORE_SWAPLIB.fixois_parm fop = new CORE_SWAPLIB.fixois_parm();

		//update parm with init_static()
		fop.init_static(instr_def,spot_settle_code);

		//update parm with current input
		number	fix_pv01 = null;
		fop.set_plain(	name,trade_date, settle_date,  start_date,fwd_start_code,maturity, maturity_code, pay_fixed,fix_r_rnd_dec,100000,
						fx_quote,fx_quote_baseccy,fx_quote_priceccy,pv_in_base_ccy,
						fix_coupon_rate, fix_stub_type, fix_eff_date, fix_first_cpn_date,fix_last_reg_date, 
						fix_notional, fix_pv01,  ois_spread, ois_stub_type,ois_eff_date,ois_first_cpn_date,ois_last_reg_date, ois_notional, 
						ois_fixing_dates , ois_fixing_rates, ois_fix_proxy , ois_allow_fwd_fix);

		logical sync_endog_ok 	= true;
		swap_fixois swap 		= fop.create_swap(fix_disc_func, ois_disc_func, ois_fwd_func,null,sync_endog_ok);


		return swap;
		
					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois_plain");
		return null<swap_fixois>;
	}
}