option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap_fixois_asw create funcs
	--------------------------------------------------------------------			
*/

//--------
// from db  --> NOT POSSIBLE
//--------


/*-----------------------------------------------------------------------
  func: swap_fixois_bond_match  
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois_bond_match(	string 							name,
									instrument						bi,
									INSTR_TMPL.swap_fixois_def_tmpl	tmpl,
									number option(nullable)			nominal,
									disc_func 						disc_func,
									fwd_func  option(nullable)		ois_fwd_func,	
									disc_func  option(nullable)		ois_fwd_disc_func,																	
									out number 	spread,
									error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs Float')
{	
	try{
		CORE_INT.reset_single(error);
		error_info ee 				= error_info(true,true);
		instr_def def 				= instr_def_swap_fixois(tmpl,ee);

		CORE_SWAPLIB.fixois_parm fop = new CORE_SWAPLIB.fixois_parm();
		fop.init_static(def, "BD2");
		QL_FAIL_COND(fop.is_cross_currency(), "constructor not applicable for currency swap", E_INIT);		

		instr_type t = bi.instr_type(ee);
		QL_REQUIRE(t == instr_type.FIXED_CPN_BOND || t == instr_type.BILL,"invalid instrument type (only bonds and bills supported)");
		
		string curr 				= bi.currency(ee);		
		QL_FAIL_COND(!equal_casei(curr,fop.fix_leg_parm().fix_ccy_),"bond currency does not match currency of swap template");
		
		fop.pay_leg1_				= true;
		fop.name_					= name;
		fop.trade_date_ 			= bi.trade_date(ee);
		fop.spot_code_				= bi.settle_code(ee);
		fop.fwd_start_code_ 		= null;		
		fop.settle_date_ 			= bi.settle_date(ee);
		fop.start_date_ 			= fop.settle_date_;
		fop.maturity_ 				= bi.maturity(ee);
		fop.maturity_code_ 			= null;
		//fop.cpn_roll_day_ 			= 0;
		fop.ne_ 					= notional_exchg_style.NE_NONE;
		
		if(null(nominal))
			nominal = bi.nominal(ee);

		fop.fix_leg_parm().fix_cpn_freq_  		= coupon_freq_from_int(bi.coupon_freq(ee))  ;
		fop.fix_leg_parm().fix_dc_ 				= bi.accr_dc_method(ee);
		fop.fix_leg_parm().fix_pmt_bus_day_ 	= bi.pmt_bus_day(ee);
		fop.fix_leg_parm().fix_pmt_calendar_ 	= bi.calendar(ee);
		fop.fix_leg_parm().fix_end_of_month_ 	= bi.eom(ee);
		fop.fix_leg_parm().fix_coupon_rate_		= null;//we will solve for this
		
		fop.fix_leg_parm().fix_eff_date_ 		= null<date>;
		fop.fix_leg_parm().fix_first_cpn_date_ 	= null;//bi.next_cpn_date(ee);
		fop.fix_leg_parm().fix_last_reg_date_ 	= null;//bi.last_reg_cpn_date(ee);
		fop.fix_leg_parm().fix_notional_ 		= nominal;			
		fop.fix_leg_parm().fix_fx_mult_			= 1;
	
		fop.ois_leg_parm().ois_eff_date_ 		= null<date>;
		fop.ois_leg_parm().ois_first_cpn_date_ 	= null<date>;
		fop.ois_leg_parm().ois_last_reg_date_ 	= null<date>;
		fop.ois_leg_parm().ois_spread_ 			= 0;		
		fop.ois_leg_parm().ois_notional_ 		= nominal;
		fop.ois_leg_parm().ois_fx_mult_			= 1;
			
		fop.ois_leg_parm().ois_fixing_dates_ 	= null;	
		fop.ois_leg_parm().ois_fixing_rates_	= null;
		fop.ois_leg_parm().ois_fix_proxy_ 		= null;
		fop.ois_leg_parm().ois_allow_fwd_fix_	= false;

		fop.start_date_helper();

		logical ois_endog_df = fop.ois_leg_parm().ois_endog_df_;

		//string err_msg;
		//logical ok = CORE_INT_SWAPLIB.ois_df_check(	ois_endog_df,fop.is_ccy_, disc_func,null, ois_fwd_func, ois_fwd_disc_func, err_msg);			
		//QL_REQUIRE(ok,err_msg);
			
		swap_fixois  swap;
		if(!ois_endog_df) {
			QL_FAIL_COND(null(ois_fwd_disc_func) && null(ois_fwd_func), "ois_fwd_disc_func or ois_fwd_func required for non self discounted ois leg", E_INIT);
			QL_FAIL_COND(!null(ois_fwd_disc_func) && !null(ois_fwd_func), "ambigious input fwd_func/disc_func", E_INIT);		
		}
		else {
			QL_FAIL_COND(!null(disc_func) && (!null(ois_fwd_disc_func) || !null(ois_fwd_func)), "ambigious input: only one disc_func/fwd_func required for single currency and self discounted ois leg", E_INIT);			
		}

		logical sync_endog_ok 	= true;
		swap 					= fop.create_swap( disc_func, disc_func, ois_fwd_func,ois_fwd_disc_func,sync_endog_ok);

		number fix_r = swap.coupon_rate(ee);
		spread 		= bi.yield(false,ee)-fix_r;

		return swap;
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois_bond_match");
		return null<swap_fixois>;
	}
}