option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström	

	--------------------------------------------------------------------
		swap_fixois spread funcs
	--------------------------------------------------------------------		
*/

/*-----------------------------------------------------------------------
  func: swap_fixois_plain_spread_trd
  https://www.clarusft.com/mechanics-and-definitions-of-spread-and-butterfly-swap-packages/
  ----------------------------------------------------------------------*/
void swap_fixois_plain_spread_trd(	INSTR_TMPL.swap_fixois_def_tmpl	tmpl,
										string 						instrument_name,	
										date option(nullable) 		trade_date,	
										string option(nullable) 	fwd_start_code,//if tmpl have a code it is ignored
										string 						maturity_code_sh,//if tmpl have a code it is ignored
										string 						maturity_code_lo,//if tmpl have a code it is ignored
										number option(nullable)		fix_coupon_rate_sh ,//if null --> will be set to par
										number option(nullable)		fix_coupon_rate_lo ,//if null --> will be set to par 
										number 	 					pv01,																										
										logical 					pay_lo,
										..disc_func option(nullable) df_disc_func,								
										fwd_func option(nullable) 	ois_fwd_func,	//	ois_fwd_func has precedence if endog_df																																			
										//number option(nullable) 	curr_fix,
										integer						fix_r_rnd_dec,
										out swap_fixois 			sw_sh,
										out swap_fixois 			sw_lo,
										error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{
	try{
		QL_REQUIRE(!tmpl.is_cross_curr(),"cross currency swap not supported");
		QL_REQUIRE(pv01>0,"invalid pv01");
		error_info ee = new error_info(true,true);
		
		number not = 1000000;
		sw_lo = swap_fixois_plain(	tmpl, instrument_name,	 trade_date, fwd_start_code,maturity_code_lo,																												
												fix_coupon_rate_lo ,fix_r_rnd_dec,not,pay_lo, df_disc_func,  ois_fwd_func, 0,ee);
		number pv01_lo ;//= sw_lo.pv01(null<number>,null<number>,null<disc_func>,ee);
		number not_lo = abs(pv01/pv01_lo*not);
		sw_lo.add_notional(not_lo);

		sw_sh = swap_fixois_plain(	tmpl, instrument_name,	 trade_date, fwd_start_code,maturity_code_sh,																												
									fix_coupon_rate_sh ,fix_r_rnd_dec ,not,!pay_lo, df_disc_func,  ois_fwd_func, 0,ee);
		number pv01_sh ;//= sw_sh.pv01(null<number>,null<number>,null<disc_func>,ee);
		number not_sh = abs(pv01/pv01_sh*not);
		sw_sh.add_notional(not_sh);
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois_plain_spread_trd");
		sw_lo = sw_sh = null<swap_fixois>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  func: swap_fixois_plain_bfly_trd
  ----------------------------------------------------------------------*/
void swap_fixois_plain_bfly_trd(	INSTR_TMPL.swap_fixois_def_tmpl	tmpl,
									string 						instrument_name,	
									date option(nullable) 		trade_date,	
									string option(nullable) 	fwd_start_code,//if tmpl have a code it is ignored
									string 						maturity_code_sh,//if tmpl have a code it is ignored
									string 						maturity_code_be,//if tmpl have a code it is ignored
									string 						maturity_code_lo,//if tmpl have a code it is ignored
									number option(nullable)		fix_coupon_rate_sh ,//if null --> will be set to par
									number option(nullable)		fix_coupon_rate_be ,//if null --> will be set to par 
									number option(nullable)		fix_coupon_rate_lo ,//if null --> will be set to par 
									number 	 					pv01,																										
									logical 					pay_belly,
									..disc_func option(nullable) df_disc_func,								
									fwd_func option(nullable) 	ois_fwd_func,	//	ois_fwd_func has precedence if endog_df																																			
									//number option(nullable) 	curr_fix,
									integer						fix_r_rnd_dec,
									out swap_fixois 			sw_wing_sh,
									out swap_fixois 			sw_belly,
									out swap_fixois 			sw_wing_lo,
									error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{
	try{
		QL_REQUIRE(!tmpl.is_cross_curr(),"cross currency swap not supported");
		QL_REQUIRE(pv01>0,"invalid pv01");
		error_info ee = new error_info(true,true);

		number not = 1000000;
		sw_belly = swap_fixois_plain(	tmpl, instrument_name,	 trade_date, fwd_start_code,maturity_code_be,																												
												fix_coupon_rate_be ,fix_r_rnd_dec ,not,pay_belly, df_disc_func,  ois_fwd_func, 0,ee);
		number pv01_be ;//= sw_belly.pv01(null<number>,null<number>,null<disc_func>,ee);
		number not_be = abs(pv01/pv01_be*not);
		sw_belly.add_notional(not_be);

		sw_wing_sh = swap_fixois_plain(	tmpl, instrument_name,	 trade_date, fwd_start_code,maturity_code_sh,																												
												fix_coupon_rate_sh ,fix_r_rnd_dec ,not,!pay_belly, df_disc_func,  ois_fwd_func, 0,ee);
		number pv01_sh ;//= sw_wing_sh.pv01(null<number>,null<number>,null<disc_func>,ee);
		number not_sh = abs(pv01/pv01_sh*not/2);
		sw_wing_sh.add_notional(not_sh);

		sw_wing_lo = swap_fixois_plain(	tmpl, instrument_name,	 trade_date, fwd_start_code,maturity_code_lo,																												
												fix_coupon_rate_lo  ,fix_r_rnd_dec,not,!pay_belly, df_disc_func,  ois_fwd_func, 0,ee);
		number pv01_lo ;//= sw_wing_lo.pv01(null<number>,null<number>,null<disc_func>,ee);
		number not_lo = abs(pv01/pv01_lo*not/2);
		sw_wing_lo.add_notional(not_lo);
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois_plain_bfly_trd");
		sw_wing_sh = sw_wing_lo = sw_belly = null<swap_fixois>;
		return;
	}
}

/*-----------------------------------------------------------------------
  func: swap_fixois_plain_condor_trd
  ----------------------------------------------------------------------*/
void swap_fixois_plain_condor_trd(	INSTR_TMPL.swap_fixois_def_tmpl	tmpl,
										string 						instrument_name,	
										date option(nullable) 		trade_date,	
										string option(nullable) 	fwd_start_code,//if tmpl have a code it is ignored
										string 						maturity_code_1,//if tmpl have a code it is ignored
										string 						maturity_code_2,//if tmpl have a code it is ignored
										string 						maturity_code_3,//if tmpl have a code it is ignored
										string 						maturity_code_4,//if tmpl have a code it is ignored
										number option(nullable)		fix_coupon_rate_1 ,//if null --> will be set to par
										number option(nullable)		fix_coupon_rate_2 ,//if null --> will be set to par
										number option(nullable)		fix_coupon_rate_3 ,//if null --> will be set to par
										number option(nullable)		fix_coupon_rate_4 ,//if null --> will be set to par 
										number 	 					pv01,																										
										logical 					pay_4,
										..disc_func option(nullable) df_disc_func,								
										fwd_func option(nullable) 	ois_fwd_func,	//	ois_fwd_func has precedence if endog_df																																			
										//number option(nullable) 	curr_fix,
										integer						fix_r_rnd_dec,
										out swap_fixois 			sw_1,
										out swap_fixois 			sw_2,
										out swap_fixois 			sw_3,
										out swap_fixois 			sw_4,
										error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{
	try{
		QL_REQUIRE(!tmpl.is_cross_curr(),"cross currency swap not supported");
		QL_REQUIRE(pv01>0,"invalid pv01");
		error_info ee = new error_info(true,true);
		swap_fixois_plain_spread_trd(	tmpl,instrument_name,trade_date,fwd_start_code, maturity_code_1, maturity_code_2,
										fix_coupon_rate_1,fix_coupon_rate_2, pv01, !pay_4,df_disc_func,ois_fwd_func,
										fix_r_rnd_dec,sw_1,sw_2,ee);

		swap_fixois_plain_spread_trd(	tmpl,instrument_name,trade_date,fwd_start_code, maturity_code_3, maturity_code_4,
										fix_coupon_rate_3,fix_coupon_rate_4, pv01, pay_4,df_disc_func,ois_fwd_func,
										fix_r_rnd_dec,sw_3,sw_4,ee);
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois_plain_condor_trd");
		sw_1 = sw_2 = sw_3 = sw_4 = null<swap_fixois>;
		return ;
	}
}


/*-----------------------------------------------------------------------
  func: swap_fixois_plain_pascal_trd
  ----------------------------------------------------------------------*/
void swap_fixois_plain_pascal_trd(	INSTR_TMPL.swap_fixois_def_tmpl	tmpl,
										string 						instrument_name,	
										date option(nullable) 		trade_date,	
										string option(nullable) 	fwd_start_code,//if tmpl have a code it is ignored
										string 						maturity_code_1,//if tmpl have a code it is ignored
										string 						maturity_code_2,//if tmpl have a code it is ignored
										string 						maturity_code_3,//if tmpl have a code it is ignored
										string 						maturity_code_4,//if tmpl have a code it is ignored
										number option(nullable)		fix_coupon_rate_1 ,//if null --> will be set to par
										number option(nullable)		fix_coupon_rate_2 ,//if null --> will be set to par
										number option(nullable)		fix_coupon_rate_3 ,//if null --> will be set to par
										number option(nullable)		fix_coupon_rate_4 ,//if null --> will be set to par 
										number 	 					pv01,																										
										logical 					pay,
										..disc_func option(nullable) df_disc_func,								
										fwd_func option(nullable) 	ois_fwd_func,	//	ois_fwd_func has precedence if endog_df																																			
										//number option(nullable) 	curr_fix,
										integer						fix_r_rnd_dec,
										out swap_fixois 			sw_1,
										out swap_fixois 			sw_2,
										out swap_fixois 			sw_3,
										out swap_fixois 			sw_4,
										error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{
	try{
		QL_REQUIRE(!tmpl.is_cross_curr(),"cross currency swap not supported");
		
		error_info ee = new error_info(true,true);
		swap_fixois_plain_bfly_trd(	tmpl,instrument_name,trade_date,fwd_start_code, maturity_code_1, maturity_code_2, maturity_code_3,
									fix_coupon_rate_1 ,fix_coupon_rate_2 , fix_coupon_rate_3 , pv01, pay,
									df_disc_func,ois_fwd_func,fix_r_rnd_dec,sw_1,sw_2,sw_3,ee);
			
		swap_fixois sw_tmp2,sw_tmp3;
		swap_fixois_plain_bfly_trd(	tmpl,instrument_name,trade_date,fwd_start_code, maturity_code_2, maturity_code_3, maturity_code_4,
									fix_coupon_rate_2 ,fix_coupon_rate_3 , fix_coupon_rate_4 , pv01,!pay,
									df_disc_func,	ois_fwd_func,fix_r_rnd_dec,sw_tmp2,sw_tmp3,sw_4,ee);

		number n2 = sw_tmp2.notional(ee) + sw_2.notional(ee);
		sw_2.add_notional(n2);
		number n3 = sw_tmp3.notional(ee) + sw_3.notional(ee);
		sw_3.add_notional(n3);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois_plain_pascal_trd");
		sw_1 = sw_2 = sw_3 = sw_4 = null<swap_fixois>;
		return ;
	}
}