option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
		swap_fltflt create funcs
	--------------------------------------------------------------------			
*/

//--------
// from db
//--------

/*-----------------------------------------------------------------------
  swap_fltflt
  note: this swap will have same notional and fx=1 on both legs even if cross currency (use add functions to update the swap)
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt(instrument_name 			instrument_name, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_swap_fltflt(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt");
		return null<swap_fltflt>;
	}
}


/*-----------------------------------------------------------------------
  swap_fltflt
  note: this swap will have same notional and fx=1 on both legs even if cross currency (use add functions to update the swap)
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt(	instrument_name 			instrument_name, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,//spread on leg1
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_swap_fltflt(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt");
		return null<swap_fltflt>;
	}
}
/*-----------------------------------------------------------------------
  swap_fltflt
  note: this swap will have same notional and fx=1 on both legs even if cross currency (use add functions to update the swap)
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt(	instr_def 				instr_def, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_swap_fltflt(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt");
		return null<swap_fltflt>;
	}
}
/*-----------------------------------------------------------------------
  swap_fltflt
  note: this swap will have same notional and fx=1 on both legs even if cross currency (use add functions to update the swap)
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt(	instr_def 					instr_def, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,//spread on leg1
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_swap_fltflt(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt");
		return null<swap_fltflt>;
	}
}

//----------------
// from db or not
//----------------

/*-----------------------------------------------------------------------
  func: swap_fltflt
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name
--> will throw for currency swaps
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt(	instr_def 				instr_def, 
							string 					instrument_name  ,
							date option(nullable) 	trade_date ,
							date option(nullable) 	settle_date ,
							date  option(nullable) 	maturity,//maturity has precedence over mat_code
							string option(nullable)	maturity_code,
							number option(nullable)	spread,		//spread on leg1				
							number 					nominal = 100,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float')
{	
	try{
		QL_FAIL_COND(instr_def.is_ccy_swap(), "inapplicable function call for cross currency swaps");//because we have only one nominal as input
		__instrument c;
		
		if(!null(maturity))
			c = __instrument_fltflt_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity,spread,nominal );
		else if(!null(maturity_code))
			c = __instrument_fltflt_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity_code,spread,nominal );
		else
			QL_FAIL("invalid maturity/maturity_code");
		return create_swap_fltflt( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt");
		return null<swap_fltflt>;
	}
}




module CORE_INT_FLTFLT
{
	/*from fx_spot
		QL_FAIL_COND(null(fx_sp), "fx spot instrument required for cross currency swap", E_INIT);
		fx_spot_date 		= fx_sp.spot_date(ee);
		string base_ccy 	= fx_sp.base_ccy(ee);
		string price_ccy 	= fx_sp.price_ccy(ee);

		if(null(pv_in_base))
			pv_in_base = true;

		fxs_quote_used 	= null(fx_quote) ? fx_sp.quote(true,false,ee) : fx_quote/fx_sp.scale(ee);
		QL_FAIL_COND(null(fxs_quote_used), "invalid fx_spot quote", E_INIT);
		
		CORE_INT_SWAPLIB.swap_lib_fx_handler_ccy(flt1_curr,flt2_curr,base_ccy,price_ccy,pv_in_base,fxs_quote_used,
								leg1_is_base_ccy, flt1_fx_rate, flt2_fx_rate);
		
			
		if(null(ne))
			ne 	= NE_BOTH;
	*/
	
	/*-----------------------------------------------------------------------
	  func: swap_fltflt_plain_int
	  minimal constructor for "screen"-swap  --> NO STUBS
	  normally: leg1 = sprd_leg, leg2 = flat_leg
	  ----------------------------------------------------------------------*/
	swap_fltflt swap_fltflt_plain_int(	instr_def option(nullable)		def,//only one of the def, tmpl, sw_base can be input
										swap_fltflt option(nullable)	sw_base,
										INSTR_TMPL.swap_fltflt_def_tmpl	option(nullable) tmpl,
										string 						name,	
										date option(nullable) 		trade_date,
										date option(nullable) 		settle_date,
										string option(nullable) 	spot_code,
										date option(nullable) 		start_date,										
										string option(nullable) 	fwd_start_code,
										date 	option(nullable)	maturity,
										string 	option(nullable)	maturity_code,

										logical 					pay_float1,
										integer 					sprd_rnd_dec,
										number 	option(nullable) 	fx_quote,			//required if instr_def is a cross curr
										string 	option(nullable) 	fx_quote_baseccy,	//required if instr_def is a cross curr
										string 	option(nullable) 	fx_quote_priceccy,	//required if instr_def is a cross curr
										logical option(nullable) 	pv_in_base_ccy,
										//flt1
										number option(nullable)			flt1_notional,
										number option(nullable)			flt1_spread ,//if null --> will be set to par, spread on leg1
										number option(nullable) 		flt1_curr_fix,
										..disc_func option(nullable) 	flt1_disc_func,								
										fwd_func option(nullable) 		flt1_fwd_func,
										..disc_func option(nullable) 	flt1_fwd_disc_func,

										//flt2
										number 	 						flt2_notional,										
										number option(nullable)			flt2_spread ,//if null --> will be set to 0
										number option(nullable) 		flt2_curr_fix,
										..disc_func option(nullable) 	flt2_disc_func,								
										fwd_func option(nullable) 		flt2_fwd_func,
										..disc_func option(nullable) 	flt2_fwd_disc_func,											
										
										error_info option(nullable) 	error )
	{	
		try{
			CORE_INT.reset_single(error);
			
			//basic initial checks of input
			QL_FAIL_COND(!null(flt1_fwd_func) && !null(flt1_fwd_disc_func),"ambigious input leg1 (fwd_func/disc_func)");
			QL_FAIL_COND(!null(flt2_fwd_func) && !null(flt2_fwd_disc_func),"ambigious input leg1 (fwd_func/disc_func)");
			QL_FAIL_COND(!null(flt1_fwd_func) && null(flt2_fwd_func),"fwd_func required for leg2 when leg1 has a fwd_func");//for now, FIX_ME should be relaxed							
			
			//QL_FAIL_COND(null(flt1_notional) && null(flt1_pv01), "one of flt1_notional and flt1_pv01 is required", E_INIT);

			//create empty parm
			CORE_SWAPLIB.fltflt_parm flfl = new CORE_SWAPLIB.fltflt_parm();

			//update parm with init_basic_static
			if(!null(def)) {
				flfl.init_static(def,spot_code);
			}
			else if(!null(sw_base)){							
				flfl.init_static(sw_base,spot_code);
			}
			else if(!null(tmpl)){
				flfl.init_static(tmpl);
			}
			else{
				QL_FAIL("err");
			}
			
			//update parm with current input
			number pv01_not_unit	= 100000;//rounding unit for notional when implied from pv01
			number flt1_pv01 = null;
			
			if(!flfl.is_cross_currency()) {

				flfl.set_plain_single_ccy(	name,trade_date,settle_date,start_date,fwd_start_code,maturity ,maturity_code,
												pay_float1, sprd_rnd_dec,pv01_not_unit,flt1_notional,flt1_pv01,
												flt1_spread,flt1_curr_fix,flt2_spread,flt2_curr_fix);
			}

			else {				
				flfl.set_plain(name,trade_date,settle_date,start_date,fwd_start_code,maturity ,maturity_code, pay_float1,
							   sprd_rnd_dec,pv01_not_unit,fx_quote,fx_quote_baseccy,fx_quote_priceccy,pv_in_base_ccy,
								//flt1
								 flt1_spread,stub_type.SHORT_FIRST,null,null,null,flt1_notional,
								flt1_pv01, flt1_curr_fix,
								null,null, null, null,
								//flt2
								 flt2_spread,stub_type.SHORT_FIRST,null,null, null,
								flt2_notional, flt2_curr_fix,
								null,null, null, null);
				
			}
			swap_fltflt swap;
			if(!null(flt1_fwd_func))
				swap = flfl.create_swap(flt1_disc_func, flt1_fwd_func, flt1_disc_func,flt2_fwd_func );
			else
				swap = flfl.create_swap(flt1_disc_func, flt1_fwd_disc_func, flt1_disc_func,flt2_fwd_disc_func );
			
			return swap;
								
		}
		catch {
			CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt_plain_int");
			return null<swap_fltflt>;
		}
	}
}	
/*-----------------------------------------------------------------------
  func: swap_fltflt_plain
  minimal constructor for single curr "screen"-swap, --> NO STUBS
  this version: fwd_func input
  normally: leg1 = sprd_leg, leg2 = flat_leg
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt_plain(	instr_def 					def,
								string 						name,	
								date option(nullable) 		trade_date,	
								date option(nullable) 		settle_date,
								string option(nullable) 	spot_settle_code,
								date option(nullable) 		start_date,
								string option(nullable) 	fwd_start_code,
								date option(nullable)		maturity,			//maturity has precedence over mat_code
								string 	option(nullable)	maturity_code,																	
								logical 					pay_leg1,
								integer 					sprd_rnd_dec,
								
								number 	option(nullable) 	fx_quote,			//required if instr_def is a cross curr
								string 	option(nullable) 	fx_quote_baseccy,	//required if instr_def is a cross curr
								string 	option(nullable) 	fx_quote_priceccy,	//required if instr_def is a cross curr								
								logical option(nullable) 	pv_in_base_ccy,
								//flt1
								number option(nullable)		notional_leg1,
								number option(nullable)		spread_leg1 ,		//if null --> will be set to par
								number option(nullable) 	curr_fix_leg1,
								disc_func option(nullable) 	disc_func_leg1,
								fwd_func option(nullable) 	fwd_func_leg1,
								
								//flt2
								number 	 					notional_leg2,
								number option(nullable)		spread_leg2 ,		//if null --> will be set to 0
								number option(nullable) 	curr_fix_leg2,															    
								disc_func option(nullable) 	disc_func_leg2,
							    fwd_func option(nullable) 	fwd_func_leg2,								    								
								
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float')
{
	return CORE_INT_FLTFLT.swap_fltflt_plain_int(	def,null,null,name,trade_date,settle_date,spot_settle_code,start_date,fwd_start_code,maturity,maturity_code,
											pay_leg1, sprd_rnd_dec,fx_quote, fx_quote_baseccy,fx_quote_priceccy,pv_in_base_ccy,
											notional_leg1,spread_leg1 , curr_fix_leg1, disc_func_leg1,fwd_func_leg1, null<disc_func>,notional_leg2,
											spread_leg2,curr_fix_leg2,disc_func_leg2, fwd_func_leg2, null<disc_func>,error );
}

/*-----------------------------------------------------------------------
  func: swap_fltflt_plain
  minimal constructor for "screen"-swap, --> NO STUBS
  this version: disc_func input
  normally: leg1 = sprd_leg, leg2 = flat_leg
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt_plain(	instr_def 					def,
								string 						name,	
								date option(nullable) 		trade_date,	
								date option(nullable) 		settle_date,
								string option(nullable) 	spot_settle_code,
								date option(nullable) 		start_date,
								string option(nullable) 	fwd_start_code,
								date option(nullable)		maturity,			//maturity has precedence over mat_code
								string 	option(nullable)	maturity_code,																	
								logical 					pay_leg1,
								integer 					sprd_rnd_dec,
								
								number 	option(nullable) 	fx_quote,			//required if instr_def is a cross curr
								string 	option(nullable) 	fx_quote_baseccy,	//required if instr_def is a cross curr
								string 	option(nullable) 	fx_quote_priceccy,	//required if instr_def is a cross curr								
								logical option(nullable) 	pv_in_base_ccy,
								
								//flt1
								number option(nullable)		notional_leg1,							
								number option(nullable)		spread_leg1 ,//if null --> will be set to par
								number option(nullable) 	curr_fix_leg1,
								disc_func option(nullable) 	disc_func_leg1,
								disc_func option(nullable) 	fwd_disc_func_leg1,
								//flt2
								number 	 					notional_leg2,
								number option(nullable)		spread_leg2 ,//if null --> will be set to 0
								number option(nullable) 	curr_fix_leg2,						
								disc_func option(nullable) 	disc_func_leg2,
								disc_func option(nullable) 	fwd_disc_func_leg2,		
							
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float')
{
	return CORE_INT_FLTFLT.swap_fltflt_plain_int(	def,null,null,name,trade_date,settle_date,spot_settle_code,start_date,fwd_start_code, maturity,maturity_code,
													pay_leg1, sprd_rnd_dec,fx_quote, fx_quote_baseccy,fx_quote_priceccy,pv_in_base_ccy,
													notional_leg1,spread_leg1 , curr_fix_leg1, disc_func_leg1,null, fwd_disc_func_leg1,notional_leg2,
													spread_leg2,curr_fix_leg2,disc_func_leg2, null, fwd_disc_func_leg2,error );
}



module CORE_INT
{
	/*-----------------------------------------------------------------------
	  func: swap_fltflt_par
	  arguments: 
		instr_class_name
		instrument_name: user defined name
	
	  ----------------------------------------------------------------------*/
	
	/*swap_fltflt swap_fltflt(instr_class_name 	class_name, 
								instrument_name				instrument_name, 									
								date 				trade_date, 
								date				settle_date,
								date 				maturity,
								number				spread,
								out instr_error option(nullable) error)	
	{
		instr_def i_d 	= instr_def(class_name ,true , error);
		if(error.is_error()) return null<swap_fltflt>;
		swap_fltflt sw 	= ..swap_fltflt(	i_d, instrument_name,trade_date,settle_date, 
											maturity,spread,100, error);
		if(error.is_error()) return null<swap_fltflt>;
	}*/

	/*-----------------------------------------------------------------------
	  Name :  	create_par_fltflt
	  Notes :          
	  Changes:
	  			Date    		Who     Detail
	  			?				MN		for backward compat
	  ----------------------------------------------------------------------*/
	swap_fltflt create_par_fltflt(	instr_class_name 	class_name,
									instrument_name		instrument_name, 									
									date 				trade_date, 
									date				settle_date,
									date 				maturity,
									number				spread)
	{
		try{
			error_info ee = new error_info(true,false);
			//swap_fltflt sw = swap_fltflt_par(class_name, instrument_name, trade_date, settle_date, maturity,spread, error);
			instr_def i_d 	= instr_def(class_name ,ee);
			//QL_FAIL_COND(error.is_error(), error.message());
			ee = new error_info(true,true);
			swap_fltflt sw 	= ..swap_fltflt(i_d, instrument_name,trade_date,settle_date, maturity,null<string>,spread,100, ee);			
			
			number q1,q2;
			sw.quote(q1,q2,ee);			
			QL_FAIL_COND(null(q1) && null(q2),"invalid quote");
			return sw;
		}
		catch {
			CORE_INT.write_warning_message(err.message());
			return null<swap_fltflt>;
		}
	}

	
}
