option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
		swap_fltflt2s create funcs
	--------------------------------------------------------------------			
*/

//--------
// from db
//--------

/*-----------------------------------------------------------------------
  swap_fltflt2s
  ----------------------------------------------------------------------*/
swap_fltflt2s swap_fltflt2s(instrument_name 			instrument_name, 
								date option(nullable) 		trade_date 	= null<date>,
								string option(nullable) 	quote_side 	= null<string>,
								error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float (2-swap)')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_swap_fltflt2s(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt2s");
		return null<swap_fltflt2s>;
	}
}

/*-----------------------------------------------------------------------
  swap_fltflt2s
  ----------------------------------------------------------------------*/
swap_fltflt2s swap_fltflt2s(instrument_name 			instrument_name, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float (2-swap)')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_swap_fltflt2s(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt2s");
		return null<swap_fltflt2s>;
	}
}


/*-----------------------------------------------------------------------
  swap_fltflt2s
  ----------------------------------------------------------------------*/
swap_fltflt2s swap_fltflt2s(instr_def 					instr_def, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float (2-swap)')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_swap_fltflt2s(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt2s");
		return null<swap_fltflt2s>;
	}
}
/*-----------------------------------------------------------------------
  swap_fltflt2s
  ----------------------------------------------------------------------*/
swap_fltflt2s swap_fltflt2s(instr_def 					instr_def, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float (2-swap)')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_swap_fltflt2s(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt2s");
		return null<swap_fltflt2s>;
	}
}

//----------------
// from db or not
//----------------


/*-----------------------------------------------------------------------
  func: swap_fltflt2s
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name

  ----------------------------------------------------------------------*/
swap_fltflt2s swap_fltflt2s(	instr_def 				instr_def, 
								string 					instrument_name  ,
								date option(nullable) 	trade_date ,
								date option(nullable) 	settle_date ,							
								date  option(nullable) 	maturity,//maturity has precedence over mat_code
								string option(nullable)	maturity_code,
								number option(nullable)	spread,							
								number 					nominal= 100,
								error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float (2-swap)')
{	
	try{
		__instrument c;
		if(!null(maturity))
			c = __instrument_fltflt2s_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity,spread,nominal );
		else if(!null(maturity_code))
			c = __instrument_fltflt2s_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity_code,spread,nominal );
		else
			QL_FAIL("invalid maturity/maturity_code");

		return create_swap_fltflt2s( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt2s");
		return null<swap_fltflt2s>;
	}
}



//----------------
// no db, not par 
//----------------


/*-----------------------------------------------------------------------
  func: swap_fltflt2s  (fltflt as result)
  ----------------------------------------------------------------------*/
swap_fltflt swap_fltflt2s(instr_def 						instr_def, 
							string 							name  ,
							date  							trade_date ,
							date  	option(nullable)		settle_date ,
							string option(nullable) 		spot_settle_code,
							date  	option(nullable)		start_date ,
							string option(nullable) 		fwd_start_code,
							date option(nullable)			maturity,
							string option(nullable) 		maturity_code,
							//integer							cpn_roll_day,
							number 	 						notional,
							number  						fix_spread ,				   										
							number option(nullable) 		fix_cpn_rate_flat ,		
							integer 						fix_r_rnd_dec,// < 0 --> no rounding
							logical 						pay_fix_flat,//--> if true --> receive: flt_flat_leg  and pay: flt_sprd_leg_
							disc_func option(nullable) 		disc_func,
							//flt sprd leg
							fwd_func option(nullable) 		flt_sprd_fwd_func,						
							number  option(nullable)		flt_sprd_curr_fix,
							vector(date) option(nullable) 	flt_sprd_fixing_dates,	
							vector(number) option(nullable) flt_sprd_fixing_rates,
							//number option(nullable) 		first_fixing,
							//number option(nullable) 		last_fixing,
							number option(nullable) 		flt_sprd_fix_proxy, 
							logical  option(nullable) 		flt_sprd_allow_fwd_fix,
							//flt flat leg
							fwd_func option(nullable) 		flt_flat_fwd_func,						
							number  option(nullable)		flt_flat_curr_fix,
							vector(date) option(nullable) 	flt_flat_fixing_dates,	
							vector(number) option(nullable) flt_flat_fixing_rates,
							//number option(nullable) 		first_fixing,
							//number option(nullable) 		last_fixing,
							number option(nullable) 		flt_flat_fix_proxy, 
							logical  option(nullable) 		flt_flat_allow_fwd_fix,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float (2-swap)')
{	
	try{

		CORE_SWAPLIB.fltflt2s_parm flfl = new CORE_SWAPLIB.fltflt2s_parm();

		//update parm with init_basic_static
		flfl.init_static(instr_def, spot_settle_code);

		number pv01_not_unit 	= 100000;//rounding unit for notional when implied from pv01
		number	fix_pv01 		= null;

		flfl.set_plain(name, trade_date, settle_date,start_date, fwd_start_code,maturity,maturity_code,!pay_fix_flat,
					   fix_r_rnd_dec,pv01_not_unit,notional, fix_pv01,
						fix_cpn_rate_flat, fix_spread,null,null,null,null,
						//flt1
					   null,null,null,null,
						flt_sprd_curr_fix,
						flt_sprd_fixing_dates ,	
						flt_sprd_fixing_rates,
						flt_sprd_fix_proxy ,
						flt_sprd_allow_fwd_fix,
						//flt2							
						null,null,null ,null ,flt_flat_curr_fix,
						flt_flat_fixing_dates ,	
						flt_flat_fixing_rates,
						flt_flat_fix_proxy ,
						flt_flat_allow_fwd_fix);

		swap_fltflt sw_ff = flfl.create_swap(disc_func, flt_sprd_fwd_func, flt_flat_fwd_func, null);
		
		return sw_ff;
		
						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt2s");
		return null<swap_fltflt>;
	}
}

/*-----------------------------------------------------------------------
  func: swap_fltflt2s (2 swaps as result)
  ----------------------------------------------------------------------*/
void swap_fltflt2s(	instr_def 						instr_def, 
					string 							name  ,
					date  							trade_date ,
					date  	option(nullable)		settle_date ,
					string option(nullable) 		spot_settle_code,
					date  	option(nullable)		start_date ,
					string  option(nullable)		fwd_start_code,
					date  option(nullable)			maturity,
					string  option(nullable)		maturity_code,
					//integer						cpn_roll_day,
					number 	 						notional,
					number  						fix_spread ,
		   			number option(nullable) 		fix_cpn_rate_flat ,		
					integer 						fix_r_rnd_dec,// < 0 --> no rounding
					logical 						pay_fix_flat,//--> if true --> receive: flt_flat_leg  and pay: flt_sprd_leg_
					disc_func option(nullable) 		disc_func,
					//flt sprd leg
					fwd_func option(nullable) 		flt_sprd_fwd_func,						
					number  option(nullable)		flt_sprd_curr_fix,
					vector(date) option(nullable) 	flt_sprd_fixing_dates,	
					vector(number) option(nullable) flt_sprd_fixing_rates,
					//number option(nullable) 		first_fixing,
				    //number option(nullable) 		last_fixing,
				    number option(nullable) 		flt_sprd_fix_proxy, 
				    logical  option(nullable) 		flt_sprd_allow_fwd_fix,
					//flt flat leg
					fwd_func option(nullable) 		flt_flat_fwd_func,						
					number  option(nullable)		flt_flat_curr_fix,
					vector(date) option(nullable) 	flt_flat_fixing_dates,	
					vector(number) option(nullable) flt_flat_fixing_rates,
					//number option(nullable) 		first_fixing,
				    //number option(nullable) 		last_fixing,
				    number option(nullable) 		flt_flat_fix_proxy, 
				    logical  option(nullable) 		flt_flat_allow_fwd_fix,

					out swap_fixflt option(nullable)	fix_flt_sprd,
					out swap_fixflt option(nullable)	fix_flt_flat,
					error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs Float (2-swap)')
{	
	try{
		CORE_SWAPLIB.fltflt2s_parm flfl = new CORE_SWAPLIB.fltflt2s_parm();

		//update parm with init_basic_static
		flfl.init_static(instr_def, spot_settle_code);

		number pv01_not_unit 	= 100000;//rounding unit for notional when implied from pv01
		number	fix_pv01 		= null;

		flfl.set_plain(name, trade_date, settle_date,start_date, fwd_start_code,maturity,maturity_code,!pay_fix_flat,
					   fix_r_rnd_dec,pv01_not_unit,notional, fix_pv01,
						fix_cpn_rate_flat, fix_spread,null,null,null,null,
						//flt1
					   null,null,null,null,
						flt_sprd_curr_fix,
						flt_sprd_fixing_dates ,	
						flt_sprd_fixing_rates,
						flt_sprd_fix_proxy ,
						flt_sprd_allow_fwd_fix,
						//flt2							
						null,null,null ,null ,flt_flat_curr_fix,
						flt_flat_fixing_dates ,	
						flt_flat_fixing_rates,
						flt_flat_fix_proxy ,
						flt_flat_allow_fwd_fix);
		

		flfl.create_swap(disc_func, flt_sprd_fwd_func, flt_flat_fwd_func, fix_flt_sprd,fix_flt_flat,null,true);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltflt2s");
		fix_flt_flat  = null<swap_fixflt>;
		fix_flt_sprd = null<swap_fixflt>;
		return ;
	}
}

