option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström	

	--------------------------------------------------------------------
		swap_fltois create funcs - cannot be created from db currently
	--------------------------------------------------------------------		
*/

//--------
// from db
//--------


/*-----------------------------------------------------------------------
  swap_fltois
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois(instrument_name 			instrument_name, 
							date option(nullable) 		trade_date 	= null<date>,
							string option(nullable) 	quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_swap_fltois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois");
		return null<swap_fltois>;
	}
}


/*-----------------------------------------------------------------------
  swap_fltois
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois(instrument_name 			instrument_name, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,//spread on the ois leg	
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_swap_fltois(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois");
		return null<swap_fltois>;
	}
}


/*-----------------------------------------------------------------------
  swap_fltois
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois(instr_def 					instr_def, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_swap_fltois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois");
		return null<swap_fltois>;
	}
}
/*-----------------------------------------------------------------------
  swap_fltois
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois(instr_def 					instr_def, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,//spread on the ois leg	
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_swap_fltois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois");
		return null<swap_fltois>;
	}
}

//----------------
// from db or not
//----------------

/*-----------------------------------------------------------------------
  func: swap_fltois
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name

  ----------------------------------------------------------------------*/
swap_fltois swap_fltois(instr_def 				instr_def, 
							string 					instrument_name  ,
							date option(nullable) 	trade_date ,
							date option(nullable) 	settle_date ,							
							date  option(nullable) 	maturity,//maturity has precedence
							string option(nullable) maturity_code,
							number option(nullable)	spread_vs_ois,	//spread on the ois leg						
							number 					nominal= 100,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{	
	try{
		__instrument c;
		
		if(!null(maturity))
			c = __instrument_fltois_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity,spread_vs_ois,nominal );
		else if(!null(maturity_code))
			c = __instrument_fltois_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity_code,spread_vs_ois,nominal );
		else
			QL_FAIL("invalid maturity/maturity_code");


		return create_swap_fltois( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois");
		return null<swap_fltois>;
	}
}



module CORE_INT_FLTOIS
{	
	
	/*-----------------------------------------------------------------------
	  Name :  	create_fltois_par
	  Notes :          
	  Changes:
	  			Date    		Who     Detail
	  			?				MN		for backward compat
	  ----------------------------------------------------------------------*/
	swap_fltois create_fltois_par(	instr_class_name 	class_name,
									instrument_name		instrument_name, 									
									date 				trade_date, 
									date				settle_date,
									date 				maturity,
									number				spread_vs_ois)
	{
		try{
			error_info ee = new error_info(true,false);
			instr_def i_d 	= instr_def(class_name , ee);
			
			if(ee.is_error())
				QL_FAIL(ee.message());
			
			ee = new error_info(true,true);
			swap_fltois sw 	= ..swap_fltois(i_d, instrument_name,trade_date,settle_date,
												maturity,null<string>,spread_vs_ois,100, ee);
			//QL_FAIL_COND(null(sw.yield()),"invalid yield");
			return sw;
		}
		catch {
			CORE_INT.write_warning_message(err.message());
			return null<swap_fltois>;
		}
	}
		
	/*-----------------------------------------------------------------------
	  func: swap_fixflt_plain
	  minimal constructor for single curr "screen"-swap,
	  ----------------------------------------------------------------------*/
	swap_fltois swap_fltois_plain_int(	instr_def option(nullable)						def,//only one of the def, tmpl, sw_base can be input
										swap_fltois option(nullable)					sw_base,
										INSTR_TMPL.swap_fltois_def_tmpl	option(nullable) tmpl,
										string 						name,	
										date option(nullable) 		trade_date,/**/
										date option(nullable) 		settle_date,/**/
										string option(nullable) 	spot_code,//not used for a template
										date option(nullable) 		start_date,/**/										
										string option(nullable) 	fwd_start_code,/**/
										date 	option(nullable)	maturity,/**/
										string 	option(nullable)	maturity_code,/**/
										number option(nullable)		sprd_vs_ois ,/**///if null --> will be set to par 									
										number 	option(nullable)	notional,
										number 	 option(nullable)	pv01,																									
										logical 					pay_float,
										..disc_func option(nullable) df_disc_func,
										fwd_func option(nullable) 	flt_fwd_func,
										..disc_func option(nullable) flt_fwd_disc_func,
										fwd_func option(nullable) 	ois_fwd_func,
										..disc_func option(nullable) ois_fwd_disc_func,
										number option(nullable) 	flt_curr_fix,									
										integer 					sprd_rnd_dec,// < 0 --> no rounding
										error_info option(nullable) error )
	{	
		try{
			QL_FAIL_COND(!null(flt_fwd_func) && !null(flt_fwd_disc_func),"ambigious input float leg (fwd_func/disc_func)");
			QL_FAIL_COND(!null(flt_fwd_func) && null(ois_fwd_func),"fwdfunc required for ois leg when float leg has a fwd_func");//for now, FIX_ME should be relaxed			
			QL_FAIL_COND(null(notional) && null(pv01), "one of notional and pv01 is required", E_INIT);
			
			CORE_SWAPLIB.fltois_parm fop = new CORE_SWAPLIB.fltois_parm();

			//update parm with init_static()
			if(!null(def)) {
				QL_REQUIRE(!def.swap_leg1_is_quote(error),"function requires the spread quote is vs ois leg");
				fop.init_static(def,spot_code);
			}
			else if(!null(sw_base)){
				QL_REQUIRE(!sw_base.leg1_is_quote(error),"function requires the spread quote is vs ois leg");
				fop.init_static(sw_base,spot_code);
			}
			else if(!null(tmpl)){
				//QL_REQUIRE(!tmpl.leg1_is_quote(error),"function requires the spread quote is vs ois leg");
				fop.init_static(tmpl);
			}
			else{
				QL_FAIL("err");
			}
			
			QL_FAIL_COND(fop.is_cross_currency(), "constructor not applicable for currency swap", E_INIT);
		
			//update parm with current input
			number pv01_not_unit  = 100000;//rounding unit for notional when implied from pv01

			fop.set_plain_single_ccy(name,trade_date,settle_date,start_date,fwd_start_code,maturity ,maturity_code,
										 pay_float, sprd_rnd_dec,pv01_not_unit,notional,pv01,
										 0, flt_curr_fix, sprd_vs_ois);

			logical sync_endog_ok = true;
			swap_fltois swap;
			if(!null(flt_fwd_func))
				swap 	= fop.create_swap( df_disc_func, flt_fwd_func, null, df_disc_func , ois_fwd_func, ois_fwd_disc_func,sync_endog_ok);
			else
				swap 	= fop.create_swap( df_disc_func, null, flt_fwd_disc_func, df_disc_func, ois_fwd_func,ois_fwd_disc_func,sync_endog_ok);

			return swap;
			
							
		}
		catch {
			CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois_plain");
			return null<swap_fltois>;
		}
	}
			
	
}
/*-----------------------------------------------------------------------
  func: swap_fltois_plain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois_plain(	instr_def 					def,
								string 						instrument_name,	
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								string option(nullable) 	spot_settle_code,
								date option(nullable) 		start_date,			//start_date has precedence over fwd_start_code
								string option(nullable) 	fwd_start_code,
								date option(nullable)		maturity,			//maturity has precedence over mat_code
								string 	option(nullable)	maturity_code,																													
								number option(nullable)		sprd_vs_ois ,//if null --> will be set to par 									
								number 	option(nullable)	notional,
								number 	option(nullable)	pv01,
								logical 					pay_float,
								..disc_func option(nullable) disc_func,			//disc for both legs (single curr)						
								fwd_func option(nullable) 	flt_fwd_func,		//float leg fwd func
								disc_func option(nullable) 	ois_fwd_disc_func,		//ois leg fwd disc func
							    number option(nullable) 	flt_curr_fix,							    
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{
	integer sprd_rnd_dec = 0;
	return CORE_INT_FLTOIS.swap_fltois_plain_int(def,null,null,instrument_name,trade_date,settle_date,spot_settle_code,start_date,
												 fwd_start_code,maturity,maturity_code,
												 sprd_vs_ois ,notional,pv01, pay_float,
												 disc_func, flt_fwd_func, null, null, ois_fwd_disc_func,
												 flt_curr_fix, sprd_rnd_dec,error );
}

/*-----------------------------------------------------------------------
  func: swap_fltois_plain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois_plain(	swap_fltois 				sw,
								string 						instrument_name,	
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								string option(nullable) 	spot_settle_code,
								date option(nullable) 		start_date,			//start_date has precedence over fwd_start_code
								string option(nullable) 	fwd_start_code,
								date option(nullable)		maturity,			//maturity has precedence over mat_code
								string 	option(nullable)	maturity_code,																												
								number option(nullable)		sprd_vs_ois ,//if null --> will be set to par 									
								number 	 					notional,																										
								logical 					pay_float,
								..disc_func option(nullable) disc_func,		//disc for both legs (single curr)							
								fwd_func option(nullable) 	flt_fwd_func,	//float leg fwd func
								fwd_func option(nullable) 	ois_fwd_func,	//ois leg fwd func
							    number option(nullable) 	flt_curr_fix, 							   
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{
	integer sprd_rnd_dec = 0;
	return CORE_INT_FLTOIS.swap_fltois_plain_int(null,sw,null,instrument_name,trade_date,settle_date,spot_settle_code,start_date,fwd_start_code,maturity,maturity_code,
												 sprd_vs_ois ,notional, null,pay_float,disc_func,flt_fwd_func, null,ois_fwd_func, null<disc_func>,
												 flt_curr_fix,sprd_rnd_dec,error );
}

/*-----------------------------------------------------------------------
  func: swap_fltois_plain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois_plain(	swap_fltois 				sw,
								string 						instrument_name,	
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								string option(nullable) 	spot_settle_code,
								date option(nullable) 		start_date,			//start_date has precedence over fwd_start_code
								string option(nullable) 	fwd_start_code,
								date option(nullable)		maturity,			//maturity has precedence over mat_code
								string 	option(nullable)	maturity_code,																												
								number option(nullable)		sprd_vs_ois ,//if null --> will be set to par 									
								number 	 					notional,																										
								logical 					pay_float,
								..disc_func option(nullable) disc_func,			//disc for both legs (single curr)						
								disc_func option(nullable) 	flt_fwd_disc_func,	//float leg fwd disc func
								disc_func option(nullable) 	ois_fwd_disc_func,
							    number option(nullable) 	flt_curr_fix,
							   
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{
	integer sprd_rnd_dec = 0;
	return CORE_INT_FLTOIS.swap_fltois_plain_int(null,sw,null,instrument_name,trade_date,settle_date,spot_settle_code,start_date,fwd_start_code,maturity,maturity_code,
												 sprd_vs_ois ,notional,null, pay_float,disc_func,null<fwd_func>, flt_fwd_disc_func,null<fwd_func>, ois_fwd_disc_func,
												 flt_curr_fix,sprd_rnd_dec,error );
}



/*-----------------------------------------------------------------------
  func: swap_fltois_plain
  minimal constructor for single curr "screen"-swap,
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois_plain(	instrument 					fltois_sw,															
								number 	 					notional,																										
								logical 					pay_float,
								..disc_func option(nullable) disc_func,		//disc for both legs (single curr)							
								fwd_func option(nullable) 	flt_fwd_func,
								fwd_func option(nullable) 	ois_fwd_func,
							    number option(nullable) 	flt_curr_fix,							    
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{
	error_info ee 			= new error_info(true,true);
	QL_FAIL_COND(fltois_sw.instr_type(ee) != instr_type.SWAP_FLTOIS, "invalid instrument type");
	swap_fltois sw 			= swap_fltois(fltois_sw,ee);
	string instrument_name 	= sw.name(ee);	
	date trade_date 		= sw.trade_date(ee);
	date settle_date 		= sw.settle_date(ee);
	date start_date 		= sw.issue_date(ee);
	string fwd_start_code	= null<string>;
	date maturity 			= sw.maturity(ee);			
	string maturity_code 	= null<string>;																												
	number sprd 			= sw.quote(ee)/10000.0;
	integer sprd_rnd_dec 	= 0;
	string spot_settle_code = sw.settle_code(ee);//assume swap is a screenswap with a spot settle code
	return CORE_INT_FLTOIS.swap_fltois_plain_int(null,sw,null,instrument_name,trade_date,settle_date,spot_settle_code,start_date,fwd_start_code,maturity,maturity_code,
												sprd ,notional, null,pay_float,disc_func,flt_fwd_func, null<disc_func>,ois_fwd_func, null<disc_func>,
												flt_curr_fix, sprd_rnd_dec,error );
}

/*-----------------------------------------------------------------------
  func: swap_fltois_plain
  cross ccy ok
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois_plain(	instr_def 					instr_def, 
								string 						name  ,	
								date option(nullable) 		trade_date ,		
								date option(nullable) 		settle_date ,
								string option(nullable) 	spot_settle_code,
								date  option(nullable) 		start_date,
								string  option(nullable)	fwd_start_code,
								date  option(nullable)		maturity,
								string  option(nullable)	maturity_code,
								//integer						cpn_roll_day,	//<----------------
								logical 					pay_float,			
								number 	option(nullable) 	fx_quote,			//required if instr_def is a cross curr
								string 	option(nullable) 	fx_quote_baseccy,	//required if instr_def is a cross curr
								string 	option(nullable) 	fx_quote_priceccy,	//required if instr_def is a cross curr
								logical option(nullable) 	pv_in_base_ccy,
								//flt
								stub_type option(nullable) 	flt_stub_type,
								date option(nullable) 		flt_eff_date,		
								date  option(nullable)		flt_first_cpn_date,	
					    		date  option(nullable)		flt_last_reg_date,													
								number 	option(nullable)	flt_notional,				
								number option(nullable) 	flt_curr_fix,									
								disc_func option(nullable)	flt_disc_func,						
								fwd_func  option(nullable)	flt_fwd_func,					
								vector(date) option(nullable) 	flt_fixing_dates,	
								vector(number) option(nullable) flt_fixing_rates,	
								//number option(nullable) first_fixing,
							    //number option(nullable) last_fixing,
							    number option(nullable) 	flt_fix_proxy, 			
							    logical  option(nullable) 	flt_allow_fwd_fix,
								//ois
								stub_type option(nullable) 		ois_stub_type,
								date option(nullable)  			ois_eff_date,
								date option(nullable)  			ois_first_cpn_date,
								date option(nullable)  			ois_last_reg_date,
								number	option(nullable) 		ois_notional,
								number							ois_spread,	
								disc_func option(nullable)		ois_disc_func,						
								fwd_func  option(nullable)		ois_fwd_func,							
								vector(date) option(nullable) 	ois_fixing_dates ,	
								vector(number) option(nullable) ois_fixing_rates,
								number option(nullable) 		ois_fix_proxy ,
								logical option(nullable) 		ois_allow_fwd_fix,
								integer 						sprd_rnd_dec,// < 0 --> no rounding
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{	
	try{

		CORE_SWAPLIB.fltois_parm fop = new CORE_SWAPLIB.fltois_parm();

		QL_FAIL_COND(!null(flt_fwd_func) && null(ois_fwd_func),"fwd_func required for ois leg when float leg has a fwd_func");//for now, FIX_ME should be relaxed							
		QL_REQUIRE(!instr_def.swap_leg1_is_quote(error),"function requires the spread quote is vs ois leg");
		
		//update parm with init_static()
		fop.init_static(instr_def,spot_settle_code);

		//update parm with current input
		number pv01_not_unit  = 100000;//rounding unit for notional when implied from pv01
		number	leg_pv01 	= null;
		
		fop.set_plain(	name,trade_date,settle_date,start_date,fwd_start_code,maturity,maturity_code,pay_float,
						sprd_rnd_dec,pv01_not_unit,leg_pv01,
						fx_quote,fx_quote_baseccy,fx_quote_priceccy,pv_in_base_ccy,
						0, flt_stub_type, flt_eff_date, flt_first_cpn_date, flt_last_reg_date,
						flt_notional, flt_curr_fix,
						flt_fixing_dates ,	
						flt_fixing_rates,
						flt_fix_proxy ,
						flt_allow_fwd_fix,						
						ois_spread,
						ois_stub_type,ois_eff_date,ois_first_cpn_date,ois_last_reg_date,ois_notional,
						ois_fixing_dates ,ois_fixing_rates,ois_fix_proxy ,ois_allow_fwd_fix);

		logical sync_endog_ok 	= true;
		swap_fltois swap = fop.create_swap(flt_disc_func, flt_fwd_func,null, ois_disc_func, ois_fwd_func,null, sync_endog_ok);

		return swap;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois_plain");
		return null<swap_fltois>;
	}
}


/*-----------------------------------------------------------------------
  func: swap_fltois_plain (no instr_def)
  cross ccy ok
  ----------------------------------------------------------------------*/
swap_fltois swap_fltois_plain(	string 						name  ,
								date option(nullable) 		trade_date ,
								date option(nullable) 		settle_date ,
								string option(nullable)		spot_settle_code,
								date option(nullable) 		start_date,
								string  option(nullable)	fwd_start_code,
								date  option(nullable)		maturity,
								string  option(nullable)	maturity_code,
								logical 					pay_float,
								bd_convention				pmt_bus_day,
								calendar					pmt_calendar,
								logical						end_of_month,								
								notional_exchg_style option(nullable)  not_exchange,
								number 		option(nullable) 	fx_quote,
								string 		option(nullable) 	fx_quote_baseccy,
								string 		option(nullable) 	fx_quote_priceccy,
								logical 	option(nullable) 	pv_in_base_ccy,								
								//flt
								string							flt_currency,
								stub_type option(nullable) 		flt_stub_type,
								date option(nullable) 			flt_eff_date,
								date  option(nullable)			flt_first_cpn_date,
					    		date  option(nullable)			flt_last_reg_date,
								day_count_method				flt_day_count,
								interest_rule 					flt_ir_rule,
								ir_index 						flt_ir_index,
								integer 						flt_coupon_freq ,
								//sink_fund_style option(nullable) flt_sink_fund_style,	
								//vector(date) option(nullable) 	flt_sink_fund_dates,
								//vector(number) option(nullable) flt_sink_fund,
								number 	option(nullable) 		flt_notional,
									
								number option(nullable) 		flt_curr_fix,							
								disc_func option(nullable) 		flt_disc_func,	
								fwd_func option(nullable) 		flt_fwd_func,	
								vector(date) option(nullable) 	flt_fixing_dates,	
								vector(number) option(nullable) flt_fixing_rates,
								//number option(nullable) first_fixing,
							    //number option(nullable) last_fixing,
							    number option(nullable) 		flt_fix_proxy, 
							    logical  option(nullable) 		flt_allow_fwd_fix,
								//ois
								string							ois_currency,								
								stub_type option(nullable) 		ois_stub_type,
								date option(nullable) 			ois_eff_date,
								date  option(nullable)			ois_first_cpn_date,
					    		date  option(nullable)			ois_last_reg_date,
								day_count_method				ois_day_count,
								ir_index 						ois_ir_index,
								//--> include pmtdelay,endog,approx
								integer 						ois_coupon_freq ,
								//sink_fund_style option(nullable) ois_sink_fund_style,	
								//vector(date) option(nullable) 	ois_sink_fund_dates,
								//vector(number) option(nullable) ois_sink_fund,
								number 	option(nullable) 		ois_notional,								
								number							ois_spread,																	
								disc_func option(nullable) 		ois_disc_func,	
								fwd_func option(nullable) 		ois_fwd_func,	
								vector(date) option(nullable) 	ois_fixing_dates,	
								vector(number) option(nullable) ois_fixing_rates,								
							    number option(nullable) 		ois_fix_proxy, 
							    logical  option(nullable) 		ois_allow_fwd_fix,
								integer 						sprd_rnd_dec,// < 0 --> no rounding
								error_info option(nullable) 	error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex')
{	
	try{
		CORE_INT.reset_single(error);

		CORE_SWAPLIB.fltois_parm fop = new CORE_SWAPLIB.fltois_parm();
		logical is_ccy = !equal_casei(ois_currency, flt_currency);
		QL_FAIL_COND(is_ccy && null(flt_disc_func), "invalid float leg disc_func", E_INIT);

		//update parm with init_basic_static
		number ois_pmt_delay = 0;
		number flt_pmt_delay = 0;
		logical ois_endog_df = true;
		logical ois_approx_calc = true;
		//flt_comp_avg_type  ois_comp_avg_t 		= flt_comp_avg_type.CA_COMP;
		//flt_sprd_comp_method  ois_sprd_comp_m 	= flt_sprd_comp_method.SC_SPRD_EXCL;
		//flt_avg_method 	 ois_avg_m 				= flt_avg_method.AVG_UNWEIGHTED;
		avg_comp_method ois_comp_avg 		= avg_comp_method.COMP_SPRD_EXCL;
		rfr_arrears_type   ois_arr_type 	= rfr_arrears_type.PLAIN;
		number  ois_arr_days 				= 0;

		
		fop.init_static(spot_settle_code,pmt_bus_day,pmt_calendar,end_of_month,not_exchange,												
						flt_currency, false,flt_coupon_freq, flt_day_count, flt_ir_rule,flt_ir_index,
						flt_pmt_delay,flt_pmt_delay,null ,								
						ois_currency, false,ois_coupon_freq, ois_day_count,
						interest_rule.IR_ADJ,ois_ir_index,
						ois_comp_avg, ois_arr_type ,ois_arr_days,
						ois_pmt_delay,ois_pmt_delay,
						ois_endog_df,ois_approx_calc);
		//fifl.imp_fix_rate_dec  = fix_r_rnd_dec;//rounding decimals of the implied cpn rate (on decimal value)
		//fifl.pv01_not_unit  = 100000;//rounding unit for notional when implied from pv01
				
		number	leg_pv01 = null;
		fop.set_plain(	name,trade_date, settle_date, start_date,fwd_start_code,maturity, maturity_code,pay_float,
						-1,-1,leg_pv01,fx_quote,fx_quote_baseccy, fx_quote_priceccy,pv_in_base_ccy,
						0,flt_stub_type,flt_eff_date,flt_first_cpn_date,flt_last_reg_date, flt_notional, 
						flt_curr_fix, flt_fixing_dates , flt_fixing_rates, flt_fix_proxy , flt_allow_fwd_fix,						
						ois_spread,
						ois_stub_type,ois_eff_date,ois_first_cpn_date,ois_last_reg_date, ois_notional, 
						ois_fixing_dates , ois_fixing_rates, ois_fix_proxy , ois_allow_fwd_fix);
		

		logical sync_endog_ok 	= true;
		swap_fltois swap = fop.create_swap(flt_disc_func, flt_fwd_func, null,ois_disc_func , ois_fwd_func,null,sync_endog_ok);


		return swap;

						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois_plain");
		return null<swap_fltois>;
	}
}
/*-----------------------------------------------------------------------
  func: swap_fixois_comb
  ----------------------------------------------------------------------*/
swap_fixois swap_fixois_comb(	swap_fixflt 				sw_fixflt,
								swap_fltois 				sw_fltois,
								string 						instrument_name,																																					
								number option(nullable)		sprd_vs_ois ,																								   
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Fixed vs ONIndex')
{
	error_info ee 		= new error_info(true,true);
	//ql_float_leg flt 	= sw_fixflt.float_leg(false,ee);
	ql_fix_leg fix 		= sw_fixflt.fix_leg(true,ee);

	QL_REQUIRE(sw_fixflt.trade_date(ee) 			== sw_fltois.trade_date(ee),"float leg mismatch: trade_date");
	QL_REQUIRE(sw_fixflt.settle_date(ee) 			== sw_fltois.settle_date(ee),"float leg mismatch: settle_date");
	QL_REQUIRE(sw_fixflt.maturity(ee) 				== sw_fltois.maturity(ee),"float leg mismatch: maturity");
	QL_REQUIRE(sw_fixflt.coupon_freq_flt_leg(ee) 	== sw_fltois.coupon_freq_flt_leg(ee),"float leg mismatch: coupon frequency");
	QL_REQUIRE(sw_fixflt.reset_freq_flt_leg(ee) 	== sw_fltois.reset_freq_flt_leg(ee),"float leg mismatch: reset frequency");
	QL_REQUIRE(sw_fixflt.spread_flt_leg(ee) 		== sw_fltois.spread_flt_leg(ee),"float leg mismatch: float spread");
	QL_REQUIRE(sw_fixflt.currency_flt_leg(ee) 		== sw_fltois.currency_flt_leg(ee),"float leg mismatch: currency");
	//compare float leg
	//ql_float_leg flt_o 	= sw_fltois.float_leg(false,ee);
	ql_ois_leg ois 		= sw_fltois.ois_leg(true,ee);
	
	ql_fixed_income_swap qlsw = ql_fixed_income_swap(fix,ois,instrument_name);
	swap_fixois sw 		= swap_fixois(qlsw, ee);
	sw.set_spread_ois_leg(sprd_vs_ois,ee);

	return sw;
}