option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
		swap_fltois2s create funcs
	--------------------------------------------------------------------			
*/

//--------
// from db
//--------

/*-----------------------------------------------------------------------
  swap_fltois2s
  ----------------------------------------------------------------------*/
swap_fltois2s swap_fltois2s(	instrument_name 			instrument_name, 
								date option(nullable) 		trade_date 	= null<date>,
								string option(nullable) 	quote_side 	= null<string>,
								error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex (2-swap)')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_swap_fltois2s(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s");
		return null<swap_fltois2s>;
	}
}

/*-----------------------------------------------------------------------
  swap_fltois2s
  ----------------------------------------------------------------------*/
swap_fltois2s swap_fltois2s(instrument_name 			instrument_name, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex (2-swap)')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_swap_fltois2s(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s");
		return null<swap_fltois2s>;
	}
}


/*-----------------------------------------------------------------------
  swap_fltois2s
  ----------------------------------------------------------------------*/
swap_fltois2s swap_fltois2s(instr_def 					instr_def, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex (2-swap)')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_swap_fltois2s(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s");
		return null<swap_fltois2s>;
	}
}
/*-----------------------------------------------------------------------
  swap_fltois2s
  ----------------------------------------------------------------------*/
swap_fltois2s swap_fltois2s(instr_def 					instr_def, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Float vs ONIndex (2-swap)')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_swap_fltois2s(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fltois2s");
		return null<swap_fltois2s>;
	}
}