/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström	

	-----------------
	 fra create funcs	
	-----------------		
*/

option(null: hard);	

//--------
// from db
//--------

/*-----------------------------------------------------------------------
  fra
  ----------------------------------------------------------------------*/
fra fra(instrument_name 			instrument_name, 
		date option(nullable) 		trade_date 	= null<date>,
		string option(nullable) 	quote_side 	= null<string>,					
		error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Fra')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_fra(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra");
		return null<fra>;
	}
}

/*-----------------------------------------------------------------------
  fra
  ----------------------------------------------------------------------*/
fra fra(instrument_name 			instrument_name, 
		date option(nullable) 		trade_date ,
		number  option(nullable) 	quote ,				
		error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Fra')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote,null<date> );
		return create_fra(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra");
		return null<fra>;
	}
}

/*-----------------------------------------------------------------------
  fra
  ----------------------------------------------------------------------*/
fra fra(instr_def 					instr_def, 
		date option(nullable) 		trade_date 	= null<date>,
		string option(nullable) 	quote_side 	= null<string>,			
		error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Fra')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_fra(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra");
		return null<fra>;
	}
}
/*-----------------------------------------------------------------------
  fra
  ----------------------------------------------------------------------*/
fra fra(instr_def 					instr_def, 
		date option(nullable) 		trade_date ,
		number  option(nullable) 	quote ,				
		error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Fra')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_fra(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra");
		return null<fra>;
	}
}

//----------------
// from db or not
//----------------

//-----------------------------------------------------------------------
//	func: instrument_fra_nodb
//		arguments: 
//		instr_def: 	can be created either from the db or user defined 
//					no lookup of quotes 
//					instr_def is copied and modified
//		instrument_name: user defined name
//  ----------------------------------------------------------------------
fra fra(instr_def 					instr_def, 
		string 						instrument_name  ,
		date option(nullable) 		trade_date ,
		date  option(nullable) 		expiry_settle_date ,
		date  option(nullable) 		underl_maturity,
		number option(nullable) 	market_rate,//dec
		number 	option(nullable) 	contract_rate,//dec
		number 	option(nullable) 	nominal,
		//string 	idx_tenor,
		//number 	idx_value_days,
		error_info option(nullable) error		= null<error_info>) 
option (category: 'Instrument/Fra')
{	
	try{	
		//number nominal = null<number>;		
		__instrument c = __instrument_fra_nodb(instr_def,instrument_name,trade_date,expiry_settle_date,
											underl_maturity,market_rate, contract_rate,nominal/*,idx_tenor,
											idx_value_days*/ );
		return create_fra(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fra");
		return null<fra>;
	}
}

//-----------------------------------------------------------------------
//	func: 
//		arguments: 
//		instr_def: 	can be created either from the db or user defined 
//					no lookup of quotes 
//					instr_def is copied and modified
//  ----------------------------------------------------------------------
/*fra fra(	instr_def 				instr_def, 
			string 					instrument_name  ,
			date option(nullable) 	trade_date ,
			string 					expiry_settle_code ,
			string   				underl_maturity_code,
			logical  				maturity_code_off_trade,
			number option(nullable) market_rate,//dec
			number 	option(nullable) contract_rate,//dec
			number 	option(nullable) nominal,
			//string 	idx_tenor,
			//number 	idx_value_days,	
			out instr_error option(nullable) error) 
option (category: 'Instrument/Fra')
{	
	try{	
		number nominal = null<number>;		
		__instrument c = __instrument_fra_nodb(instr_def,instrument_name,trade_date,expiry_settle_code,underl_maturity_code,
											maturity_code_off_trade,market_rate, contract_rate,nominal);
		return create_fra(c, error);						
	}
	catch {
		set_error(error,ERR_T_INIT,err.message());
		return null<fra>;
	}
}
*/

module CORE_INT
{
	/*-----------------------------------------------------------------------
	  Name :  	create_par_fra 
	  Notes :           
	  Changes:
	  			Date    		Who     Detail
	  			3-Aug-2016 		MN      for backward compat 
	  ----------------------------------------------------------------------*/
	fra create_par_fra(		day_count_method 	dc,
							bd_convention 		bd,
							logical 			eom,
							string 				tenor,
							integer 			fixing_days,
							calendar 			cal,   
							string 				currency,
							string				name, 
							date 				d, 
							date				settle,
							date 				mat,
							number				rate)
	
	{
		try{
			instr_def def 	= create_fra_instr_def(	dc,bd,eom,null<date>,null<string>,null<date>,null<string>,
													null<logical>,cal,currency, tenor,fixing_days);
			error_info ee = error_info(true,true);
			fra f 	= ..fra(def, name,d,settle,mat,rate,null<number>,null<number>,ee);
			QL_FAIL_COND(null(f.rate(false,ee)),"invalid fra rate");							
			return f ;
		}
		catch {
			CORE_INT.write_warning_message(err.message());
			return null<fra>;
		}
	}
	
	/*-----------------------------------------------------------------------
	  Name :  	create_par_fra 
	  Notes :           
	  Changes:
	  			Date    		Who     Detail
	  			3-Aug-2016 		MN      for backward compat
	  ----------------------------------------------------------------------*/
	fra create_par_fra(	instr_def 			def,
						string				name, 
						date 				d, 
						date				settle,
						date 				mat,
						number				rate/*,
						string				tenor,
						number 				fixing_days*/)
	
	{
		try{
			error_info ee = error_info(true,true);
			fra f 	= ..fra(def, name,d,settle,mat,rate,null<number>,null<number>,ee);							
			QL_FAIL_COND(null(f.rate()),"invalid fra rate");			
			return f ;
		}
		catch {
			CORE_INT.write_warning_message(err.message());
			return null<fra>;
		}
	}
	//-------------------------------------------------------
	// create_class_fra
	//-------------------------------------------------------
	instrument create_class_fra(string 	class_name, 
								date 	d)
	{
		error_info ee = error_info(true,true);
		instr_def def = instr_def(class_name);
		calendar cal = def.calendar(0,ee);
		date settle = cal.adjust_date (d+2, BD_FOLLOWING);
		date mat = cal.adjust_date (settle +15, BD_FOLLOWING);
		instrument f = fra(def, "", d, settle, mat,0.01,null<number>,null<number>,ee);
		return f;
	}
}





