/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	-----------------
	 frn create funcs	
	-----------------			
*/

option(null: hard);	



//--------
// from db
//--------


/*-----------------------------------------------------------------------
  frn  (from name)
	arguments:
	instrument_name: name as in db
  ----------------------------------------------------------------------*/
frn  frn (	instrument_name			instrument_name, 							
			date option(nullable) 	trade_date ,
			string option(nullable) quote_side ,
			number option(nullable) disc_rate_next ,
			number option(nullable) assumed_index_rate ,
			date option(nullable) 	settle_date 	= null<date>,
			error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Frn')
option(com_name: 'frn_db_qs')
{	
	try{			
		__instrument c = __instrument_frn(	instrument_name,trade_date,quote_side,disc_rate_next,
										assumed_index_rate,settle_date);
		return create_frn( c, error);				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn");
		return null<frn>;
	}
}

/*-----------------------------------------------------------------------
  frn  (from name)
	arguments:
	instrument_name: name as in db
  ----------------------------------------------------------------------*/
frn  frn (	instrument_name			instrument_name, 							
			date option(nullable) 	trade_date ,
			number option(nullable) quote,
			number option(nullable) disc_rate_next ,
			number option(nullable) assumed_index_rate ,
			date option(nullable) 	settle_date 	= null<date>,
			error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Frn')
option(com_name: 'frn_db')
{	
	try{			
		__instrument c = __instrument_frn(	instrument_name,trade_date,quote,disc_rate_next,
										assumed_index_rate,settle_date);
		return create_frn( c, error);				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn");
		return null<frn>;
	}
}


/*-----------------------------------------------------------------------
  frn  (from def)
	arguments:
	instr_def: 	can be created from the db or user defined and is not modified, 
				a quote can only be initialized if the instr_def is from the db
  ----------------------------------------------------------------------*/
frn  frn (	instr_def 				instr_def, 							
			date option(nullable) 	trade_date ,
			string option(nullable) quote_side ,
			number option(nullable) disc_rate_next ,
			number option(nullable) assumed_index_rate ,
			date option(nullable) 	settle_date 	= null<date>,
			error_info option(nullable) error		= null<error_info>)
option (category: 'Curve and Instrument/Frn')
option(com_name: 'frn_from_def_qs')
{	
	try{			
		__instrument c = __instrument_frn(	instr_def,trade_date,quote_side,disc_rate_next,
										assumed_index_rate,settle_date);
		return create_frn( c, error);				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn");
		return null<frn>;
	}
}
/*-----------------------------------------------------------------------
  frn  (from def)
	arguments:
	instr_def: 	can be created from the db or user defined and is not modified, 
				a quote can only be initialized if the instr_def is from the db
  ----------------------------------------------------------------------*/
frn  frn (	instr_def 				instr_def, 							
			date option(nullable) 	trade_date ,
			number option(nullable) quote,
			number option(nullable) disc_rate_next ,
			number option(nullable) assumed_index_rate ,
			date option(nullable) 	settle_date 	= null<date>,
			error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Frn')
option(com_name: 'frn_from_def')
{	
	try{			
		__instrument c = __instrument_frn(	instr_def,trade_date,quote,disc_rate_next,
										assumed_index_rate,settle_date);
		return create_frn( c, error);				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn");
		return null<frn>;
	}
}

//----------------
// from db or not
//----------------

/*-----------------------------------------------------------------------
  func: frn
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name
  ----------------------------------------------------------------------*/
frn frn(	instr_def 				instr_def, 
			string 					instrument_name  ,			
			date  					issue_date,			
    		date  option(nullable)	first_cpn_date,
    		date  option(nullable)	last_reg_cpn_date,
			date  					maturity,
			integer					roll_day,
			number					fix_margin,
			date option(nullable) 	trade_date ,
			date option(nullable) 	settle_date ,
			number option(nullable) quote ,
			quote_style option(nullable) quote_style ,
			number option(nullable) disc_rate_next ,
			number option(nullable) assumed_index_rate ,		
			number 	option(nullable) nominal,
			vector(date) option(nullable) fixing_dates,	
			vector(number) option(nullable) fixing_rates,
			number option(nullable) first_fixing,
		    number option(nullable) last_fixing,
		    number option(nullable) fix_proxy_hist,
			number option(nullable) fix_proxy_fwd,
		    logical  option(nullable) allow_fwd_fix = false,
			error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Frn')
option(com_name: 'frn_from_def_arg')
{	
	try{			
		__instrument c = __instrument_frn_nodb(instr_def,instrument_name,issue_date,first_cpn_date,last_reg_cpn_date,
												maturity,roll_day,fix_margin,trade_date,settle_date,quote,quote_style,disc_rate_next,assumed_index_rate,nominal,
												fixing_dates,fixing_rates,first_fixing,  last_fixing, fix_proxy_hist,fix_proxy_fwd,  allow_fwd_fix );

		return create_frn( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn");
		return null<frn>;
	}
}


/*-----------------------------------------------------------------------
  func: frn
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name
  ----------------------------------------------------------------------*/
frn frn(	instr_def 				instr_def, 
			string 					instrument_name  ,			
			date option(nullable) 	trade_date ,
			date option(nullable) 	settle_date ,
			number option(nullable) quote ,
			quote_style option(nullable) quote_style ,
			number option(nullable) disc_rate_next ,
			number option(nullable) assumed_index_rate ,		
			number 	option(nullable) nominal,
			vector(date) option(nullable) fixing_dates,	
			vector(number) option(nullable) fixing_rates,
			number option(nullable) first_fixing,
		    number option(nullable) last_fixing,
		    number option(nullable) fix_proxy_hist,
			number option(nullable) fix_proxy_fwd, 
		    logical  option(nullable) allow_fwd_fix = false,
			error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Frn')
option(com_name: 'frn_from_def_arg')
{	
	try{			
		__instrument c = __instrument_frn_nodb(instr_def,instrument_name,trade_date,settle_date,quote,quote_style,
											   disc_rate_next,assumed_index_rate,nominal, fixing_dates,fixing_rates,
											   first_fixing,  last_fixing, fix_proxy_hist,fix_proxy_fwd,  allow_fwd_fix );

		return create_frn( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "frn");
		return null<frn>;
	}
}
 
