/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	fxfwd create funcs
	--------------------------------------------------------------------			
*/

option(null: hard);	



//--------
// from db
//--------

/*-----------------------------------------------------------------------
  fx_fwd
  ----------------------------------------------------------------------*/
fx_fwd fx_fwd(	instrument_name 			instrument_name, 
				date option(nullable) 		trade_date 	= null<date>,
				string option(nullable) 	quote_side 	= null<string>,
				//date option(nullable) 		settle_date ,
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_fx_fwd(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_fwd");
		return null<fx_fwd>;
	}
}

/*-----------------------------------------------------------------------
  fx_fwd
  ----------------------------------------------------------------------*/
fx_fwd fx_fwd(	instrument_name 			instrument_name, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,
				//date option(nullable) 		settle_date ,
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_fx_fwd(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_fwd");
		return null<fx_fwd>;
	}
}

/*-----------------------------------------------------------------------
  fx_fwd
  ----------------------------------------------------------------------*/
fx_fwd fx_fwd(	instr_def 					instr_def, 
				date option(nullable) 		trade_date 	= null<date>,
				string option(nullable) 	quote_side 	= null<string>,
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_fx_fwd( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_fwd");
		return null<fx_fwd>;
	}
}

/*-----------------------------------------------------------------------
  fx_fwd
  ----------------------------------------------------------------------*/
fx_fwd fx_fwd(	instr_def 					instr_def, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,				
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_fx_fwd( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_fwd");
		return null<fx_fwd>;
	}
}
//----------------
// from db or not
//----------------

//-----------------------------------------------------------------------
//	func: instrument_fx_fwd_nodb
//		arguments: 
//		instr_def: 	can be created either from the db or user defined 
//					no lookup of quotes 
//					instr_def is copied and modified
//		instrument_name: user defined name
//  ----------------------------------------------------------------------
fx_fwd fx_fwd(instr_def 					instr_def, 
				string 						instrument_name  ,
				date option(nullable) 		trade_date ,
				date 						settle_date,						
				number 	option(nullable) 	quote,
				number 	option(nullable) 	base_ccy_nominal,				
				error_info option(nullable) error		= null<error_info>) 
option (category: 'Instrument/FX')
{	
	try{			
		__instrument c = __instrument_fxfwd_nodb(instr_def,instrument_name,trade_date,settle_date,
												quote,base_ccy_nominal);
		return create_fx_fwd(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_fwd");
		return null<fx_fwd>;
	}
}

//*********************************************************************************
// standalone funcs 
//*********************************************************************************

/*-----------------------------------------------------------------------
  Name :  	fx_cross_quote 
  ----------------------------------------------------------------------*/	
number fx_cross_quote(	fx_fwd		fxfwd1, 
						fx_fwd		fxfwd2,
						logical 	fxfwd2_is_base ,
						integer		cross_scale ,
						integer 	cross_decimals ,	
						logical 	cross_unit_quote ,	
						error_info option(nullable) error = null<error_info>)
option (category: 'Financial/FX')
{
	try {
		error_info e = new error_info(true,true);
		string base, price;
		number c = fxfwd1.cross_quote(null<number>,fxfwd2,null<number>,fxfwd2_is_base,
									  cross_scale,cross_decimals, cross_unit_quote,base, price,e  );
		return c ;
	}
	catch{
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_cross_quote");
		return null<number>;
	}
}


