/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	fxspot create funcs
	--------------------------------------------------------------------			
*/

option(null: hard);	


//--------
// from db
//--------

/*-----------------------------------------------------------------------
  fx_spot
  ----------------------------------------------------------------------*/
fx_spot fx_spot(instrument_name 			instrument_name, 
				date option(nullable) 		trade_date 	= null<date>,
				string option(nullable) 	quote_side 	= null<string>,
				//date option(nullable) 		settle_date ,
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_fx_spot(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot");
		return null<fx_spot>;
	}
}

/*-----------------------------------------------------------------------
  fx_spot
  ----------------------------------------------------------------------*/
fx_spot fx_spot(instrument_name 			instrument_name, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,
				//date option(nullable) 		settle_date ,
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_fx_spot(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot");
		return null<fx_spot>;
	}
}

/*-----------------------------------------------------------------------
  fx_spot
  ----------------------------------------------------------------------*/
fx_spot fx_spot(instr_def 					instr_def, 
				date option(nullable) 		trade_date 	= null<date>,
				string option(nullable) 	quote_side 	= null<string>,
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_fx_spot( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot");
		return null<fx_spot>;
	}
}

/*-----------------------------------------------------------------------
  fx_spot
  ----------------------------------------------------------------------*/
fx_spot fx_spot(	instr_def 				instr_def, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,				
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_fx_spot( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot");
		return null<fx_spot>;
	}
}

/*-----------------------------------------------------------------------
  fx_spot
  ----------------------------------------------------------------------*/
fx_spot fx_spot(string 						base_currency,
				string 						price_currency, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,					
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{	
		instrument_name name = CORE_INT_FX.fx_inst_name(base_currency, price_currency);			
		__instrument c = __instrument(name,trade_date,quote, null<date> );
		return create_fx_spot( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot");
		return null<fx_spot>;
	}
}

/*-----------------------------------------------------------------------
  fx_spot
  ----------------------------------------------------------------------*/
fx_spot fx_spot(string 						base_currency,
				string 						price_currency, 
				date option(nullable) 		trade_date 	= null<date>,
				string option(nullable) 	quote_side = null<string>,					
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{	
		instrument_name name = CORE_INT_FX.fx_inst_name(base_currency, price_currency);			
		__instrument c = __instrument(name,trade_date,quote_side, null<date> );
		return create_fx_spot( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot");
		return null<fx_spot>;
	}
}
//----------------
// from db or not
//----------------

//-----------------------------------------------------------------------
//	func: instrument_fx_spot_nodb
//		arguments: 
//		instr_def: 	can be created either from the db or user defined 
//					no lookup of quotes 
//					instr_def is copied and modified
//		instrument_name: user defined name
//  ----------------------------------------------------------------------
fx_spot fx_spot(instr_def 					instr_def, 
				string 						instrument_name  ,
				date option(nullable) 		trade_date ,		
				number 	option(nullable) 	quote,
				number 	option(nullable) 	base_ccy_nominal,				
				error_info option(nullable) error		= null<error_info>) 
option (category: 'Instrument/FX')
{	
	try{	
		//number nominal = null<number>;		
		__instrument c = __instrument_fxspot_nodb(instr_def,instrument_name,trade_date,quote,base_ccy_nominal);
		return create_fx_spot(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_spot");
		return null<fx_spot>;
	}
}


//*********************************************************************************
// standalone funcs 
//*********************************************************************************

/*-----------------------------------------------------------------------
  Name :  	fx_cross_quote 
  ----------------------------------------------------------------------*/	
fx_spot fx_cross_quote(	fx_spot		fxspot1, 
						fx_spot		fxspot2,
						logical 	fxspot2_is_base ,						
						error_info option(nullable) error = null<error_info>)
option (category: 'Financial/FX')
{
	try {
		error_info e = new error_info(true,true);
		fx_spot	cross;
		fxspot1.cross_quote(null<number>,fxspot2,null<number>,fxspot2_is_base, null<INSTR_TMPL.fx_spot_def_tmpl>,cross,e  );			
		return cross ;
	}
	catch{
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_cross_quote");
		return null<fx_spot>;
	}
}
/*-----------------------------------------------------------------------
  Name :  	fx_cross_quote 
  ----------------------------------------------------------------------*/	
fx_spot fx_cross_quote(	fx_spot		fxspot1, 
						fx_spot		fxspot2,
						logical 	fxspot2_is_base ,
						INSTR_TMPL.fx_spot_def_tmpl fx_tmpl,	
						error_info option(nullable) error = null<error_info>)
option (category: 'Financial/FX')
{
	try {
		error_info e = new error_info(true,true);
		fx_spot	cross;
		fxspot1.cross_quote(null<number>,fxspot2,null<number>,fxspot2_is_base, fx_tmpl,cross,e  );			
		return cross ;
	}
	catch{
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_cross_quote");
		return null<fx_spot>;
	}
}
/*-----------------------------------------------------------------------
  Name :  	fx_cross_quote 
  ----------------------------------------------------------------------*/	
number fx_cross_quote(	fx_spot		fxspot1, 
						fx_spot		fxspot2,
						logical 	fxspot2_is_base ,
						integer		cross_scale ,
						integer 	cross_decimals ,	
						logical 	cross_unit_quote,	
						error_info option(nullable) error = null<error_info>)
option (category: 'Financial/FX')
{
	try {
		error_info e = new error_info(true,true);
		string base, price;
		number c = fxspot1.cross_quote(null<number>,fxspot2,null<number>,fxspot2_is_base,
									   cross_scale,cross_decimals, cross_unit_quote,base, price,e  );
		return c ;
	}
	catch{
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_cross_quote");
		return null<number>;
	}
}



