/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	fxswap create funcs
	--------------------------------------------------------------------			
*/

option(null: hard);	


//--------
// from db
//--------

/*-----------------------------------------------------------------------
  fx_swap
  ----------------------------------------------------------------------*/
fx_swap fx_swap(instrument_name 			instrument_name , 
				date option(nullable) 		trade_date 	= null<date>,
				string option(nullable) 	quote_side 	= null<string>,
				//date option(nullable) 		settle_date ,
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{			
		__instrument c = __instrument(instrument_name ,trade_date,quote_side, null<date> );		
		return create_fx_swap(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap");
		return null<fx_swap>;
	}
}


/*-----------------------------------------------------------------------
  fx_swap
  ----------------------------------------------------------------------*/
fx_swap fx_swap(instrument_name 			instrument_name , 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,
				//date option(nullable) 		settle_date ,
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{				
		__instrument c = __instrument(instrument_name ,trade_date,quote, null<date> );
		return create_fx_swap(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap");
		return null<fx_swap>;
	}
}

/*-----------------------------------------------------------------------
  fx_swap
  ----------------------------------------------------------------------*/
fx_swap fx_swap(instr_def 					instr_def, 
				date option(nullable) 		trade_date 	= null<date>,
				string option(nullable) 	quote_side 	= null<string>,
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_fx_swap( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap");
		return null<fx_swap>;
	}
}

/*-----------------------------------------------------------------------
  fx_swap
  ----------------------------------------------------------------------*/
fx_swap fx_swap(instr_def 					instr_def, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,				
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/FX')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_fx_swap( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap");
		return null<fx_swap>;
	}
}

//----------------
// from db or not
//----------------

//-----------------------------------------------------------------------
//	func: instrument_fx_swap_nodb
//		arguments: 
//		instr_def: 	can be created either from the db or user defined 
//					no lookup of quotes 
//					instr_def is copied and modified
//		instrument_name: user defined name
//  ----------------------------------------------------------------------
fx_swap fx_swap(instr_def 					instr_def, 
				string 						instrument_name  ,
				date option(nullable) 		trade_date ,
				date option(nullable)		first_settle_date,
				date  option(nullable) 		maturity,//maturity has precedence over mat_code
				string option(nullable) 	maturity_code,		
				number 	option(nullable) 	quote,
				number 	option(nullable) 	base_ccy_nominal,				
				error_info option(nullable) error		= null<error_info>) 
option (category: 'Instrument/FX')
{	
	try{
		if(null(base_ccy_nominal)) base_ccy_nominal = 100;
		
		__instrument c;

		if(!null(maturity))
			c = __instrument_fxswap_nodb(	instr_def,instrument_name,trade_date,first_settle_date,
											maturity,quote,base_ccy_nominal);
		else
			c = __instrument_fxswap_nodb(	instr_def,instrument_name,trade_date,first_settle_date,
											maturity_code,quote,base_ccy_nominal);
		
		return create_fx_swap(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "fx_swap");
		return null<fx_swap>;
	}
}



