/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	generic create funcs
	--------------------------------------------------------------------			
*/

option(null: hard);	


//--------
// from db
//--------
/*-----------------------------------------------------------------------
  generic
  ----------------------------------------------------------------------*/
generic generic(instrument_name 			instrument_name, 
				date option(nullable) 	trade_date 	= null<date>,
				string option(nullable) quote_side 	= null<string>,
				date option(nullable) 	settle_date = null<date>,
				error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Generic")
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, settle_date );		
		return create_generic(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "generic");
		return null<generic>;
	}
}


/*-----------------------------------------------------------------------
  generic
  ----------------------------------------------------------------------*/
generic generic(instrument_name 			instrument_name, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,
				date option(nullable) 		settle_date= null<date> ,
				error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Generic")
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, settle_date );
		return create_generic(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "generic");
		return null<generic>;
	}
}


/*-----------------------------------------------------------------------
  generic
  ----------------------------------------------------------------------*/
generic generic(instr_def 					instr_def, 
				date option(nullable) 	trade_date 	= null<date>,
				string option(nullable) quote_side 	= null<string>,
				date option(nullable) 	settle_date = null<date>,
				error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Generic")
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, settle_date );
		return create_generic(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "generic");
		return null<generic>;
	}
}
/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
generic generic(instr_def 					instr_def, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,
				date option(nullable) 		settle_date = null<date>,
				error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Generic")
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, settle_date );
		return create_generic(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "generic");
		return null<generic>;
	}
}

