/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	il_il_bond create funcs
	--------------------------------------------------------------------			
*/

option(null: hard);	


//--------
// from db
//--------
/*-----------------------------------------------------------------------
  il_bond
  ----------------------------------------------------------------------*/
il_bond il_bond(instrument_name 			instrument_name, 
				date option(nullable) 	trade_date 	= null<date>,
				string option(nullable) quote_side 	= null<string>,
				date option(nullable) 	settle_date = null<date>,
				error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Bond")
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, settle_date );		
		return create_il_bond(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "il_bond");
		return null<il_bond>;
	}
}

/*-----------------------------------------------------------------------
  il_bond
  ----------------------------------------------------------------------*/
il_bond il_bond(instrument_name 			instrument_name, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,
				date option(nullable) 		settle_date = null<date>,
				error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Bond")
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, settle_date );
		return create_il_bond(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "il_bond");
		return null<il_bond>;
	}
}


/*-----------------------------------------------------------------------
  il_bond
  ----------------------------------------------------------------------*/
il_bond il_bond(instr_def 					instr_def, 
				date option(nullable) 	trade_date 	= null<date>,
				string option(nullable) quote_side 	= null<string>,
				date option(nullable) 	settle_date = null<date>,
				error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Bond")
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, settle_date );
		return create_il_bond(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "il_bond");
		return null<il_bond>;
	}
}
/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
il_bond il_bond(instr_def 					instr_def, 
				date option(nullable) 		trade_date ,
				number  option(nullable) 	quote ,
				date option(nullable) 		settle_date= null<date> ,
				error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Bond")
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, settle_date );
		return create_il_bond(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "il_bond");
		return null<il_bond>;
	}
}

//----------------
// from db or not
//----------------

/*-----------------------------------------------------------------------
  func: il_bond
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name
  ----------------------------------------------------------------------*/
il_bond il_bond(instr_def 				instr_def, 
				string 					instrument_name  ,			
				date  					issue_date,
				date  option(nullable)	cpn_start_date,
	    		date  option(nullable)	first_cpn_date,
	    		date  option(nullable)	last_reg_cpn_date,
				date  					maturity,
				number option(nullable)	coupon,
				date option(nullable) 	trade_date ,
				date option(nullable) 	settle_date ,
				number option(nullable) quote ,
				quote_style option(nullable) quote_style,
				cpi_link 				cpi_link,
				number 					cpi_base,
				number 	option(nullable) nominal = 100,
				error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Bond")
{	
	try{			
		__instrument c = __instrument_bondil_nodb(instr_def,instrument_name,issue_date,cpn_start_date,first_cpn_date,last_reg_cpn_date,
												maturity,coupon,trade_date,settle_date,quote,quote_style,cpi_link, cpi_base,nominal );

		return create_il_bond( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "il_bond");
		return null<il_bond>;
	}
}
 




