option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	swap_il_rr_fixflt create funcs
	--------------------------------------------------------------------			
*/


//--------
// from db
//--------
/*-----------------------------------------------------------------------
  swap_il_rr_fixflt
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt(instrument_name 			instrument_name, 
									date option(nullable) 	trade_date 	= null<date>,
									string option(nullable) quote_side 	= null<string>,
									error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Fixed vs Float")
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_swap_il_rr_fixflt(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt");
		return null<swap_il_rr_fixflt>;
	}
}


/*-----------------------------------------------------------------------
  swap_il_rr_fixflt
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt(instrument_name 			instrument_name, 
									date option(nullable) 		trade_date ,
									number  option(nullable) 	quote ,
									error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Fixed vs Float")
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_swap_il_rr_fixflt(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt");
		return null<swap_il_rr_fixflt>;
	}
}


/*-----------------------------------------------------------------------
  swap_il_rr_fixflt
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt(instr_def 				instr_def, 
									date option(nullable) 	trade_date 	= null<date>,
									string option(nullable) quote_side 	= null<string>,
									error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Fixed vs Float")
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_swap_il_rr_fixflt(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt");
		return null<swap_il_rr_fixflt>;
	}
}
/*-----------------------------------------------------------------------
  swap_il_rr_fixflt
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt(instr_def 					instr_def, 
									date option(nullable) 		trade_date ,
									number  option(nullable) 	quote ,
									error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Fixed vs Float")
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_swap_il_rr_fixflt(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt");
		return null<swap_il_rr_fixflt>;
	}
}

//----------------
// from db or not
//----------------


/*-----------------------------------------------------------------------
  func: swap_il_rr_fixflt
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name

  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt(instr_def 				instr_def, 
										string 					instrument_name  ,
										date option(nullable) 	trade_date ,
										date option(nullable) 	settle_date ,							
										date  option(nullable) 	maturity,//maturity has precedence over mat_code
										string option(nullable) maturity_code,
										number option(nullable)	fix_rate,
										..cpi_link				cpi_link,
										..cpi_link	option(nullable)	cpi_link_fcast,
										//number					cpi_base,						
										number 					nominal=100,
										error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{	
	try{
		__instrument c;
		if(!null(maturity))
			c = __instrument_il_fixflt_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity,fix_rate,cpi_link,cpi_link_fcast,nominal );
		else if(!null(maturity_code))
			c = __instrument_il_fixflt_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity_code,fix_rate,cpi_link,cpi_link_fcast,nominal );
		else
			QL_FAIL("invalid maturity/maturity_code");		
		return create_swap_il_rr_fixflt( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt");
		return null<swap_il_rr_fixflt>;
	}
}

//----------------
// no db, swaplib version
// an external swap is created. Note: an external swap has no internal instr_def
// but can be created from an instr_def
//----------------

/*-----------------------------------------------------------------------
  func: swap_il_rr_fixflt
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt(ql_fixed_income_swap ql_fixed_income_swap,
						error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{	
	try{	
		QL_FAIL_COND(CORE_INT.swap_instr_type(ql_fixed_income_swap) != instr_type.IL_SWAP_REAL_FIXFLT, "invalid instrument type", E_INIT);

		__instrument c = __instrument_swap(ql_fixed_income_swap);

		return create_swap_il_rr_fixflt(c, error);				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt");
		return null<swap_il_rr_fixflt>;
	}
}


/*-----------------------------------------------------------------------
  func: swap_il_rr_fixflt
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt(ql_fix_infl_ci_leg 		ql_fix_leg, 							
									ql_float_leg 			ql_float_leg,
									string 					id,
									error_info option(nullable) error = null<error_info>)
option (category: 'Curve and Instrument/Inflation Linked/Real Rate Fixed vs Float')
{	
	try{			
		__instrument c = __instrument_swap(ql_fix_leg,ql_float_leg,id);

		return create_swap_il_rr_fixflt(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt");
		return null<swap_il_rr_fixflt>;
	}
}


module CORE_INT_IL_FIXFLT
{
	/*-----------------------------------------------------------------------
	  func: swap_il_rr_fixflt_plain_int
	  minimal constructor for single curr "screen"-swap,
	  ----------------------------------------------------------------------*/
	swap_il_rr_fixflt swap_il_rr_fixflt_plain_int(instr_def 					def,
												string 						instrument_name,	
												date option(nullable) 		trade_date,	
												date option(nullable) 		start_date,
												string option(nullable) 	fwd_start_code,
												date 	option(nullable)	maturity,
												string 	option(nullable)	maturity_code,
												number option(nullable)		fix_coupon_rate ,//if null --> will be set to par 									
												number 	 					notional,																										
												logical 					pay_fixed,
												cpi_link 					cpi_l ,
												cpi_link option(nullable)	cpi_l_f,
												..disc_func option(nullable) fix_disc_func,
												..disc_func option(nullable) flt_disc_func,								
												fwd_func option(nullable) 	flt_fwd_func,
												..disc_func option(nullable) flt_fwd_disc_func,
												number option(nullable) 	curr_fix,
												integer fix_r_rnd_dec,
												error_info option(nullable) error )
	{	
		try{
			CORE_INT.reset_single(error);
			QL_FAIL_COND(!def.is_il_rr_swap_fixflt(), "instr_def not a real rate fix-float swap", E_INIT);
			logical is_ccy				= def.is_ccy_swap();
			QL_FAIL_COND(is_ccy, "constructor not applicable for currency swap", E_INIT);
			
			//---def---
			error_info ee = error_info(true,true);
			notional_exchg_style ne = def.swap_not_exchange(ee);

			if(null(ne))
				ne 	= is_ccy ? NE_BOTH : NE_END;
			
			date_code settle_code 		= date_code(def.settle_code());		
			coupon_freq  fix_cpn_freq 	= coupon_freq_from_int(def.coupon_freq(ee))  ;		
			calendar pmt_calendar		= def.swap_calendar_leg1(ee);
			bd_convention pmt_bus_day 	= def.swap_pmt_bus_day_leg1(ee);
			logical	end_of_month		= def.swap_eom_leg1(ee);
			fix_roll_method	rm			= fix_roll_method.FIR_STRAIGHT;
						
			number pmt_delay			= def.swap_pmt_lag_leg1(ee);
			number mat_pmt_delay		= pmt_delay;
			infl_index_method index_method = def.il_index_method(ee);
			
			logical constant_coupon 	= false ;
			fix_comp_freq compound_freq = null<fix_comp_freq>;
			quote_style qs 				= null<quote_style>;	
			round_code pv_round_code	= null<round_code>;
			logical start_stub_decomp 	= null<logical> ;
			logical end_stub_decomp 	= null<logical> ;
			interest_rule ir_rule 		= null<interest_rule>;						
			logical average_notional 	= null<logical> ;
			logical compound_to_mat 	= null<logical> ;			
			logical redemp_par 			= null<logical>;

			ql_swap_fix_infl_ci_def fix_def 	= ql_swap_fix_infl_ci_def("ci_fix_def", def.swap_currency_leg1(ee), settle_code, fix_cpn_freq,
																			def.swap_dc_method_leg1(ee),rm, pmt_bus_day,pmt_calendar,	
																			end_of_month,constant_coupon, compound_freq,qs,pv_round_code,
																			start_stub_decomp, end_stub_decomp,ir_rule,pmt_delay, mat_pmt_delay,
																			ne,average_notional,compound_to_mat, index_method,redemp_par);
			
			flt_reset_style reset_style = RS_NORM;
			coupon_freq  flt_cpn_freq 	= coupon_freq_from_int(def.swap_coupon_freq_leg2(ee))  ;
			reset_freq  flt_r_freq 		= reset_freq_from_int(def.swap_reset_freq_leg2(ee))  ;
			ir_index flt_ir_index 		= def.swap_ir_index_leg2(ee);
			flt_comp_avg_type flt_ca_t	= def.swap_comp_avg_type_leg2(ee);
			flt_sprd_comp_method flt_comp_m = def.swap_sprd_comp_method_leg2(ee);
			flt_avg_method flt_avg 		= def.swap_avg_method_leg2(ee);
			flt_stub_fwd_style	flt_stub_style = null; //FIX_ME
			
			ql_swap_float_def flt_def 	= ql_swap_float_def("float_def",def.swap_currency_leg2(ee),settle_code,
															flt_cpn_freq,flt_r_freq,def.swap_dc_method_leg2(ee),pmt_bus_day,
															pmt_calendar,end_of_month, flt_ca_t,flt_comp_m,flt_avg,flt_stub_style,
															flt_ir_index,reset_style,ne);

			//---leg---
			
			date  fix_eff_date 		= null<date>;
			date  flt_eff_date 		= null<date>;
			date  fix_first_cpn_date = null<date>;
			date  fix_last_reg_date = null<date>;
			date  flt_first_cpn_date = null<date>;
			date  flt_last_reg_date = null<date>;
			number	flt_spread 		= 0;		
			integer	cpn_roll_day 	= 0;			
			number fix_notional		= notional;
			number flt_notional		= notional;
			number fix_fx_rate 		= 1;
			number flt_fx_rate 		= 1;
			vector(date) fixing_dates = null<vector(date)>;	
			vector(number) fixing_rates= null<vector(number)>;
			number fix_proxy 		= curr_fix;
			logical  allow_fwd_fix	= false;
			
			date settle_date;
			CORE_INT_SWAPLIB.swap_start_date_helper(settle_code,trade_date,pmt_calendar,fwd_start_code,true,start_date,settle_date);
			QL_FAIL_COND(null(settle_date),"invalid start date", E_INIT);

			tenor_code mat_code = CORE_INT_SWAPLIB.swap_maturity_helper(def,maturity, maturity_code);	
			
			if(null(fix_fx_rate)) 
				fix_fx_rate = 1;

			number init_rate 			= null(fix_coupon_rate) ? 0 : fix_coupon_rate;	
			ql_fix_infl_ci_leg fix 		= ql_fix_infl_ci_leg(fix_def,"ci_fix_leg",trade_date,settle_date,start_date,maturity,mat_code,
															pay_fixed,fix_notional,fix_eff_date, fix_first_cpn_date,fix_last_reg_date,
															 init_rate, fix_disc_func,cpi_l,cpi_l_f,cpn_roll_day,fix_fx_rate);

			//OBS! if effective date for the legs is different we need to think about fix_notional vs flt_notional
			
			if(null(flt_notional) && !is_ccy) 
				flt_notional = fix_notional;
			if(null(flt_fx_rate)) 
				flt_fx_rate = 1;

			logical allow_extrap = false;
			tenor_surface flt_tenor_surface;
			try{
				if(!null(flt_fwd_func))
					flt_tenor_surface = tenor_surface(trade_date, flt_disc_func,[flt_fwd_func],[flt_ir_index],allow_extrap);
				else
					flt_tenor_surface = tenor_surface(trade_date, flt_disc_func,[flt_fwd_disc_func],[flt_ir_index],allow_extrap);
			}
			catch {
				flt_tenor_surface = null<tenor_surface>;
			}

			number flt_fixing_start_stub = null;
			number flt_start_stub_sprd = null;
			number flt_fixing_end_stub = null;
			number flt_end_stub_sprd = null;
			number flt_comp_spread = null;
		
			ql_float_leg flt 		= ql_float_leg(	flt_def,"float_leg",trade_date,settle_date,start_date,maturity,mat_code,
													!pay_fixed,flt_notional,flt_eff_date,flt_first_cpn_date,flt_last_reg_date,
													flt_spread,flt_disc_func, flt_tenor_surface,cpn_roll_day,flt_fx_rate,
													fixing_dates,fixing_rates,fix_proxy,allow_fwd_fix,
													flt_fixing_start_stub,flt_start_stub_sprd,flt_fixing_end_stub,flt_end_stub_sprd,flt_comp_spread);
			
			ql_fixed_income_swap sw = ql_fixed_income_swap(fix,flt,instrument_name);

			if(null(fix_coupon_rate)) {
				number fix_r	= sw.solver(0,swap_solver_code.SS_FIX_RATE_LEG1,false);
				QL_FAIL_COND(null(fix_r),"error solving for fixed coupon rate", E_INIT);
				if(fix_r_rnd_dec >= 0)
					fix_r = round(fix_r,fix_r_rnd_dec);
				fix 	= ql_fix_infl_ci_leg(fix_def,"ci_fix_leg",trade_date,settle_date,start_date,maturity,mat_code,
											pay_fixed,fix_notional,fix_eff_date,fix_first_cpn_date,fix_last_reg_date,fix_r,	
											fix_disc_func,cpi_l,cpi_l_f,cpn_roll_day,fix_fx_rate);
				sw 		= ql_fixed_income_swap(fix,flt,instrument_name);

			}

			return swap_il_rr_fixflt(sw, error);						
		}
		catch {
			CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt");
			return null<swap_il_rr_fixflt>;
		}
	}
}


/*-----------------------------------------------------------------------
  func: swap_il_rr_fixflt_plain
  minimal constructor for single curr "screen"-swap,
  this version: fwd_func input
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt_plain(	instr_def 					def,
								string 						instrument_name,	
								date option(nullable) 		trade_date,	
								date option(nullable) 		start_date,			//start_date has precedence over start_date_code
								string option(nullable) 	start_date_code,
								date option(nullable)		maturity,			//maturity has precedence over mat_code
								string 	option(nullable)	maturity_code,																													
								number option(nullable)		fix_coupon_rate ,//if null --> will be set to par 									
								number 	 					notional,																										
								logical 					pay_fixed,
								cpi_link 					cpi_l ,
								cpi_link option(nullable)	cpi_l_f,
								..disc_func option(nullable) fix_disc_func,
								..disc_func option(nullable) flt_disc_func,
								fwd_func option(nullable) 	flt_fwd_func,																																			
							    number option(nullable) 	curr_fix,
								integer fix_r_rnd_dec,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{
	return CORE_INT_IL_FIXFLT.swap_il_rr_fixflt_plain_int(def,instrument_name,trade_date,start_date,start_date_code,maturity,maturity_code,
								 fix_coupon_rate ,notional, pay_fixed,cpi_l,cpi_l_f,fix_disc_func,flt_disc_func,flt_fwd_func, null<disc_func>,
								 curr_fix, fix_r_rnd_dec,error );
}

/*-----------------------------------------------------------------------
  func: swap_il_rr_fixflt_plain
  minimal constructor for single curr "screen"-swap,
  this version: disc_func  input
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt_plain(	instr_def 					def,
								string 						instrument_name,	
								date option(nullable) 		trade_date,	
								date option(nullable) 		start_date,			//start_date has precedence over start_date_code
								string option(nullable) 	start_date_code,
								date option(nullable)		maturity,			//maturity has precedence over mat_code
								string 	option(nullable)	maturity_code,																													
								number option(nullable)		fix_coupon_rate ,//if null --> will be set to par 									
								number 	 					notional,																										
								logical 					pay_fixed,
								cpi_link 					cpi_l ,
								cpi_link option(nullable)	cpi_l_f,
								..disc_func option(nullable) fix_disc_func,
								..disc_func option(nullable) flt_disc_func,								
								disc_func option(nullable) 	flt_fwd_disc_func,																																			
							    number option(nullable) 	curr_fix,
								integer fix_r_rnd_dec,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{
	return CORE_INT_IL_FIXFLT.swap_il_rr_fixflt_plain_int(def,instrument_name,trade_date,start_date,start_date_code,maturity,maturity_code,
								 fix_coupon_rate ,notional, pay_fixed,cpi_l,cpi_l_f,fix_disc_func,flt_disc_func,null<fwd_func>, flt_fwd_disc_func,
								 curr_fix, fix_r_rnd_dec,error );
}


/*-----------------------------------------------------------------------
  func: swap_il_rr_fixflt_plain
  minimal constructor for single curr "screen"-swap,
  this version: template + fwd_func + maturity input
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt_plain(	INSTR_TMPL.swap_rr_fixflt_def_tmpl	tmpl,
								string 						instrument_name,	
								date option(nullable) 		trade_date,	
								string option(nullable) 	fwd_start_code,//if tmpl have a code it is ignored
								string option(nullable)		maturity_code,//if tmpl have a code it is ignored																												
								number option(nullable)		fix_coupon_rate ,//if null --> will be set to par 									
								number 	 					notional,																										
								logical 					pay_fixed,
								cpi_link 					cpi_l ,
								cpi_link option(nullable)	cpi_l_f,
								..disc_func option(nullable) fix_disc_func,
								..disc_func option(nullable) flt_disc_func,									
								fwd_func option(nullable) 	flt_fwd_func,																																			
							    number option(nullable) 	curr_fix,
								integer fix_r_rnd_dec,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{
	try{		
		instr_def def = instr_def_il_rr_swap_fixflt(tmpl,fwd_start_code,maturity_code,error);		
		if(!CORE_INT.check_instr_def(def))
			return null<swap_il_rr_fixflt>;
		return swap_il_rr_fixflt_plain(	def,instrument_name,trade_date,null<date>,fwd_start_code,
									null<date>,maturity_code,fix_coupon_rate ,
									notional,pay_fixed,cpi_l,cpi_l_f,fix_disc_func,flt_disc_func,flt_fwd_func,curr_fix,fix_r_rnd_dec,error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt");
		return null<swap_il_rr_fixflt>;
	}
}

swap_il_rr_fixflt swap_il_rr_fixflt_plain(	INSTR_TMPL.swap_rr_fixflt_def_tmpl	tmpl,
								string 						instrument_name,	
								date option(nullable) 		trade_date,	
								date option(nullable) 		start_date,//if tmpl have a code it is ignored
								date option(nullable)		maturity,//if tmpl have a code it is ignored																												
								number option(nullable)		fix_coupon_rate ,//if null --> will be set to par 									
								number 	 					notional,																										
								logical 					pay_fixed,
								cpi_link 					cpi_l ,
								cpi_link option(nullable)	cpi_l_f,
								..disc_func option(nullable) fix_disc_func,
								..disc_func option(nullable) flt_disc_func,								
								fwd_func option(nullable) 	flt_fwd_func,																																			
							    number option(nullable) 	curr_fix,
								integer fix_r_rnd_dec,
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{
	try{		
		instr_def def = instr_def_il_rr_swap_fixflt(tmpl,error);		
		if(!CORE_INT.check_instr_def(def))
			return null<swap_il_rr_fixflt>;
		return swap_il_rr_fixflt_plain(	def,instrument_name,trade_date,start_date,null<string>,
									maturity,null<string>,fix_coupon_rate ,
									notional,pay_fixed,cpi_l,cpi_l_f,fix_disc_func,flt_disc_func,flt_fwd_func,curr_fix,fix_r_rnd_dec,error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt");
		return null<swap_il_rr_fixflt>;
	}
}

/*-----------------------------------------------------------------------
  func: swap_il_rr_fixflt_plain
  this version: using instr_def
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt_plain(	instr_def 				instr_def, 
											string 					instrument_name  ,			
											date  option(nullable) 	start_date,
											date  option(nullable)	maturity,
											integer					cpn_roll_day,
											date option(nullable) 	fix_eff_date,
											date  option(nullable)	fix_first_cpn_date,
											date  option(nullable)	fix_last_reg_date,														
											number  				fix_coupon_rate ,									
											number 	 				fix_notional,
											date option(nullable) 	flt_eff_date,
											date  option(nullable)	flt_first_cpn_date,
											date  option(nullable)	flt_last_reg_date,
											number					flt_spread,							
											number 	option(nullable) flt_notional,
					
											date option(nullable) 		trade_date ,
											date option(nullable) 		settle_date ,
											logical 					pay_fixed,
											cpi_link 					cpi_l ,
											cpi_link option(nullable)	cpi_l_f,
											
											disc_func option(nullable) 	fix_disc_func,
											number option(nullable) 	fix_fx_rate,//as of settle
											fwd_func option(nullable) 	flt_fwd_func,	
											disc_func option(nullable) 	flt_disc_func,						
											number option(nullable) 	flt_fx_rate,//as of settle						
											vector(date) option(nullable) 	fixing_dates,	
											vector(number) option(nullable) fixing_rates,
											//number option(nullable) first_fixing,
											//number option(nullable) last_fixing,
											number option(nullable) 	fix_proxy, 
											logical  option(nullable) 	allow_fwd_fix,
											error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{	
	try{
		QL_FAIL_COND(!instr_def.is_il_rr_swap_fixflt(), "instr_def not a real rate fix-float swap", E_INIT);

		//---def---
		logical is_ccy				= instr_def.is_ccy_swap();

		error_info ee 				= error_info(true,true);
		notional_exchg_style ne 	= instr_def.swap_not_exchange(ee);
		
		if(null(ne))
			ne 	= is_ccy ? NE_BOTH : NE_END;		

		date_code settle_code 		= date_code(instr_def.settle_code());
		coupon_freq  fix_cpn_freq 	= coupon_freq_from_int(instr_def.coupon_freq(ee))  ;		
		calendar pmt_calendar		= instr_def.swap_calendar_leg1(ee);
		bd_convention pmt_bus_day 	= instr_def.swap_pmt_bus_day_leg1(ee);
		logical	end_of_month		= instr_def.swap_eom_leg1(ee);		
		fix_roll_method	rm			= fix_roll_method.FIR_STRAIGHT;					
		number pmt_delay			= instr_def.swap_pmt_lag_leg1(ee);
		number mat_pmt_delay		= pmt_delay;
		infl_index_method index_method = instr_def.il_index_method(ee);
		
		logical constant_coupon 	= false ;
		fix_comp_freq compound_freq = null<fix_comp_freq>;
		quote_style qs 				= null<quote_style>;	
		round_code pv_round_code	= null<round_code>;
		logical start_stub_decomp 	= null<logical> ;
		logical end_stub_decomp 	= null<logical> ;
		interest_rule ir_rule 		= null<interest_rule>;						
		logical average_notional 	= null<logical> ;
		logical compound_to_mat 	= null<logical> ;			
		logical redemp_par 			= null<logical>;

		ql_swap_fix_infl_ci_def fix_def 	= ql_swap_fix_infl_ci_def("ci_fix_def", instr_def.swap_currency_leg1(ee), settle_code, fix_cpn_freq,
																		instr_def.swap_dc_method_leg1(ee),rm, pmt_bus_day,pmt_calendar,	
																		end_of_month,constant_coupon, compound_freq,qs,pv_round_code,
																		start_stub_decomp, end_stub_decomp,ir_rule,pmt_delay, mat_pmt_delay,
																		ne,average_notional,compound_to_mat, index_method,redemp_par);

		flt_reset_style reset_style = RS_NORM;
		coupon_freq  flt_cpn_freq 	= coupon_freq_from_int(instr_def.swap_coupon_freq_leg2(ee))  ;
		reset_freq  flt_r_freq 		= reset_freq_from_int(instr_def.swap_reset_freq_leg2(ee))  ;
		ir_index flt_ir_index 		= instr_def.swap_ir_index_leg2(ee);
		flt_comp_avg_type flt_ca_t	= instr_def.swap_comp_avg_type_leg2(ee);
		flt_sprd_comp_method flt_comp_m = instr_def.swap_sprd_comp_method_leg2(ee);
		flt_avg_method flt_avg 		= instr_def.swap_avg_method_leg2(ee);
		flt_stub_fwd_style	flt_stub_style = null; //FIX_ME
			
		ql_swap_float_def flt_def 	= ql_swap_float_def("float_def",instr_def.swap_currency_leg2(ee),settle_code,
														flt_cpn_freq,flt_r_freq,instr_def.swap_dc_method_leg2(ee),pmt_bus_day,
														pmt_calendar,end_of_month,
														flt_ca_t,flt_comp_m,flt_avg,flt_stub_style,
														flt_ir_index,reset_style,ne);

		//---leg---
		CORE_INT_SWAPLIB.swap_start_date_helper(settle_code,trade_date,pmt_calendar,instr_def.fwd_start_code(ee),true,start_date,settle_date);
		QL_FAIL_COND(null(settle_date),"invalid start date", E_INIT);

		tenor_code mat_code = CORE_INT_SWAPLIB.swap_maturity_helper(instr_def,maturity, null<string>);
	
		if(null(fix_fx_rate)) 
			fix_fx_rate = 1;
		
	
		ql_fix_infl_ci_leg fix = ql_fix_infl_ci_leg(fix_def,"ci_fix_leg",trade_date,settle_date,start_date,maturity,mat_code,
															pay_fixed,fix_notional,fix_eff_date, fix_first_cpn_date,fix_last_reg_date,
															 fix_coupon_rate, fix_disc_func,cpi_l,cpi_l_f,cpn_roll_day,fix_fx_rate);
		
		
		if(null(flt_notional) && !is_ccy) 
			flt_notional = fix_notional;
		if(null(flt_fx_rate)) 
			flt_fx_rate = 1;

		logical allow_extrap = false;
		tenor_surface flt_tenor_surface;
		try {
			flt_tenor_surface = tenor_surface(trade_date, flt_disc_func,[flt_fwd_func],[flt_ir_index],allow_extrap);
		}
		catch {
			flt_tenor_surface = null<tenor_surface>;
		}

		number flt_fixing_start_stub = null;
		number flt_start_stub_sprd = null;
		number flt_fixing_end_stub = null;
		number flt_end_stub_sprd = null;
		number flt_comp_spread = null;
		ql_float_leg flt 				= ql_float_leg(flt_def,"float_leg",trade_date,settle_date,start_date,maturity,mat_code,
														!pay_fixed,flt_notional,flt_eff_date,flt_first_cpn_date,flt_last_reg_date,flt_spread,flt_disc_func,	
														flt_tenor_surface,cpn_roll_day,flt_fx_rate,
														fixing_dates,fixing_rates,fix_proxy,allow_fwd_fix,
													   flt_fixing_start_stub,flt_start_stub_sprd,flt_fixing_end_stub,flt_end_stub_sprd,flt_comp_spread);
		
		ql_fixed_income_swap sw 		= ql_fixed_income_swap(fix,flt,instrument_name);

		return swap_il_rr_fixflt(sw, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt_plain");
		return null<swap_il_rr_fixflt>;
	}
}