/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	swap_il_rr_fixois create funcs
	--------------------------------------------------------------------			
*/


//--------
// from db
//--------
/*-----------------------------------------------------------------------
  swap_il_rr_fixois
  ----------------------------------------------------------------------*/
swap_il_rr_fixois swap_il_rr_fixois(instrument_name 			instrument_name, 
									date option(nullable) 	trade_date 	= null<date>,
									string option(nullable) quote_side 	= null<string>,
									error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Fixed vs Float")
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_swap_il_rr_fixois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixois");
		return null<swap_il_rr_fixois>;
	}
}


/*-----------------------------------------------------------------------
  swap_il_rr_fixois
  ----------------------------------------------------------------------*/
swap_il_rr_fixois swap_il_rr_fixois(instrument_name 			instrument_name, 
									date option(nullable) 		trade_date ,
									number  option(nullable) 	quote ,
									error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Fixed vs Float")
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_swap_il_rr_fixois(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixois");
		return null<swap_il_rr_fixois>;
	}
}


/*-----------------------------------------------------------------------
  swap_il_rr_fixois
  ----------------------------------------------------------------------*/
swap_il_rr_fixois swap_il_rr_fixois(instr_def 				instr_def, 
									date option(nullable) 	trade_date 	= null<date>,
									string option(nullable) quote_side 	= null<string>,
									error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Fixed vs Float")
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_swap_il_rr_fixois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixois");
		return null<swap_il_rr_fixois>;
	}
}
/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
swap_il_rr_fixois swap_il_rr_fixois(instr_def 					instr_def, 
									date option(nullable) 		trade_date ,
									number  option(nullable) 	quote ,
									error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Fixed vs Float")
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_swap_il_rr_fixois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixois");
		return null<swap_il_rr_fixois>;
	}
}


//----------------
// from db or not
//----------------

/*-----------------------------------------------------------------------
  func: swap_il_rr_fixois
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name

  ----------------------------------------------------------------------*/
swap_il_rr_fixois swap_il_rr_fixois(instr_def 				instr_def, 
										string 					instrument_name  ,
										date option(nullable) 	trade_date ,
										date option(nullable) 	settle_date ,							
										date  option(nullable) 	maturity,//maturity has precedence over mat_code
										string option(nullable) maturity_code,
										number option(nullable)	fix_rate,
										..cpi_link				cpi_link,
										..cpi_link	option(nullable)	cpi_link_fcast,
										//number					cpi_base,						
										number 					nominal=100,
										error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{	
	try{
		__instrument c;
		if(!null(maturity))
		{}//c = __instrument_il_fixois_nodb(instr_def,instrument_name,trade_date,settle_date, maturity,fix_rate,cpi_link,cpi_link_fcast,nominal );
		else if(!null(maturity_code))
			{}//c = __instrument_il_fixois_par_nodb(instr_def,instrument_name,trade_date,settle_date, maturity_code,fix_rate,cpi_link,cpi_link_fcast,nominal );
		else
			QL_FAIL("invalid maturity/maturity_code");		
		return create_swap_il_rr_fixois( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixois");
		return null<swap_il_rr_fixois>;
	}
}

//----------------
// no db, swaplib version
// an external swap is created. Note: an external swap has no internal instr_def
// but can be created from an instr_def
//----------------

/*-----------------------------------------------------------------------
  func: swap_il_rr_fixois
  ----------------------------------------------------------------------*/
swap_il_rr_fixois swap_il_rr_fixois(ql_fixed_income_swap ql_fixed_income_swap,
						error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Inflation Linked/Real Rate Fixed vs Float')
{	
	try{	
		QL_FAIL_COND(CORE_INT.swap_instr_type(ql_fixed_income_swap) != instr_type.IL_SWAP_REAL_FIXOIS, "invalid instrument type", E_INIT);

		__instrument c = __instrument_swap(ql_fixed_income_swap);

		return create_swap_il_rr_fixois(c, error);				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixois");
		return null<swap_il_rr_fixois>;
	}
}


/*-----------------------------------------------------------------------
  func: swap_il_rr_fixois
  ----------------------------------------------------------------------*/
swap_il_rr_fixois swap_il_rr_fixois(ql_fix_infl_ci_leg 		ql_fix_leg, 							
									ql_ois_leg 			ql_ois_leg,
									string 					id,
									error_info option(nullable) error = null<error_info>)
option (category: 'Curve and Instrument/Inflation Linked/Real Rate Fixed vs Float')
{	
	try{			
		__instrument c = __instrument_swap(ql_fix_leg,ql_ois_leg,id);

		return create_swap_il_rr_fixois(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixois");
		return null<swap_il_rr_fixois>;
	}
}