/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	il_zero_bond create funcs
	--------------------------------------------------------------------			
*/

option(null: hard);	


//--------
// from db
//--------
/*-----------------------------------------------------------------------
  il_zero_bond
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond(	instrument_name 			instrument_name, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							date option(nullable) 	settle_date = null<date>,
							error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Zero Bond")
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, settle_date );		
		return create_il_zero_bond(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "il_zero_bond");
		return null<il_zero_bond>;
	}
}


/*-----------------------------------------------------------------------
  il_zero_bond
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond(	instrument_name 			instrument_name, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							date option(nullable) 		settle_date = null<date>,
							error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Zero Bond")
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, settle_date );
		return create_il_zero_bond(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "il_zero_bond");
		return null<il_zero_bond>;
	}
}


/*-----------------------------------------------------------------------
  il_zero_bond
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond(	instr_def 					instr_def, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							date option(nullable) 	settle_date = null<date>,
							error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Zero Bond")
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, settle_date );
		return create_il_zero_bond(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "il_zero_bond");
		return null<il_zero_bond>;
	}
}
/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond(	instr_def 					instr_def, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							date option(nullable) 		settle_date = null<date> ,
							error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Zero Bond")
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, settle_date );
		return create_il_zero_bond(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "il_zero_bond");
		return null<il_zero_bond>;
	}
}

//----------------
// from db or not
//----------------


/*-----------------------------------------------------------------------
  func: il_zero_bond
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name

  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond(	instr_def 				instr_def, 
							string 					instrument_name  ,			
							date  					issue_date,							
							date  					maturity,								
							date option(nullable) 	trade_date ,
							date option(nullable) 	settle_date ,
							number option(nullable) quote ,
							quote_style option(nullable) quote_style,
							cpi_link 				cpi_link,
							number 					cpi_base,
							number 	option(nullable) nominal=100,
							error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Zero Bond")
{	
	try{			
		__instrument c = __instrument_zeroil_nodb(instr_def,instrument_name,issue_date,maturity,trade_date,
												settle_date,quote,quote_style,cpi_link, cpi_base,nominal );

		return create_il_zero_bond( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "il_zero_bond");
		return null<il_zero_bond>;
	}
}
 




